/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.asm.FMLSanityChecker;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.SharedDrawable;
import org.lwjgl.util.glu.GLU;

public class SplashProgress {
    private static Drawable d;
    private static volatile boolean pause;
    private static volatile boolean done;
    private static Thread thread;
    private static volatile Throwable threadError;
    private static int angle;
    private static final Lock lock;
    private static SplashFontRenderer fontRenderer;
    private static final bxf mcPack;
    private static final bxf fmlPack;
    private static bxf miscPack;
    private static Texture fontTexture;
    private static Texture logoTexture;
    private static Texture forgeTexture;
    private static Properties config;
    private static boolean enabled;
    private static boolean rotate;
    private static int logoOffset;
    private static int backgroundColor;
    private static int fontColor;
    private static int barBorderColor;
    private static int barColor;
    private static int barBackgroundColor;
    static final Semaphore mutex;
    private static int max_texture_size;
    private static final IntBuffer buf;

    private static String getString(String name, String def) {
        String value = config.getProperty(name, def);
        config.setProperty(name, value);
        return value;
    }

    private static boolean getBool(String name, boolean def) {
        return Boolean.parseBoolean(SplashProgress.getString(name, Boolean.toString(def)));
    }

    private static int getInt(String name, int def) {
        return Integer.decode(SplashProgress.getString(name, Integer.toString(def)));
    }

    private static int getHex(String name, int def) {
        return Integer.decode(SplashProgress.getString(name, "0x" + Integer.toString(def, 16).toUpperCase()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        File configFile = new File(bcx.z().w, "config/splash.properties");
        File parent = configFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        FileReader r2 = null;
        config = new Properties();
        try {
            r2 = new FileReader(configFile);
            config.load(r2);
        }
        catch (IOException e) {
            try {
                FMLLog.info("Could not load splash.properties, will create a default one", new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(r2);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)r2);
        }
        IOUtils.closeQuietly((Reader)r2);
        boolean defaultEnabled = !System.getProperty("os.name").toLowerCase().contains("mac");
        enabled = SplashProgress.getBool("enabled", defaultEnabled) && (!FMLClientHandler.instance().hasOptifine() || Launch.blackboard.containsKey("optifine.ForgeSplashCompatible"));
        rotate = SplashProgress.getBool("rotate", false);
        logoOffset = SplashProgress.getInt("logoOffset", 0);
        backgroundColor = SplashProgress.getHex("background", 0xFFFFFF);
        fontColor = SplashProgress.getHex("font", 0);
        barBorderColor = SplashProgress.getHex("barBorder", 0xC0C0C0);
        barColor = SplashProgress.getHex("bar", 13319477);
        barBackgroundColor = SplashProgress.getHex("barBackground", 0xFFFFFF);
        final kn fontLoc = new kn(SplashProgress.getString("fontTexture", "textures/font/ascii.png"));
        final kn logoLoc = new kn(SplashProgress.getString("logoTexture", "textures/gui/title/mojang.png"));
        final kn forgeLoc = new kn(SplashProgress.getString("forgeTexture", "fml:textures/gui/forge.gif"));
        File miscPackFile = new File(bcx.z().w, SplashProgress.getString("resourcePackPath", "resources"));
        FileWriter w = null;
        try {
            w = new FileWriter(configFile);
            config.store(w, "Splash screen properties");
        }
        catch (IOException e) {
            try {
                FMLLog.log(Level.ERROR, e, "Could not save the splash.properties file", new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(w);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)w);
        }
        IOUtils.closeQuietly((Writer)w);
        miscPack = SplashProgress.createResourcePack(miscPackFile);
        if (!enabled) {
            return;
        }
        FMLCommonHandler.instance().registerCrashCallable(new ICrashCallable(){

            public String call() throws Exception {
                return "' Vendor: '" + GL11.glGetString((int)7936) + "' Version: '" + GL11.glGetString((int)7938) + "' Renderer: '" + GL11.glGetString((int)7937) + "'";
            }

            @Override
            public String getLabel() {
                return "GL info";
            }
        });
        b report = b.a((Throwable)new Throwable(){

            @Override
            public String getMessage() {
                return "This is just a prompt for computer specs to be printed. THIS IS NOT A ERROR";
            }

            @Override
            public void printStackTrace(PrintWriter s) {
                s.println(this.getMessage());
            }

            @Override
            public void printStackTrace(PrintStream s) {
                s.println(this.getMessage());
            }
        }, (String)"Loading screen debug info");
        System.out.println(report.e());
        try {
            d = new SharedDrawable(Display.getDrawable());
            Display.getDrawable().releaseContext();
            d.makeCurrent();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            SplashProgress.disableSplash((Exception)((Object)e));
        }
        SplashProgress.getMaxTextureSize();
        thread = new Thread(new Runnable(){
            private final int barWidth = 400;
            private final int barHeight = 20;
            private final int textHeight2 = 20;
            private final int barOffset = 55;

            @Override
            public void run() {
                this.setGL();
                fontTexture = new Texture(fontLoc);
                logoTexture = new Texture(logoLoc, false);
                forgeTexture = new Texture(forgeLoc);
                GL11.glEnable((int)3553);
                fontRenderer = new SplashFontRenderer();
                GL11.glDisable((int)3553);
                while (!done) {
                    ProgressManager.ProgressBar first = null;
                    ProgressManager.ProgressBar penult = null;
                    ProgressManager.ProgressBar last = null;
                    Iterator<ProgressManager.ProgressBar> i = ProgressManager.barIterator();
                    while (i.hasNext()) {
                        if (first == null) {
                            first = i.next();
                            continue;
                        }
                        penult = last;
                        last = i.next();
                    }
                    GL11.glClear((int)16384);
                    int w = Display.getWidth();
                    int h2 = Display.getHeight();
                    GL11.glViewport((int)0, (int)0, (int)w, (int)h2);
                    GL11.glMatrixMode((int)5889);
                    GL11.glLoadIdentity();
                    GL11.glOrtho((double)(320 - w / 2), (double)(320 + w / 2), (double)(240 + h2 / 2), (double)(240 - h2 / 2), (double)-1.0, (double)1.0);
                    GL11.glMatrixMode((int)5888);
                    GL11.glLoadIdentity();
                    this.setColor(backgroundColor);
                    GL11.glEnable((int)3553);
                    logoTexture.bind();
                    GL11.glBegin((int)7);
                    logoTexture.texCoord(0, 0.0f, 0.0f);
                    GL11.glVertex2f((float)64.0f, (float)-16.0f);
                    logoTexture.texCoord(0, 0.0f, 1.0f);
                    GL11.glVertex2f((float)64.0f, (float)496.0f);
                    logoTexture.texCoord(0, 1.0f, 1.0f);
                    GL11.glVertex2f((float)576.0f, (float)496.0f);
                    logoTexture.texCoord(0, 1.0f, 0.0f);
                    GL11.glVertex2f((float)576.0f, (float)-16.0f);
                    GL11.glEnd();
                    GL11.glDisable((int)3553);
                    if (first != null) {
                        GL11.glPushMatrix();
                        GL11.glTranslatef((float)120.0f, (float)310.0f, (float)0.0f);
                        this.drawBar(first);
                        if (penult != null) {
                            GL11.glTranslatef((float)0.0f, (float)55.0f, (float)0.0f);
                            this.drawBar(penult);
                        }
                        if (last != null) {
                            GL11.glTranslatef((float)0.0f, (float)55.0f, (float)0.0f);
                            this.drawBar(last);
                        }
                        GL11.glPopMatrix();
                    }
                    angle = angle + 1;
                    this.setColor(backgroundColor);
                    float fw2 = (float)forgeTexture.getWidth() / 2.0f / 2.0f;
                    float fh = (float)forgeTexture.getHeight() / 2.0f / 2.0f;
                    if (rotate) {
                        float sh2 = Math.max(fw2, fh);
                        GL11.glTranslatef((float)((float)(320 + w / 2) - sh2 - (float)logoOffset), (float)((float)(240 + h2 / 2) - sh2 - (float)logoOffset), (float)0.0f);
                        GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                    } else {
                        GL11.glTranslatef((float)((float)(320 + w / 2) - fw2 - (float)logoOffset), (float)((float)(240 + h2 / 2) - fh - (float)logoOffset), (float)0.0f);
                    }
                    int f = angle / 10 % forgeTexture.getFrames();
                    GL11.glEnable((int)3553);
                    forgeTexture.bind();
                    GL11.glBegin((int)7);
                    forgeTexture.texCoord(f, 0.0f, 0.0f);
                    GL11.glVertex2f((float)(-fw2), (float)(-fh));
                    forgeTexture.texCoord(f, 0.0f, 1.0f);
                    GL11.glVertex2f((float)(-fw2), (float)fh);
                    forgeTexture.texCoord(f, 1.0f, 1.0f);
                    GL11.glVertex2f((float)fw2, (float)fh);
                    forgeTexture.texCoord(f, 1.0f, 0.0f);
                    GL11.glVertex2f((float)fw2, (float)(-fh));
                    GL11.glEnd();
                    GL11.glDisable((int)3553);
                    mutex.acquireUninterruptibly();
                    Display.update();
                    mutex.release();
                    if (pause) {
                        this.clearGL();
                        this.setGL();
                    }
                    Display.sync((int)100);
                }
                this.clearGL();
            }

            private void setColor(int color) {
                GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
            }

            private void drawBox(int w, int h2) {
                GL11.glBegin((int)7);
                GL11.glVertex2f((float)0.0f, (float)0.0f);
                GL11.glVertex2f((float)0.0f, (float)h2);
                GL11.glVertex2f((float)w, (float)h2);
                GL11.glVertex2f((float)w, (float)0.0f);
                GL11.glEnd();
            }

            private void drawBar(ProgressManager.ProgressBar b2) {
                GL11.glPushMatrix();
                this.setColor(fontColor);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
                GL11.glEnable((int)3553);
                fontRenderer.a(b2.getTitle() + " - " + b2.getMessage(), 0, 0, 0);
                GL11.glDisable((int)3553);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)20.0f, (float)0.0f);
                this.setColor(barBorderColor);
                this.drawBox(400, 20);
                this.setColor(barBackgroundColor);
                GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
                this.drawBox(398, 18);
                this.setColor(barColor);
                this.drawBox(398 * (b2.getStep() + 1) / (b2.getSteps() + 1), 18);
                String progress = "" + b2.getStep() + "/" + b2.getSteps();
                GL11.glTranslatef((float)(199.0f - (float)fontRenderer.a(progress)), (float)2.0f, (float)0.0f);
                this.setColor(fontColor);
                GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
                GL11.glEnable((int)3553);
                fontRenderer.a(progress, 0, 0, 0);
                GL11.glPopMatrix();
            }

            private void setGL() {
                lock.lock();
                try {
                    Display.getDrawable().makeCurrent();
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                GL11.glClearColor((float)((float)(backgroundColor >> 16 & 0xFF) / 255.0f), (float)((float)(backgroundColor >> 8 & 0xFF) / 255.0f), (float)((float)(backgroundColor & 0xFF) / 255.0f), (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }

            private void clearGL() {
                bcx mc = bcx.z();
                mc.d = Display.getWidth();
                mc.e = Display.getHeight();
                mc.a(mc.d, mc.e);
                GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)2929);
                GL11.glDepthFunc((int)515);
                GL11.glEnable((int)3008);
                GL11.glAlphaFunc((int)516, (float)0.1f);
                try {
                    Display.getDrawable().releaseContext();
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                finally {
                    lock.unlock();
                }
            }
        });
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                FMLLog.log(Level.ERROR, e, "Splash thread Exception", new Object[0]);
                threadError = e;
            }
        });
        thread.start();
        SplashProgress.checkThreadState();
    }

    public static int getMaxTextureSize() {
        if (max_texture_size != -1) {
            return max_texture_size;
        }
        for (int i = 16384; i > 0; i >>= 1) {
            bob.a((int)32868, (int)0, (int)6408, (int)i, (int)i, (int)0, (int)6408, (int)5121, null);
            if (bob.c((int)32868, (int)0, (int)4096) == 0) continue;
            max_texture_size = i;
            return i;
        }
        return -1;
    }

    private static void checkThreadState() {
        if (thread.getState() == Thread.State.TERMINATED || threadError != null) {
            throw new IllegalStateException("Splash thread", threadError);
        }
    }

    @Deprecated
    public static void pause() {
        if (!enabled) {
            return;
        }
        SplashProgress.checkThreadState();
        pause = true;
        lock.lock();
        try {
            d.releaseContext();
            Display.getDrawable().makeCurrent();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static void resume() {
        if (!enabled) {
            return;
        }
        SplashProgress.checkThreadState();
        pause = false;
        try {
            Display.getDrawable().releaseContext();
            d.makeCurrent();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        lock.unlock();
    }

    public static void finish() {
        if (!enabled) {
            return;
        }
        try {
            SplashProgress.checkThreadState();
            done = true;
            thread.join();
            d.releaseContext();
            Display.getDrawable().makeCurrent();
            fontTexture.delete();
            logoTexture.delete();
            forgeTexture.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            SplashProgress.disableSplash(e);
        }
    }

    private static boolean disableSplash(Exception e) {
        if (SplashProgress.disableSplash()) {
            throw new EnhancedRuntimeException(e){

                @Override
                protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                    stream.println("SplashProgress has detected a error loading Minecraft.");
                    stream.println("This can sometimes be caused by bad video drivers.");
                    stream.println("We have automatically disabled the new Splash Screen in config/splash.properties.");
                    stream.println("Try reloading minecraft before reporting any errors.");
                }
            };
        }
        throw new EnhancedRuntimeException(e){

            @Override
            protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                stream.println("SplashProgress has detected a error loading Minecraft.");
                stream.println("This can sometimes be caused by bad video drivers.");
                stream.println("Please try disabling the new Splash Screen in config/splash.properties.");
                stream.println("After doing so, try reloading minecraft before reporting any errors.");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean disableSplash() {
        File configFile = new File(bcx.z().w, "config/splash.properties");
        File parent = configFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        enabled = false;
        config.setProperty("enabled", "false");
        FileWriter w = null;
        try {
            w = new FileWriter(configFile);
            config.store(w, "Splash screen properties");
        }
        catch (IOException e) {
            boolean bl;
            try {
                FMLLog.log(Level.ERROR, e, "Could not save the splash.properties file", new Object[0]);
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(w);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)w);
            return bl;
        }
        IOUtils.closeQuietly((Writer)w);
        return true;
    }

    private static bxf createResourcePack(File file) {
        if (file.isDirectory()) {
            return new bwy(file);
        }
        return new bwx(file);
    }

    public static void drawVanillaScreen(bwf renderEngine) throws LWJGLException {
        if (!enabled) {
            bcx.z().a(renderEngine);
        }
    }

    public static void clearVanillaResources(bwf renderEngine, kn mojangLogo) {
        if (!enabled) {
            renderEngine.c(mojangLogo);
        }
    }

    public static void checkGLError(String where) {
        int err = GL11.glGetError();
        if (err != 0) {
            throw new IllegalStateException(where + ": " + GLU.gluErrorString((int)err));
        }
    }

    private static InputStream open(kn loc, boolean allowRP) throws IOException {
        if (!allowRP) {
            return mcPack.a(loc);
        }
        if (miscPack.b(loc)) {
            return miscPack.a(loc);
        }
        if (fmlPack.b(loc)) {
            return fmlPack.a(loc);
        }
        return mcPack.a(loc);
    }

    static {
        pause = false;
        done = false;
        angle = 0;
        lock = new ReentrantLock(true);
        mcPack = bcx.z().aC;
        fmlPack = SplashProgress.createResourcePack(FMLSanityChecker.fmlLocation);
        mutex = new Semaphore(1);
        max_texture_size = -1;
        buf = BufferUtils.createIntBuffer((int)0x400000);
    }

    private static class SplashFontRenderer
    extends bdl {
        public SplashFontRenderer() {
            super(bcx.z().u, fontTexture.getLocation(), null, false);
            super.a(null);
        }

        protected void bindTexture(kn location) {
            if (location != this.g) {
                throw new IllegalArgumentException();
            }
            fontTexture.bind();
        }

        protected bxc getResource(kn location) throws IOException {
            bwu pack = bcx.z().aC;
            return new bxj(pack.b(), location, pack.a(location), null, null);
        }
    }

    private static class Texture {
        private final kn location;
        private final int name;
        private final int width;
        private final int height;
        private final int frames;
        private final int size;

        public Texture(kn location) {
            this(location, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Texture(kn location, boolean allowRP) {
            InputStream s = null;
            try {
                this.location = location;
                s = SplashProgress.open(location, allowRP);
                ImageInputStream stream = ImageIO.createImageInputStream(s);
                Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
                if (!readers.hasNext()) {
                    throw new IOException("No suitable reader found for image" + location);
                }
                ImageReader reader = readers.next();
                reader.setInput(stream);
                this.frames = reader.getNumImages(true);
                BufferedImage[] images = new BufferedImage[this.frames];
                for (int i = 0; i < this.frames; ++i) {
                    images[i] = reader.read(i);
                }
                reader.dispose();
                int size = 1;
                this.width = images[0].getWidth();
                this.height = images[0].getHeight();
                while (size / this.width * (size / this.height) < this.frames) {
                    size *= 2;
                }
                this.size = size;
                GL11.glEnable((int)3553);
                Class<SplashProgress> clazz = SplashProgress.class;
                synchronized (SplashProgress.class) {
                    this.name = GL11.glGenTextures();
                    GL11.glBindTexture((int)3553, (int)this.name);
                    // ** MonitorExit[var9_10] (shouldn't be in output)
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)size, (int)size, (int)0, (int)32993, (int)33639, (IntBuffer)null);
                    SplashProgress.checkGLError("Texture creation");
                    int i = 0;
                    while (i * (size / this.width) < this.frames) {
                        for (int j2 = 0; i * (size / this.width) + j2 < this.frames && j2 < size / this.width; ++j2) {
                            buf.clear();
                            BufferedImage image = images[i * (size / this.width) + j2];
                            for (int k2 = 0; k2 < this.height; ++k2) {
                                for (int l2 = 0; l2 < this.width; ++l2) {
                                    buf.put(image.getRGB(l2, k2));
                                }
                            }
                            buf.position(0).limit(this.width * this.height);
                            GL11.glTexSubImage2D((int)3553, (int)0, (int)(j2 * this.width), (int)(i * this.height), (int)this.width, (int)this.height, (int)32993, (int)33639, (IntBuffer)buf);
                            SplashProgress.checkGLError("Texture uploading");
                        }
                        ++i;
                    }
                    GL11.glBindTexture((int)3553, (int)0);
                    GL11.glDisable((int)3553);
                }
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(s);
                    throw throwable;
                }
            }
            {
                IOUtils.closeQuietly((InputStream)s);
                return;
            }
        }

        public kn getLocation() {
            return this.location;
        }

        public int getName() {
            return this.name;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getFrames() {
            return this.frames;
        }

        public int getSize() {
            return this.size;
        }

        public void bind() {
            GL11.glBindTexture((int)3553, (int)this.name);
        }

        public void delete() {
            GL11.glDeleteTextures((int)this.name);
        }

        public float getU(int frame, float u) {
            return (float)this.width * ((float)(frame % (this.size / this.width)) + u) / (float)this.size;
        }

        public float getV(int frame, float v) {
            return (float)this.height * ((float)(frame / (this.size / this.width)) + v) / (float)this.size;
        }

        public void texCoord(int frame, float u, float v) {
            GL11.glTexCoord2f((float)this.getU(frame, u), (float)this.getV(frame, v));
        }
    }
}

