/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class UnpackedBakedQuad
extends brd {
    protected final float[][][] unpackedData;
    protected final bzj format;
    protected boolean packed = false;

    public UnpackedBakedQuad(float[][][] unpackedData, int tint, cv orientation, byz texture, boolean applyDiffuseLighting, bzj format) {
        super(new int[format.g()], tint, orientation, texture, applyDiffuseLighting, format);
        this.unpackedData = unpackedData;
        this.format = format;
    }

    public int[] b() {
        if (!this.packed) {
            this.packed = true;
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < this.format.i(); ++e) {
                    LightUtil.pack(this.unpackedData[v][e], this.a, this.format, v, e);
                }
            }
        }
        return this.a;
    }

    public void pipe(IVertexConsumer consumer) {
        int[] eMap = LightUtil.mapFormats(consumer.getVertexFormat(), this.format);
        if (this.c()) {
            consumer.setQuadTint(this.d());
        }
        consumer.setTexture(this.d);
        consumer.setApplyDiffuseLighting(this.applyDiffuseLighting);
        consumer.setQuadOrientation(this.e());
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < consumer.getVertexFormat().i(); ++e) {
                if (eMap[e] != this.format.i()) {
                    consumer.put(e, this.unpackedData[v][eMap[e]]);
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    public static class Builder
    implements IVertexConsumer {
        private final bzj format;
        private final float[][][] unpackedData;
        private int tint = -1;
        private cv orientation;
        private byz texture;
        private boolean applyDiffuseLighting = true;
        private int vertices = 0;
        private int elements = 0;
        private boolean full = false;
        private boolean contractUVs = false;
        private final float eps = 0.00390625f;

        public Builder(bzj format) {
            this.format = format;
            this.unpackedData = new float[4][format.i()][4];
        }

        @Override
        public bzj getVertexFormat() {
            return this.format;
        }

        public void setContractUVs(boolean value) {
            this.contractUVs = value;
        }

        @Override
        public void setQuadTint(int tint) {
            this.tint = tint;
        }

        @Override
        public void setQuadOrientation(cv orientation) {
            this.orientation = orientation;
        }

        @Override
        public void setTexture(byz texture) {
            this.texture = texture;
        }

        @Override
        public void setApplyDiffuseLighting(boolean diffuse) {
            this.applyDiffuseLighting = diffuse;
        }

        @Override
        public void put(int element, float ... data) {
            for (int i = 0; i < 4; ++i) {
                this.unpackedData[this.vertices][element][i] = i < data.length ? data[i] : 0.0f;
            }
            ++this.elements;
            if (this.elements == this.format.i()) {
                ++this.vertices;
                this.elements = 0;
            }
            if (this.vertices == 4) {
                this.full = true;
            }
        }

        public UnpackedBakedQuad build() {
            if (!this.full) {
                throw new IllegalStateException("not enough data");
            }
            if (this.texture == null) {
                throw new IllegalStateException("texture not set");
            }
            if (this.contractUVs) {
                int i;
                int v;
                bzk e;
                int uve;
                float tY;
                float tX = (float)this.texture.a() / this.texture.e();
                float tS = tX > (tY = (float)this.texture.b() / this.texture.g()) ? tX : tY;
                float ep = 1.0f / (tS * 256.0f);
                for (uve = 0; uve < this.format.i() && ((e = this.format.c(uve)).b() != bzk.b.d || e.d() != 0); ++uve) {
                }
                if (uve == this.format.i()) {
                    throw new IllegalStateException("Can't contract UVs: format doesn't contain UVs");
                }
                float[] uvc = new float[4];
                for (v = 0; v < 4; ++v) {
                    for (i = 0; i < 4; ++i) {
                        int n2 = i;
                        uvc[n2] = uvc[n2] + this.unpackedData[v][uve][i] / 4.0f;
                    }
                }
                for (v = 0; v < 4; ++v) {
                    for (i = 0; i < 4; ++i) {
                        float uo = this.unpackedData[v][uve][i];
                        float un = uo * 0.99609375f + uvc[i] * 0.00390625f;
                        float ud = uo - un;
                        float aud = ud;
                        if (aud < 0.0f) {
                            aud = -aud;
                        }
                        if (aud < ep) {
                            float udc = uo - uvc[i];
                            if (udc < 0.0f) {
                                udc = -udc;
                            }
                            un = udc < 2.0f * ep ? (uo + uvc[i]) / 2.0f : uo + (ud < 0.0f ? ep : -ep);
                        }
                        this.unpackedData[v][uve][i] = un;
                    }
                }
            }
            return new UnpackedBakedQuad(this.unpackedData, this.tint, this.orientation, this.texture, this.applyDiffuseLighting, this.format);
        }
    }
}

