/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeInternalHandler;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.oredict.OreDictionary;

public class MinecraftForge {
    public static final EventBus EVENT_BUS = new EventBus();
    public static final EventBus TERRAIN_GEN_BUS = new EventBus();
    public static final EventBus ORE_GEN_BUS = new EventBus();
    public static final String MC_VERSION = "1.11.2";
    static final ForgeInternalHandler INTERNAL_HANDLER = new ForgeInternalHandler();

    public static void addGrassSeed(@Nonnull afj seed, int weight) {
        MinecraftForge.addGrassSeed(new ForgeHooks.SeedEntry(seed, weight));
    }

    public static void addGrassSeed(ForgeHooks.SeedEntry seed) {
        ForgeHooks.seedList.add(seed);
    }

    public static void initialize() {
        FMLLog.log.info("MinecraftForge v{} Initialized", new Object[]{ForgeVersion.getVersion()});
        OreDictionary.getOreName(0);
        UsernameCache.load();
        FluidRegistry.validateFluidRegistry();
        ForgeHooks.initTools();
        new b("ThisIsFake", (Throwable)new Exception("Not real"));
    }

    public static void preloadCrashClasses(ASMDataTable table, String modID, Set<String> classes) {
        ArrayList all = Lists.newArrayList();
        for (ASMDataTable.ASMData asm : table.getAll(d.class.getName().replace('.', '/'))) {
            all.add(asm.getClassName());
        }
        for (ASMDataTable.ASMData asm : table.getAll(ICrashCallable.class.getName().replace('.', '/'))) {
            all.add(asm.getClassName());
        }
        all.retainAll(classes);
        if (all.size() == 0) {
            return;
        }
        ForgeModContainer.log.debug("Preloading CrashReport Classes");
        Collections.sort(all);
        for (String name : all) {
            ForgeModContainer.log.debug("\t{}", new Object[]{name});
            try {
                Class.forName(name.replace('/', '.'), false, MinecraftForge.class.getClassLoader());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

