/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import javax.annotation.Nonnull;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.oredict.OreDictionary;

public abstract class AbstractBrewingRecipe<T>
implements IBrewingRecipe {
    @Nonnull
    private final afj input;
    private final T ingredient;
    private final afj output;

    protected AbstractBrewingRecipe(@Nonnull afj input, @Nonnull T ingredient, @Nonnull afj output) {
        this.input = input;
        this.ingredient = ingredient;
        this.output = output;
        if (this.getInput().d() != 1) {
            throw new IllegalArgumentException("Inputs must have a max size of 1 just like water bottles. Brewing Stands override the input with the output when the brewing is done, items that stack would end up getting lost.");
        }
    }

    @Override
    public boolean isInput(@Nonnull afj stack) {
        return OreDictionary.itemMatches(this.getInput(), stack, false);
    }

    @Override
    @Nonnull
    public afj getOutput(@Nonnull afj input, @Nonnull afj ingredient) {
        return this.isInput(input) && this.isIngredient(ingredient) ? this.getOutput().l() : afj.a;
    }

    @Nonnull
    public afj getInput() {
        return this.input;
    }

    @Nonnull
    public T getIngredient() {
        return this.ingredient;
    }

    @Nonnull
    public afj getOutput() {
        return this.output;
    }
}

