/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.terraingen;

import java.util.Random;
import net.minecraftforge.event.world.WorldEvent;

public class InitNoiseGensEvent<T extends Context>
extends WorldEvent {
    private final Random rand;
    private final T original;
    private T newValues;

    public InitNoiseGensEvent(ajs world, Random rand, T original) {
        super(world);
        this.rand = rand;
        this.original = original;
        this.newValues = ((Context)original).clone();
    }

    public Random getRandom() {
        return this.rand;
    }

    public T getOriginal() {
        return this.original;
    }

    public T getNewValues() {
        return this.newValues;
    }

    public static class ContextHell
    extends Context {
        private azi perlin2;
        private azi perlin3;

        public ContextHell(azi lperlin1, azi lperlin2, azi perlin, azi perlin2, azi perlin3, azi scale, azi depth) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.perlin2 = perlin2;
            this.perlin3 = perlin3;
        }

        @Override
        public ContextHell clone() {
            return new ContextHell(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.perlin2, this.perlin3, this.getScale(), this.getDepth());
        }

        public azi getPerlin2() {
            return this.perlin2;
        }

        public azi getPerlin3() {
            return this.perlin3;
        }

        public void getPerlin2(azi value) {
            this.perlin2 = value;
        }

        public void getPerlin3(azi value) {
            this.perlin3 = value;
        }
    }

    public static class ContextEnd
    extends Context {
        private azm island;

        public ContextEnd(azi lperlin1, azi lperlin2, azi perlin, azi scale, azi depth, azm island) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.island = island;
        }

        @Override
        public ContextEnd clone() {
            return new ContextEnd(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.getScale(), this.getDepth(), this.island);
        }

        public azm getIsland() {
            return this.island;
        }

        public void getIsland(azm value) {
            this.island = value;
        }
    }

    public static class ContextOverworld
    extends Context {
        private azj height;
        private azi forest;

        public ContextOverworld(azi lperlin1, azi lperlin2, azi perlin, azj height, azi scale, azi depth, azi forest) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.height = height;
            this.forest = forest;
        }

        @Override
        public ContextOverworld clone() {
            return new ContextOverworld(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.height, this.getScale(), this.getDepth(), this.forest);
        }

        public azj getHeight() {
            return this.height;
        }

        public azi getForest() {
            return this.forest;
        }

        public void getHeight(azj value) {
            this.height = value;
        }

        public void getForest(azi value) {
            this.forest = value;
        }
    }

    public static class Context {
        private azi lperlin1;
        private azi lperlin2;
        private azi perlin;
        private azi scale;
        private azi depth;

        public Context(azi lperlin1, azi lperlin2, azi perlin, azi scale, azi depth) {
            this.lperlin1 = lperlin1;
            this.lperlin2 = lperlin2;
            this.perlin = perlin;
            this.scale = scale;
            this.depth = depth;
        }

        public azi getLPerlin1() {
            return this.lperlin1;
        }

        public azi getLPerlin2() {
            return this.lperlin2;
        }

        public azi getPerlin() {
            return this.perlin;
        }

        public azi getScale() {
            return this.scale;
        }

        public azi getDepth() {
            return this.depth;
        }

        public void setLPerlin1(azi value) {
            this.lperlin1 = value;
        }

        public void getLPerlin2(azi value) {
            this.lperlin2 = value;
        }

        public void getPerlin(azi value) {
            this.perlin = value;
        }

        public void getScale(azi value) {
            this.scale = value;
        }

        public void getDepth(azi value) {
            this.depth = value;
        }

        public Context clone() {
            return new Context(this.lperlin1, this.lperlin2, this.perlin, this.scale, this.depth);
        }
    }
}

