/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

public class FMLNetworkEvent<T extends ew>
extends Event {
    private final T handler;
    private final er manager;
    private final Class<T> type;

    FMLNetworkEvent(T thing, Class<T> type, er manager) {
        this.handler = thing;
        this.type = type;
        this.manager = manager;
    }

    public Class<T> getHandlerType() {
        return this.getType();
    }

    public T getHandler() {
        return this.handler;
    }

    public er getManager() {
        return this.manager;
    }

    public Class<T> getType() {
        return this.type;
    }

    public static class CustomNetworkEvent
    extends Event {
        private final Object wrappedEvent;

        public CustomNetworkEvent(Object wrappedEvent) {
            this.wrappedEvent = wrappedEvent;
        }

        public Object getWrappedEvent() {
            return this.wrappedEvent;
        }
    }

    public static class ServerCustomPacketEvent
    extends CustomPacketEvent<im> {
        public ServerCustomPacketEvent(er manager, FMLProxyPacket packet) {
            super((im)manager.i(), im.class, manager, packet);
        }

        @Override
        public Side side() {
            return Side.SERVER;
        }
    }

    public static class ClientCustomPacketEvent
    extends CustomPacketEvent<fp> {
        public ClientCustomPacketEvent(er manager, FMLProxyPacket packet) {
            super((fp)manager.i(), fp.class, manager, packet);
        }

        @Override
        public Side side() {
            return Side.CLIENT;
        }
    }

    public static abstract class CustomPacketEvent<S extends ew>
    extends FMLNetworkEvent<S> {
        private final FMLProxyPacket packet;
        private FMLProxyPacket reply;

        CustomPacketEvent(S thing, Class<S> type, er manager, FMLProxyPacket packet) {
            super(thing, type, manager);
            this.packet = packet;
        }

        public abstract Side side();

        public FMLProxyPacket getPacket() {
            return this.packet;
        }

        public FMLProxyPacket getReply() {
            return this.reply;
        }

        public void setReply(FMLProxyPacket reply) {
            this.reply = reply;
        }
    }

    public static class CustomPacketRegistrationEvent<S extends ew>
    extends FMLNetworkEvent<S> {
        private final ImmutableSet<String> registrations;
        private final String operation;
        private final Side side;

        public CustomPacketRegistrationEvent(er manager, Set<String> registrations, String operation, Side side, Class<S> type) {
            super((ew)type.cast(manager.i()), type, manager);
            this.registrations = ImmutableSet.copyOf(registrations);
            this.side = side;
            this.operation = operation;
        }

        public ImmutableSet<String> getRegistrations() {
            return this.registrations;
        }

        public String getOperation() {
            return this.operation;
        }

        public Side getSide() {
            return this.side;
        }
    }

    public static class ClientDisconnectionFromServerEvent
    extends FMLNetworkEvent<fp> {
        public ClientDisconnectionFromServerEvent(er manager) {
            super((fp)manager.i(), fp.class, manager);
        }
    }

    public static class ServerDisconnectionFromClientEvent
    extends FMLNetworkEvent<im> {
        public ServerDisconnectionFromClientEvent(er manager) {
            super((im)manager.i(), im.class, manager);
        }
    }

    public static class ServerConnectionFromClientEvent
    extends FMLNetworkEvent<im> {
        private final boolean isLocal;

        public ServerConnectionFromClientEvent(er manager) {
            super((im)manager.i(), im.class, manager);
            this.isLocal = manager.c();
        }

        public boolean isLocal() {
            return this.isLocal;
        }
    }

    public static class ClientConnectedToServerEvent
    extends FMLNetworkEvent<fp> {
        private final boolean isLocal;
        private final String connectionType;

        public ClientConnectedToServerEvent(er manager, String connectionType) {
            super((fp)manager.i(), fp.class, manager);
            this.isLocal = manager.c();
            this.connectionType = connectionType;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public String getConnectionType() {
            return this.connectionType;
        }
    }
}

