/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.math.imaginary;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.HashFunctions;
import com.flowpowered.math.TrigMath;
import com.flowpowered.math.imaginary.Complexd;
import com.flowpowered.math.imaginary.Imaginaryf;
import com.flowpowered.math.imaginary.Quaternionf;
import com.flowpowered.math.vector.Vector2f;
import com.flowpowered.math.vector.Vector3f;
import java.io.Serializable;

public class Complexf
implements Imaginaryf,
Comparable<Complexf>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final Complexf ZERO = new Complexf(0.0f, 0.0f);
    public static final Complexf IDENTITY = new Complexf(1.0f, 0.0f);
    private final float x;
    private final float y;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    public Complexf() {
        this(1.0f, 0.0f);
    }

    public Complexf(double x, double y) {
        this((float)x, (float)y);
    }

    public Complexf(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Complexf(Complexf c2) {
        this.x = c2.x;
        this.y = c2.y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Complexf add(Complexf c2) {
        return this.add(c2.x, c2.y);
    }

    public Complexf add(double x, double y) {
        return this.add((float)x, (float)y);
    }

    public Complexf add(float x, float y) {
        return new Complexf(this.x + x, this.y + y);
    }

    public Complexf sub(Complexf c2) {
        return this.sub(c2.x, c2.y);
    }

    public Complexf sub(double x, double y) {
        return this.sub((float)x, (float)y);
    }

    public Complexf sub(float x, float y) {
        return new Complexf(this.x - x, this.y - y);
    }

    public Complexf mul(double a2) {
        return this.mul((float)a2);
    }

    @Override
    public Complexf mul(float a2) {
        return new Complexf(this.x * a2, this.y * a2);
    }

    public Complexf mul(Complexf c2) {
        return this.mul(c2.x, c2.y);
    }

    public Complexf mul(double x, double y) {
        return this.mul((float)x, (float)y);
    }

    public Complexf mul(float x, float y) {
        return new Complexf(this.x * x - this.y * y, this.x * y + this.y * x);
    }

    public Complexf div(double a2) {
        return this.div((float)a2);
    }

    @Override
    public Complexf div(float a2) {
        return new Complexf(this.x / a2, this.y / a2);
    }

    public Complexf div(Complexf c2) {
        return this.div(c2.x, c2.y);
    }

    public Complexf div(double x, double y) {
        return this.div((float)x, (float)y);
    }

    public Complexf div(float x, float y) {
        float d = x * x + y * y;
        return new Complexf((this.x * x + this.y * y) / d, (this.y * x - this.x * y) / d);
    }

    public float dot(Complexf c2) {
        return this.dot(c2.x, c2.y);
    }

    public float dot(double x, double y) {
        return this.dot((float)x, (float)y);
    }

    public float dot(float x, float y) {
        return this.x * x + this.y * y;
    }

    public Vector2f rotate(Vector2f v) {
        return this.rotate(v.getX(), v.getY());
    }

    public Vector2f rotate(double x, double y) {
        return this.rotate((float)x, (float)y);
    }

    public Vector2f rotate(float x, float y) {
        float length = this.length();
        if (Math.abs(length) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot rotate by the zero complex");
        }
        float nx2 = this.x / length;
        float ny = this.y / length;
        return new Vector2f(x * nx2 - y * ny, y * nx2 + x * ny);
    }

    public Vector2f getDirection() {
        return new Vector2f(this.x, this.y).normalize();
    }

    public float getAngleRad() {
        return (float)TrigMath.atan2(this.y, this.x);
    }

    public float getAngleDeg() {
        return (float)Math.toDegrees(this.getAngleRad());
    }

    @Override
    public Complexf conjugate() {
        return new Complexf(this.x, -this.y);
    }

    @Override
    public Complexf invert() {
        float lengthSquared = this.lengthSquared();
        if (Math.abs(lengthSquared) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot invert a complex of length zero");
        }
        return this.conjugate().div(lengthSquared);
    }

    @Override
    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    @Override
    public Complexf normalize() {
        float length = this.length();
        if (Math.abs(length) < GenericMath.FLT_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero complex");
        }
        return new Complexf(this.x / length, this.y / length);
    }

    public Quaternionf toQuaternion() {
        return this.toQuaternion(Vector3f.UNIT_Z);
    }

    public Quaternionf toQuaternion(Vector3f axis) {
        return this.toQuaternion(axis.getX(), axis.getY(), axis.getZ());
    }

    public Quaternionf toQuaternion(double x, double y, double z) {
        return this.toQuaternion((float)x, (float)y, (float)z);
    }

    public Quaternionf toQuaternion(float x, float y, float z) {
        return Quaternionf.fromAngleRadAxis(this.getAngleRad(), x, y, z);
    }

    @Override
    public Complexf toFloat() {
        return new Complexf(this.x, this.y);
    }

    @Override
    public Complexd toDouble() {
        return new Complexd(this.x, this.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Complexf)) {
            return false;
        }
        Complexf complex = (Complexf)o;
        if (Float.compare(complex.x, this.x) != 0) {
            return false;
        }
        return Float.compare(complex.y, this.y) == 0;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = this.x != 0.0f ? HashFunctions.hash(this.x) : 0;
            this.hashCode = 31 * result + (this.y != 0.0f ? HashFunctions.hash(this.y) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(Complexf c2) {
        return (int)Math.signum(this.lengthSquared() - c2.lengthSquared());
    }

    public Complexf clone() {
        return new Complexf(this);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public static Complexf fromReal(float x) {
        return x == 0.0f ? ZERO : new Complexf(x, 0.0f);
    }

    public static Complexf fromImaginary(float y) {
        return y == 0.0f ? ZERO : new Complexf(0.0f, y);
    }

    public static Complexf from(float x, float y) {
        return x == 0.0f && y == 0.0f ? ZERO : new Complexf(x, y);
    }

    public static Complexf fromRotationTo(Vector2f from, Vector2f to) {
        return Complexf.fromAngleRad(TrigMath.acos(from.dot(to) / (from.length() * to.length())));
    }

    public static Complexf fromRotationTo(Vector3f from, Vector3f to) {
        return Complexf.fromAngleRad(TrigMath.acos(from.dot(to) / (from.length() * to.length())));
    }

    public static Complexf fromAngleDeg(double angle) {
        return Complexf.fromAngleRad(Math.toRadians(angle));
    }

    public static Complexf fromAngleRad(double angle) {
        return Complexf.fromAngleRad((float)angle);
    }

    public static Complexf fromAngleDeg(float angle) {
        return Complexf.fromAngleRad((float)Math.toRadians(angle));
    }

    public static Complexf fromAngleRad(float angle) {
        return new Complexf(TrigMath.cos(angle), TrigMath.sin(angle));
    }
}

