/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class ByteStreamLogger {
    private static final int BUFFER_SIZE = 1024;
    private final ExtendedLogger logger;
    private final Level level;
    private final Marker marker;
    private final InputStreamReader reader;
    private final char[] msgBuf = new char[1024];
    private final StringBuilder msg = new StringBuilder();
    private boolean closed;
    private final ByteBuffer buf = ByteBuffer.allocate(1024);

    public ByteStreamLogger(ExtendedLogger logger, Level level, Marker marker, Charset charset) {
        this.logger = logger;
        this.level = level == null ? logger.getLevel() : level;
        this.marker = marker;
        this.reader = new InputStreamReader((InputStream)new ByteBufferInputStream(), charset == null ? Charset.defaultCharset() : charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String fqcn) {
        StringBuilder stringBuilder = this.msg;
        synchronized (stringBuilder) {
            this.closed = true;
            this.logEnd(fqcn);
        }
    }

    private void extractMessages(String fqcn) throws IOException {
        if (this.closed) {
            return;
        }
        int read = this.reader.read(this.msgBuf);
        while (read > 0) {
            int off = 0;
            block5: for (int pos = 0; pos < read; ++pos) {
                switch (this.msgBuf[pos]) {
                    case '\r': {
                        this.msg.append(this.msgBuf, off, pos - off);
                        off = pos + 1;
                        continue block5;
                    }
                    case '\n': {
                        this.msg.append(this.msgBuf, off, pos - off);
                        off = pos + 1;
                        this.log(fqcn);
                    }
                }
            }
            this.msg.append(this.msgBuf, off, read - off);
            read = this.reader.read(this.msgBuf);
        }
    }

    private void log(String fqcn) {
        this.logger.logIfEnabled(fqcn, this.level, this.marker, this.msg.toString());
        this.msg.setLength(0);
    }

    private void logEnd(String fqcn) {
        if (this.msg.length() > 0) {
            this.log(fqcn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String fqcn, byte[] b2, int off, int len) throws IOException {
        int curOff = off;
        int curLen = len;
        if (curLen >= 0) {
            StringBuilder stringBuilder = this.msg;
            synchronized (stringBuilder) {
                while (curLen > this.buf.remaining()) {
                    int remaining = this.buf.remaining();
                    this.buf.put(b2, curOff, remaining);
                    curLen -= remaining;
                    curOff += remaining;
                    this.extractMessages(fqcn);
                }
                this.buf.put(b2, curOff, curLen);
                this.extractMessages(fqcn);
            }
        } else {
            this.logEnd(fqcn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String fqcn, int b2) throws IOException {
        if (b2 >= 0) {
            StringBuilder stringBuilder = this.msg;
            synchronized (stringBuilder) {
                this.buf.put((byte)(b2 & 0xFF));
                this.extractMessages(fqcn);
            }
        } else {
            this.logEnd(fqcn);
        }
    }

    private class ByteBufferInputStream
    extends InputStream {
        private ByteBufferInputStream() {
        }

        @Override
        public int read() throws IOException {
            ByteStreamLogger.this.buf.flip();
            int result = -1;
            if (ByteStreamLogger.this.buf.limit() > 0) {
                result = ByteStreamLogger.this.buf.get() & 0xFF;
            }
            ByteStreamLogger.this.buf.compact();
            return result;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            ByteStreamLogger.this.buf.flip();
            int result = -1;
            if (ByteStreamLogger.this.buf.limit() > 0) {
                result = Math.min(len, ByteStreamLogger.this.buf.limit());
                ByteStreamLogger.this.buf.get(bytes, off, result);
            }
            ByteStreamLogger.this.buf.compact();
            return result;
        }
    }
}

