/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.io.ByteStreamLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class LoggerOutputStream
extends OutputStream {
    private static final String FQCN = LoggerOutputStream.class.getName();
    private final ByteStreamLogger logger;
    private final String fqcn;

    protected LoggerOutputStream(ExtendedLogger logger, Level level, Marker marker, Charset charset, String fqcn) {
        this.logger = new ByteStreamLogger(logger, level, marker, charset);
        this.fqcn = fqcn == null ? FQCN : fqcn;
    }

    @Override
    public void close() throws IOException {
        this.logger.close(this.fqcn);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.logger.put(this.fqcn, b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.logger.put(this.fqcn, b2, off, len);
    }

    @Override
    public void write(int b2) throws IOException {
        this.logger.put(this.fqcn, (byte)(b2 & 0xFF));
    }
}

