/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.util.StringUtils;

public class CreateFunctionAlias
extends SchemaCommand {
    private String aliasName;
    private String javaClassMethod;
    private boolean deterministic;
    private boolean ifNotExists;
    private boolean force;
    private String source;
    private boolean bufferResultSetToLocalTemp = true;

    public CreateFunctionAlias(Session session, Schema schema) {
        super(session, schema);
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        if (this.getSchema().findFunction(this.aliasName) != null) {
            if (!this.ifNotExists) {
                throw DbException.get(90076, this.aliasName);
            }
        } else {
            int n = this.getObjectId();
            FunctionAlias functionAlias = this.javaClassMethod != null ? FunctionAlias.newInstance(this.getSchema(), n, this.aliasName, this.javaClassMethod, this.force, this.bufferResultSetToLocalTemp) : FunctionAlias.newInstanceFromSource(this.getSchema(), n, this.aliasName, this.source, this.force, this.bufferResultSetToLocalTemp);
            functionAlias.setDeterministic(this.deterministic);
            database.addSchemaObject(this.session, functionAlias);
        }
        return 0;
    }

    public void setAliasName(String string) {
        this.aliasName = string;
    }

    public void setJavaClassMethod(String string) {
        this.javaClassMethod = StringUtils.replaceAll(string, " ", "");
    }

    public void setIfNotExists(boolean bl2) {
        this.ifNotExists = bl2;
    }

    public void setForce(boolean bl2) {
        this.force = bl2;
    }

    public void setDeterministic(boolean bl2) {
        this.deterministic = bl2;
    }

    public void setBufferResultSetToLocalTemp(boolean bl2) {
        this.bufferResultSetToLocalTemp = bl2;
    }

    public void setSource(String string) {
        this.source = string;
    }

    @Override
    public int getType() {
        return 24;
    }
}

