/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.table.TableView;

public class CreateView
extends SchemaCommand {
    private Query select;
    private String viewName;
    private boolean ifNotExists;
    private String selectSQL;
    private String[] columnNames;
    private String comment;
    private boolean orReplace;
    private boolean force;

    public CreateView(Session session, Schema schema) {
        super(session, schema);
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public void setSelect(Query query) {
        this.select = query;
    }

    public void setIfNotExists(boolean bl2) {
        this.ifNotExists = bl2;
    }

    public void setSelectSQL(String string) {
        this.selectSQL = string;
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setOrReplace(boolean bl2) {
        this.orReplace = bl2;
    }

    public void setForce(boolean bl2) {
        this.force = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        ArrayList<Parameter> arrayList;
        String string;
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        TableView tableView = null;
        Table table = this.getSchema().findTableOrView(this.session, this.viewName);
        if (table != null) {
            if (this.ifNotExists) {
                return 0;
            }
            if (!this.orReplace || TableType.VIEW != table.getTableType()) {
                throw DbException.get(90038, this.viewName);
            }
            tableView = (TableView)table;
        }
        int n = this.getObjectId();
        if (this.select == null) {
            string = this.selectSQL;
        } else {
            arrayList = this.select.getParameters();
            if (arrayList != null && arrayList.size() > 0) {
                throw DbException.getUnsupportedException("parameters in views");
            }
            string = this.select.getPlanSQL();
        }
        ArrayList<Parameter> arrayList2 = arrayList = database.getSystemSession();
        synchronized (arrayList2) {
            try {
                if (tableView == null) {
                    Schema schema = this.session.getDatabase().getSchema(this.session.getCurrentSchemaName());
                    ((Session)((Object)arrayList)).setCurrentSchema(schema);
                    Column[] columnArray = null;
                    if (this.columnNames != null) {
                        columnArray = new Column[this.columnNames.length];
                        for (int i = 0; i < this.columnNames.length; ++i) {
                            columnArray[i] = new Column(this.columnNames[i], -1);
                        }
                    }
                    tableView = new TableView(this.getSchema(), n, this.viewName, string, null, columnArray, (Session)((Object)arrayList), false);
                } else {
                    tableView.replace(string, (Session)((Object)arrayList), false, this.force);
                    tableView.setModified();
                }
            }
            finally {
                ((Session)((Object)arrayList)).setCurrentSchema(database.getSchema("PUBLIC"));
            }
        }
        if (this.comment != null) {
            tableView.setComment(this.comment);
        }
        if (table == null) {
            database.addSchemaObject(this.session, tableView);
        } else {
            database.updateMeta(this.session, tableView);
        }
        return 0;
    }

    @Override
    public int getType() {
        return 34;
    }
}

