/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ConditionNot
extends Condition {
    private Expression condition;

    public ConditionNot(Expression expression) {
        this.condition = expression;
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return this.condition;
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.condition.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        return value.convertTo(1).negate();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.condition.mapColumns(columnResolver, n);
    }

    @Override
    public Expression optimize(Session session) {
        Expression expression = this.condition.getNotIfPossible(session);
        if (expression != null) {
            return expression.optimize(session);
        }
        Expression expression2 = this.condition.optimize(session);
        if (expression2.isConstant()) {
            Value value = expression2.getValue(session);
            if (value == ValueNull.INSTANCE) {
                return ValueExpression.getNull();
            }
            return ValueExpression.get(value.convertTo(1).negate());
        }
        this.condition = expression2;
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl2) {
        this.condition.setEvaluatable(tableFilter, bl2);
    }

    @Override
    public String getSQL() {
        return "(NOT " + this.condition.getSQL() + ")";
    }

    @Override
    public void updateAggregate(Session session) {
        this.condition.updateAggregate(session);
    }

    @Override
    public void addFilterConditions(TableFilter tableFilter, boolean bl2) {
        if (bl2) {
            return;
        }
        super.addFilterConditions(tableFilter, bl2);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.condition.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.condition.getCost();
    }
}

