/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.HashSet;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.FunctionCursor;
import org.h2.index.FunctionCursorResultSet;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.FunctionTable;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;

public class FunctionIndex
extends BaseIndex {
    private final FunctionTable functionTable;

    public FunctionIndex(FunctionTable functionTable, IndexColumn[] indexColumnArray) {
        this.initBaseIndex(functionTable, 0, null, indexColumnArray, IndexType.createNonUnique(true));
        this.functionTable = functionTable;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        if (this.functionTable.isBufferResultSetToLocalTemp()) {
            return new FunctionCursor(session, this.functionTable.getResult(session));
        }
        return new FunctionCursorResultSet(session, this.functionTable.getResultSet(session));
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, HashSet<Column> hashSet) {
        if (nArray != null) {
            throw DbException.getUnsupportedException("ALIAS");
        }
        long l = this.functionTable.canGetRowCount() ? this.functionTable.getRowCountApproximation() : (long)this.database.getSettings().estimatedFunctionTableRows;
        return l * 10L;
    }

    @Override
    public void remove(Session session) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl2) {
        throw DbException.getUnsupportedException("ALIAS");
    }

    @Override
    public long getRowCount(Session session) {
        return this.functionTable.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        return this.functionTable.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public String getPlanSQL() {
        return "function";
    }

    @Override
    public boolean canScan() {
        return false;
    }
}

