/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.h2.compress.Compressor;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.util.New;

public class Page {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final MVMap<?, ?> map;
    private long version;
    private long pos;
    private long totalCount;
    private int cachedCompare;
    private int memory;
    private Object[] keys;
    private Object[] values;
    private PageReference[] children;
    private volatile boolean removedInMemory;

    Page(MVMap<?, ?> mVMap, long l) {
        this.map = mVMap;
        this.version = l;
    }

    static Page createEmpty(MVMap<?, ?> mVMap, long l) {
        return Page.create(mVMap, l, EMPTY_OBJECT_ARRAY, EMPTY_OBJECT_ARRAY, null, 0L, 128);
    }

    public static Page create(MVMap<?, ?> mVMap, long l, Object[] objectArray, Object[] objectArray2, PageReference[] pageReferenceArray, long l2, int n) {
        Page page = new Page(mVMap, l);
        page.keys = objectArray;
        page.values = objectArray2;
        page.children = pageReferenceArray;
        page.totalCount = l2;
        if (n == 0) {
            page.recalculateMemory();
        } else {
            page.addMemory(n);
        }
        MVStore mVStore = mVMap.store;
        if (mVStore != null) {
            mVStore.registerUnsavedPage(page.memory);
        }
        return page;
    }

    public static Page create(MVMap<?, ?> mVMap, long l, Page page) {
        Page page2 = new Page(mVMap, l);
        page2.keys = page.keys;
        page2.values = page.values;
        page2.children = page.children;
        page2.totalCount = page.totalCount;
        page2.memory = page.memory;
        MVStore mVStore = mVMap.store;
        if (mVStore != null) {
            mVStore.registerUnsavedPage(page2.memory);
        }
        return page2;
    }

    static Page read(FileStore fileStore, long l, MVMap<?, ?> mVMap, long l2, long l3) {
        int n;
        ByteBuffer byteBuffer;
        int n2 = DataUtils.getPageMaxLength(l);
        if (n2 == 0x200000) {
            byteBuffer = fileStore.readFully(l2, 128);
            n2 = byteBuffer.getInt();
        }
        if ((n = (n2 = (int)Math.min(l3 - l2, (long)n2))) < 0) {
            throw DataUtils.newIllegalStateException(6, "Illegal page length {0} reading at {1}; max pos {2} ", n, l2, l3);
        }
        byteBuffer = fileStore.readFully(l2, n);
        Page page = new Page(mVMap, 0L);
        page.pos = l;
        int n3 = DataUtils.getPageChunkId(l);
        int n4 = DataUtils.getPageOffset(l);
        page.read(byteBuffer, n3, n4, n2);
        return page;
    }

    public Object getKey(int n) {
        return this.keys[n];
    }

    public Page getChildPage(int n) {
        PageReference pageReference = this.children[n];
        return pageReference.page != null ? pageReference.page : this.map.readPage(pageReference.pos);
    }

    public long getChildPagePos(int n) {
        return this.children[n].pos;
    }

    public Object getValue(int n) {
        return this.values[n];
    }

    public int getKeyCount() {
        return this.keys.length;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public long getPos() {
        return this.pos;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id: ").append(System.identityHashCode(this)).append('\n');
        stringBuilder.append("version: ").append(Long.toHexString(this.version)).append("\n");
        stringBuilder.append("pos: ").append(Long.toHexString(this.pos)).append("\n");
        if (this.pos != 0L) {
            n = DataUtils.getPageChunkId(this.pos);
            stringBuilder.append("chunk: ").append(Long.toHexString(n)).append("\n");
        }
        for (n = 0; n <= this.keys.length; ++n) {
            if (n > 0) {
                stringBuilder.append(" ");
            }
            if (this.children != null) {
                stringBuilder.append("[" + Long.toHexString(this.children[n].pos) + "] ");
            }
            if (n >= this.keys.length) continue;
            stringBuilder.append(this.keys[n]);
            if (this.values == null) continue;
            stringBuilder.append(':');
            stringBuilder.append(this.values[n]);
        }
        return stringBuilder.toString();
    }

    public Page copy(long l) {
        Page page = Page.create(this.map, l, this.keys, this.values, this.children, this.totalCount, this.getMemory());
        this.removePage();
        page.cachedCompare = this.cachedCompare;
        return page;
    }

    public int binarySearch(Object object) {
        int n = 0;
        int n2 = this.keys.length - 1;
        int n3 = this.cachedCompare - 1;
        if (n3 < 0 || n3 > n2) {
            n3 = n2 >>> 1;
        }
        Object[] objectArray = this.keys;
        while (n <= n2) {
            int n4 = this.map.compare(object, objectArray[n3]);
            if (n4 > 0) {
                n = n3 + 1;
            } else if (n4 < 0) {
                n2 = n3 - 1;
            } else {
                this.cachedCompare = n3 + 1;
                return n3;
            }
            n3 = n + n2 >>> 1;
        }
        this.cachedCompare = n;
        return -(n + 1);
    }

    Page split(int n) {
        return this.isLeaf() ? this.splitLeaf(n) : this.splitNode(n);
    }

    private Page splitLeaf(int n) {
        int n2 = n;
        int n3 = this.keys.length - n2;
        Object[] objectArray = new Object[n2];
        Object[] objectArray2 = new Object[n3];
        System.arraycopy(this.keys, 0, objectArray, 0, n2);
        System.arraycopy(this.keys, n2, objectArray2, 0, n3);
        this.keys = objectArray;
        Object[] objectArray3 = new Object[n2];
        Object[] objectArray4 = new Object[n3];
        objectArray4 = new Object[n3];
        System.arraycopy(this.values, 0, objectArray3, 0, n2);
        System.arraycopy(this.values, n2, objectArray4, 0, n3);
        this.values = objectArray3;
        this.totalCount = n2;
        Page page = Page.create(this.map, this.version, objectArray2, objectArray4, null, objectArray2.length, 0);
        this.recalculateMemory();
        page.recalculateMemory();
        return page;
    }

    private Page splitNode(int n) {
        int n2 = n;
        int n3 = this.keys.length - n2;
        Object[] objectArray = new Object[n2];
        Object[] objectArray2 = new Object[n3 - 1];
        System.arraycopy(this.keys, 0, objectArray, 0, n2);
        System.arraycopy(this.keys, n2 + 1, objectArray2, 0, n3 - 1);
        this.keys = objectArray;
        PageReference[] pageReferenceArray = new PageReference[n2 + 1];
        PageReference[] pageReferenceArray2 = new PageReference[n3];
        System.arraycopy(this.children, 0, pageReferenceArray, 0, n2 + 1);
        System.arraycopy(this.children, n2 + 1, pageReferenceArray2, 0, n3);
        this.children = pageReferenceArray;
        long l = 0L;
        for (PageReference pageReference : pageReferenceArray) {
            l += pageReference.count;
        }
        this.totalCount = l;
        l = 0L;
        for (PageReference pageReference : pageReferenceArray2) {
            l += pageReference.count;
        }
        Page page = Page.create(this.map, this.version, objectArray2, null, pageReferenceArray2, l, 0);
        this.recalculateMemory();
        super.recalculateMemory();
        return page;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    long getCounts(int n) {
        return this.children[n].count;
    }

    public void setChild(int n, Page page) {
        if (page == null) {
            PageReference pageReference;
            long l = this.children[n].count;
            this.children = (PageReference[])this.children.clone();
            this.children[n] = pageReference = new PageReference(null, 0L, 0L);
            this.totalCount -= l;
        } else if (page != this.children[n].page || page.getPos() != this.children[n].pos) {
            PageReference pageReference;
            long l = this.children[n].count;
            this.children = (PageReference[])this.children.clone();
            this.children[n] = pageReference = new PageReference(page, page.pos, page.totalCount);
            this.totalCount += page.totalCount - l;
        }
    }

    public void setKey(int n, Object object) {
        this.keys = (Object[])this.keys.clone();
        Object object2 = this.keys[n];
        DataType dataType = this.map.getKeyType();
        int n2 = dataType.getMemory(object);
        if (object2 != null) {
            n2 -= dataType.getMemory(object2);
        }
        this.addMemory(n2);
        this.keys[n] = object;
    }

    public Object setValue(int n, Object object) {
        Object object2 = this.values[n];
        this.values = (Object[])this.values.clone();
        DataType dataType = this.map.getValueType();
        this.addMemory(dataType.getMemory(object) - dataType.getMemory(object2));
        this.values[n] = object;
        return object2;
    }

    void removeAllRecursive() {
        if (this.children != null) {
            int n = this.map.getChildPageCount(this);
            for (int i = 0; i < n; ++i) {
                PageReference pageReference = this.children[i];
                if (pageReference.page != null) {
                    pageReference.page.removeAllRecursive();
                    continue;
                }
                long l = this.children[i].pos;
                int n2 = DataUtils.getPageType(l);
                if (n2 == 0) {
                    int n3 = DataUtils.getPageMaxLength(l);
                    this.map.removePage(l, n3);
                    continue;
                }
                this.map.readPage(l).removeAllRecursive();
            }
        }
        this.removePage();
    }

    public void insertLeaf(int n, Object object, Object object2) {
        int n2 = this.keys.length + 1;
        Object[] objectArray = new Object[n2];
        DataUtils.copyWithGap(this.keys, objectArray, n2 - 1, n);
        this.keys = objectArray;
        Object[] objectArray2 = new Object[n2];
        DataUtils.copyWithGap(this.values, objectArray2, n2 - 1, n);
        this.values = objectArray2;
        this.keys[n] = object;
        this.values[n] = object2;
        ++this.totalCount;
        this.addMemory(this.map.getKeyType().getMemory(object) + this.map.getValueType().getMemory(object2));
    }

    public void insertNode(int n, Object object, Page page) {
        Object[] objectArray = new Object[this.keys.length + 1];
        DataUtils.copyWithGap(this.keys, objectArray, this.keys.length, n);
        objectArray[n] = object;
        this.keys = objectArray;
        int n2 = this.children.length;
        PageReference[] pageReferenceArray = new PageReference[n2 + 1];
        DataUtils.copyWithGap(this.children, pageReferenceArray, n2, n);
        pageReferenceArray[n] = new PageReference(page, page.getPos(), page.totalCount);
        this.children = pageReferenceArray;
        this.totalCount += page.totalCount;
        this.addMemory(this.map.getKeyType().getMemory(object) + 16);
    }

    public void remove(int n) {
        int n2 = this.keys.length;
        int n3 = n >= n2 ? n - 1 : n;
        Object object = this.keys[n3];
        this.addMemory(-this.map.getKeyType().getMemory(object));
        Object[] objectArray = new Object[n2 - 1];
        DataUtils.copyExcept(this.keys, objectArray, n2, n3);
        this.keys = objectArray;
        if (this.values != null) {
            object = this.values[n];
            this.addMemory(-this.map.getValueType().getMemory(object));
            Object[] objectArray2 = new Object[n2 - 1];
            DataUtils.copyExcept(this.values, objectArray2, n2, n);
            this.values = objectArray2;
            --this.totalCount;
        }
        if (this.children != null) {
            this.addMemory(-16);
            long l = this.children[n].count;
            int n4 = this.children.length;
            PageReference[] pageReferenceArray = new PageReference[n4 - 1];
            DataUtils.copyExcept(this.children, pageReferenceArray, n4, n);
            this.children = pageReferenceArray;
            this.totalCount -= l;
        }
    }

    void read(ByteBuffer byteBuffer, int n, int n2, int n3) {
        boolean bl2;
        int n4;
        boolean bl3;
        int n5 = byteBuffer.position();
        int n6 = byteBuffer.getInt();
        if (n6 > n3 || n6 < 4) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected page length 4..{1}, got {2}", n, n3, n6);
        }
        byteBuffer.limit(n5 + n6);
        short s = byteBuffer.getShort();
        int n7 = DataUtils.readVarInt(byteBuffer);
        if (n7 != this.map.getId()) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected map id {1}, got {2}", n, this.map.getId(), n7);
        }
        int n8 = DataUtils.getCheckValue(n) ^ DataUtils.getCheckValue(n2) ^ DataUtils.getCheckValue(n6);
        if (s != (short)n8) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected check value {1}, got {2}", n, n8, s);
        }
        int n9 = DataUtils.readVarInt(byteBuffer);
        this.keys = new Object[n9];
        byte by = byteBuffer.get();
        boolean bl4 = bl3 = (by & 1) == 1;
        if (bl3) {
            this.children = new PageReference[n9 + 1];
            long[] lArray = new long[n9 + 1];
            for (int i = 0; i <= n9; ++i) {
                lArray[i] = byteBuffer.getLong();
            }
            long l = 0L;
            for (n4 = 0; n4 <= n9; ++n4) {
                long l2 = DataUtils.readVarLong(byteBuffer);
                l += l2;
                this.children[n4] = new PageReference(null, lArray[n4], l2);
            }
            this.totalCount = l;
        }
        boolean bl5 = bl2 = (by & 2) != 0;
        if (bl2) {
            Compressor compressor = (by & 6) == 6 ? this.map.getStore().getCompressorHigh() : this.map.getStore().getCompressorFast();
            int n10 = DataUtils.readVarInt(byteBuffer);
            n4 = n6 + n5 - byteBuffer.position();
            byte[] byArray = DataUtils.newBytes(n4);
            byteBuffer.get(byArray);
            int n11 = n4 + n10;
            byteBuffer = ByteBuffer.allocate(n11);
            compressor.expand(byArray, 0, n4, byteBuffer.array(), byteBuffer.arrayOffset(), n11);
        }
        this.map.getKeyType().read(byteBuffer, this.keys, n9, true);
        if (!bl3) {
            this.values = new Object[n9];
            this.map.getValueType().read(byteBuffer, this.values, n9, false);
            this.totalCount = n9;
        }
        this.recalculateMemory();
    }

    private int write(Chunk chunk, WriteBuffer writeBuffer) {
        int n;
        int n2;
        int n3;
        int n4 = writeBuffer.position();
        int n5 = this.keys.length;
        int n6 = this.children != null ? 1 : 0;
        writeBuffer.putInt(0).putShort((short)0).putVarInt(this.map.getId()).putVarInt(n5);
        int n7 = writeBuffer.position();
        writeBuffer.put((byte)n6);
        if (n6 == 1) {
            this.writeChildren(writeBuffer);
            for (n3 = 0; n3 <= n5; ++n3) {
                writeBuffer.putVarLong(this.children[n3].count);
            }
        }
        n3 = writeBuffer.position();
        this.map.getKeyType().write(writeBuffer, this.keys, n5, true);
        if (n6 == 0) {
            this.map.getValueType().write(writeBuffer, this.values, n5, false);
        }
        MVStore mVStore = this.map.getStore();
        int n8 = writeBuffer.position() - n3;
        if (n8 > 16 && (n2 = mVStore.getCompressionLevel()) > 0) {
            Compressor compressor;
            if (n2 == 1) {
                compressor = this.map.getStore().getCompressorFast();
                n = 2;
            } else {
                compressor = this.map.getStore().getCompressorHigh();
                n = 6;
            }
            byte[] byArray = new byte[n8];
            writeBuffer.position(n3).get(byArray);
            byte[] byArray2 = new byte[n8 * 2];
            int n9 = compressor.compress(byArray, n8, byArray2, 0);
            int n10 = DataUtils.getVarIntLen(n9 - n8);
            if (n9 + n10 < n8) {
                writeBuffer.position(n7).put((byte)(n6 + n));
                writeBuffer.position(n3).putVarInt(n8 - n9).put(byArray2, 0, n9);
            }
        }
        n2 = writeBuffer.position() - n4;
        int n11 = chunk.id;
        n = DataUtils.getCheckValue(n11) ^ DataUtils.getCheckValue(n4) ^ DataUtils.getCheckValue(n2);
        writeBuffer.putInt(n4, n2).putShort(n4 + 4, (short)n);
        if (this.pos != 0L) {
            throw DataUtils.newIllegalStateException(3, "Page already stored", new Object[0]);
        }
        this.pos = DataUtils.getPagePos(n11, n4, n2, n6);
        mVStore.cachePage(this.pos, this, this.getMemory());
        if (n6 == 1) {
            mVStore.cachePage(this.pos, this, this.getMemory());
        }
        long l = DataUtils.getPageMaxLength(this.pos);
        chunk.maxLen += l;
        chunk.maxLenLive += l;
        ++chunk.pageCount;
        ++chunk.pageCountLive;
        if (this.removedInMemory) {
            this.map.removePage(this.pos, this.memory);
        }
        return n7 + 1;
    }

    private void writeChildren(WriteBuffer writeBuffer) {
        int n = this.keys.length;
        for (int i = 0; i <= n; ++i) {
            writeBuffer.putLong(this.children[i].pos);
        }
    }

    void writeUnsavedRecursive(Chunk chunk, WriteBuffer writeBuffer) {
        if (this.pos != 0L) {
            return;
        }
        int n = this.write(chunk, writeBuffer);
        if (!this.isLeaf()) {
            int n2;
            int n3 = this.children.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Page page = this.children[n2].page;
                if (page == null) continue;
                page.writeUnsavedRecursive(chunk, writeBuffer);
                this.children[n2] = new PageReference(page, page.getPos(), page.totalCount);
            }
            n2 = writeBuffer.position();
            writeBuffer.position(n);
            this.writeChildren(writeBuffer);
            writeBuffer.position(n2);
        }
    }

    void writeEnd() {
        if (this.isLeaf()) {
            return;
        }
        for (PageReference pageReference : this.children) {
            if (pageReference.page == null) continue;
            if (pageReference.page.getPos() == 0L) {
                throw DataUtils.newIllegalStateException(3, "Page not written", new Object[0]);
            }
            pageReference.page.writeEnd();
            this.children[var2_2] = new PageReference(null, pageReference.pos, pageReference.count);
        }
    }

    long getVersion() {
        return this.version;
    }

    public int getRawChildPageCount() {
        return this.children.length;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Page) {
            if (this.pos != 0L && ((Page)object).pos == this.pos) {
                return true;
            }
            return this == object;
        }
        return false;
    }

    public int hashCode() {
        return this.pos != 0L ? (int)(this.pos | this.pos >>> 32) : super.hashCode();
    }

    public int getMemory() {
        return this.memory;
    }

    private void addMemory(int n) {
        this.memory += n;
    }

    private void recalculateMemory() {
        int n = 128;
        DataType dataType = this.map.getKeyType();
        for (int i = 0; i < this.keys.length; ++i) {
            n += dataType.getMemory(this.keys[i]);
        }
        if (this.isLeaf()) {
            DataType dataType2 = this.map.getValueType();
            for (int i = 0; i < this.keys.length; ++i) {
                n += dataType2.getMemory(this.values[i]);
            }
        } else {
            n += this.getRawChildPageCount() * 16;
        }
        this.addMemory(n - this.memory);
    }

    void setVersion(long l) {
        this.version = l;
    }

    public void removePage() {
        long l = this.pos;
        if (l == 0L) {
            this.removedInMemory = true;
        }
        this.map.removePage(l, this.memory);
    }

    public static class PageChildren {
        public static final long[] EMPTY_ARRAY = new long[0];
        final long pos;
        long[] children;
        boolean chunkList;

        private PageChildren(long l, long[] lArray) {
            this.pos = l;
            this.children = lArray;
        }

        PageChildren(Page page) {
            this.pos = page.getPos();
            int n = page.getRawChildPageCount();
            this.children = new long[n];
            for (int i = 0; i < n; ++i) {
                this.children[i] = page.getChildPagePos(i);
            }
        }

        int getMemory() {
            return 64 + 8 * this.children.length;
        }

        static PageChildren read(FileStore fileStore, long l, int n, long l2, long l3) {
            boolean bl2;
            int n2;
            ByteBuffer byteBuffer;
            int n3 = DataUtils.getPageMaxLength(l);
            if (n3 == 0x200000) {
                byteBuffer = fileStore.readFully(l2, 128);
                n3 = byteBuffer.getInt();
            }
            if ((n2 = (n3 = (int)Math.min(l3 - l2, (long)n3))) < 0) {
                throw DataUtils.newIllegalStateException(6, "Illegal page length {0} reading at {1}; max pos {2} ", n2, l2, l3);
            }
            byteBuffer = fileStore.readFully(l2, n2);
            int n4 = DataUtils.getPageChunkId(l);
            int n5 = DataUtils.getPageOffset(l);
            int n6 = byteBuffer.position();
            int n7 = byteBuffer.getInt();
            if (n7 > n3) {
                throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected page length =< {1}, got {2}", n4, n3, n7);
            }
            byteBuffer.limit(n6 + n7);
            short s = byteBuffer.getShort();
            int n8 = DataUtils.readVarInt(byteBuffer);
            if (n8 != n) {
                throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected map id {1}, got {2}", n4, n, n8);
            }
            int n9 = DataUtils.getCheckValue(n4) ^ DataUtils.getCheckValue(n5) ^ DataUtils.getCheckValue(n7);
            if (s != (short)n9) {
                throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected check value {1}, got {2}", n4, n9, s);
            }
            int n10 = DataUtils.readVarInt(byteBuffer);
            byte by = byteBuffer.get();
            boolean bl3 = bl2 = (by & 1) == 1;
            if (!bl2) {
                return null;
            }
            long[] lArray = new long[n10 + 1];
            for (int i = 0; i <= n10; ++i) {
                lArray[i] = byteBuffer.getLong();
            }
            return new PageChildren(l, lArray);
        }

        void removeDuplicateChunkReferences() {
            HashSet hashSet = New.hashSet();
            hashSet.add(DataUtils.getPageChunkId(this.pos));
            for (int i = 0; i < this.children.length; ++i) {
                long l = this.children[i];
                int n = DataUtils.getPageChunkId(l);
                boolean bl2 = hashSet.add(n);
                if (DataUtils.getPageType(l) == 1 || bl2) continue;
                this.removeChild(i--);
            }
        }

        void collectReferencedChunks(Set<Integer> set) {
            set.add(DataUtils.getPageChunkId(this.pos));
            for (long l : this.children) {
                set.add(DataUtils.getPageChunkId(l));
            }
        }

        private void removeChild(int n) {
            if (n == 0 && this.children.length == 1) {
                this.children = EMPTY_ARRAY;
                return;
            }
            long[] lArray = new long[this.children.length - 1];
            DataUtils.copyExcept(this.children, lArray, this.children.length, n);
            this.children = lArray;
        }
    }

    public static class PageReference {
        final long pos;
        final Page page;
        final long count;

        public PageReference(Page page, long l, long l2) {
            this.page = page;
            this.pos = l;
            this.count = l2;
        }
    }
}

