/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.ObjectDataType;
import org.h2.util.New;

public class TransactionStore {
    final MVStore store;
    final MVMap<Integer, Object[]> preparedTransactions;
    final MVMap<Long, Object[]> undoLog;
    private HashMap<Integer, MVMap<Object, VersionedValue>> maps = New.hashMap();
    private final DataType dataType;
    private final BitSet openTransactions = new BitSet();
    private boolean init;
    private int maxTransactionId = 65535;
    private int nextTempMapId;

    public TransactionStore(MVStore mVStore) {
        this(mVStore, new ObjectDataType());
    }

    public TransactionStore(MVStore mVStore, DataType dataType) {
        this.store = mVStore;
        this.dataType = dataType;
        this.preparedTransactions = mVStore.openMap("openTransactions", new MVMap.Builder());
        VersionedValueType versionedValueType = new VersionedValueType(dataType);
        ArrayType arrayType = new ArrayType(new DataType[]{new ObjectDataType(), dataType, versionedValueType});
        MVMap.Builder builder = new MVMap.Builder().valueType(arrayType);
        this.undoLog = mVStore.openMap("undoLog", builder);
        if (this.undoLog.getValueType() != arrayType) {
            throw DataUtils.newIllegalStateException(100, "Undo map open with a different value type", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        this.init = true;
        for (String object : this.store.getMapNames()) {
            if (!object.startsWith("temp.")) continue;
            MVMap<Object, Integer> mVMap = this.openTempMap(object);
            this.store.removeMap(mVMap);
        }
        MVMap<Long, Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            if (this.undoLog.size() > 0) {
                for (Long l : this.undoLog.keySet()) {
                    int n = TransactionStore.getTransactionId(l);
                    this.openTransactions.set(n);
                }
            }
        }
    }

    public void setMaxTransactionId(int n) {
        this.maxTransactionId = n;
    }

    static long getOperationId(int n, long l) {
        DataUtils.checkArgument(n >= 0 && n < 0x1000000, "Transaction id out of range: {0}", n);
        DataUtils.checkArgument(l >= 0L && l < 0x10000000000L, "Transaction log id out of range: {0}", l);
        return (long)n << 40 | l;
    }

    static int getTransactionId(long l) {
        return (int)(l >>> 40);
    }

    static long getLogId(long l) {
        return l & 0xFFFFFFFFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Transaction> getOpenTransactions() {
        MVMap<Long, Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            ArrayList<Transaction> arrayList = New.arrayList();
            Long l = this.undoLog.firstKey();
            while (l != null) {
                String string;
                int n;
                int n2 = TransactionStore.getTransactionId(l);
                l = this.undoLog.lowerKey(TransactionStore.getOperationId(n2 + 1, 0L));
                long l2 = TransactionStore.getLogId(l) + 1L;
                Object[] objectArray = this.preparedTransactions.get(n2);
                if (objectArray == null) {
                    n = this.undoLog.containsKey(TransactionStore.getOperationId(n2, 0L)) ? 1 : 3;
                    string = null;
                } else {
                    n = (Integer)objectArray[0];
                    string = (String)objectArray[1];
                }
                Transaction transaction = new Transaction(this, n2, n, string, l2);
                arrayList.add(transaction);
                l = this.undoLog.ceilingKey(TransactionStore.getOperationId(n2 + 1, 0L));
            }
            return arrayList;
        }
    }

    public synchronized void close() {
        this.store.commit();
    }

    public synchronized Transaction begin() {
        if (!this.init) {
            throw DataUtils.newIllegalStateException(103, "Not initialized", new Object[0]);
        }
        int n = this.openTransactions.nextClearBit(1);
        if (n > this.maxTransactionId) {
            throw DataUtils.newIllegalStateException(102, "There are {0} open transactions", n - 1);
        }
        this.openTransactions.set(n);
        int n2 = 1;
        return new Transaction(this, n, n2, null, 0L);
    }

    synchronized void storeTransaction(Transaction transaction) {
        if (transaction.getStatus() == 2 || transaction.getName() != null) {
            Object[] objectArray = new Object[]{transaction.getStatus(), transaction.getName()};
            this.preparedTransactions.put(transaction.getId(), objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void log(Transaction transaction, long l, int n, Object object, Object object2) {
        Long l2 = TransactionStore.getOperationId(transaction.getId(), l);
        Object[] objectArray = new Object[]{n, object, object2};
        MVMap<Long, Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            if (l == 0L && this.undoLog.containsKey(l2)) {
                throw DataUtils.newIllegalStateException(102, "An old transaction with the same id is still open: {0}", transaction.getId());
            }
            this.undoLog.put(l2, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logUndo(Transaction transaction, long l) {
        Long l2 = TransactionStore.getOperationId(transaction.getId(), l);
        MVMap<Long, Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            Object[] objectArray = this.undoLog.remove(l2);
            if (objectArray == null) {
                throw DataUtils.newIllegalStateException(103, "Transaction {0} was concurrently rolled back", transaction.getId());
            }
        }
    }

    synchronized <K, V> void removeMap(TransactionMap<K, V> transactionMap) {
        this.maps.remove(transactionMap.mapId);
        this.store.removeMap(transactionMap.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(Transaction transaction, long l) {
        if (this.store.isClosed()) {
            return;
        }
        MVMap<Long, Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            transaction.setStatus(3);
            for (long i = 0L; i < l; ++i) {
                Object object;
                VersionedValue versionedValue;
                Long l2 = TransactionStore.getOperationId(transaction.getId(), i);
                Object[] objectArray = this.undoLog.get(l2);
                if (objectArray == null) {
                    if ((l2 = this.undoLog.ceilingKey(l2)) == null || TransactionStore.getTransactionId(l2) != transaction.getId()) break;
                    i = TransactionStore.getLogId(l2) - 1L;
                    continue;
                }
                int n = (Integer)objectArray[0];
                MVMap<Object, VersionedValue> mVMap2 = this.openMap(n);
                if (mVMap2 != null && (versionedValue = mVMap2.get(object = objectArray[1])) != null) {
                    if (versionedValue.value == null) {
                        int n2 = TransactionStore.getTransactionId(versionedValue.operationId);
                        if (n2 == transaction.transactionId) {
                            mVMap2.remove(object);
                        }
                    } else {
                        VersionedValue versionedValue2 = new VersionedValue();
                        versionedValue2.value = versionedValue.value;
                        mVMap2.put(object, versionedValue2);
                    }
                }
                this.undoLog.remove(l2);
            }
        }
        this.endTransaction(transaction);
    }

    synchronized <K> MVMap<K, VersionedValue> openMap(String string, DataType dataType, DataType dataType2) {
        Object m;
        if (dataType == null) {
            dataType = new ObjectDataType();
        }
        if (dataType2 == null) {
            dataType2 = new ObjectDataType();
        }
        VersionedValueType versionedValueType = new VersionedValueType(dataType2);
        MVMap.Builder builder = new MVMap.Builder().keyType(dataType).valueType(versionedValueType);
        Object m2 = m = this.store.openMap(string, builder);
        this.maps.put(((MVMap)m).getId(), (MVMap<Object, VersionedValue>)m2);
        return m;
    }

    synchronized MVMap<Object, VersionedValue> openMap(int n) {
        MVMap<Object, VersionedValue> mVMap = this.maps.get(n);
        if (mVMap != null) {
            return mVMap;
        }
        String string = this.store.getMapName(n);
        if (string == null) {
            return null;
        }
        VersionedValueType versionedValueType = new VersionedValueType(this.dataType);
        MVMap.Builder builder = new MVMap.Builder().keyType(this.dataType).valueType(versionedValueType);
        mVMap = this.store.openMap(string, builder);
        this.maps.put(n, mVMap);
        return mVMap;
    }

    synchronized MVMap<Object, Integer> createTempMap() {
        String string = "temp." + this.nextTempMapId++;
        return this.openTempMap(string);
    }

    MVMap<Object, Integer> openTempMap(String string) {
        MVMap.Builder builder = new MVMap.Builder().keyType(this.dataType);
        return this.store.openMap(string, builder);
    }

    synchronized void endTransaction(Transaction transaction) {
        int n;
        int n2;
        if (transaction.getStatus() == 2) {
            this.preparedTransactions.remove(transaction.getId());
        }
        transaction.setStatus(0);
        this.openTransactions.clear(transaction.transactionId);
        if (this.store.getAutoCommitDelay() == 0) {
            this.store.commit();
            return;
        }
        if (this.undoLog.isEmpty() && (n2 = this.store.getUnsavedMemory()) * 4 > (n = this.store.getAutoCommitMemory()) * 3) {
            this.store.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackTo(Transaction transaction, long l, long l2) {
        MVMap<Long, Object[]> mVMap = this.undoLog;
        synchronized (mVMap) {
            for (long i = l - 1L; i >= l2; --i) {
                Long l3 = TransactionStore.getOperationId(transaction.getId(), i);
                Object[] objectArray = this.undoLog.get(l3);
                if (objectArray == null) {
                    if ((l3 = this.undoLog.floorKey(l3)) == null || TransactionStore.getTransactionId(l3) != transaction.getId()) break;
                    i = TransactionStore.getLogId(l3) + 1L;
                    continue;
                }
                int n = (Integer)objectArray[0];
                MVMap<Object, VersionedValue> mVMap2 = this.openMap(n);
                if (mVMap2 != null) {
                    Object object = objectArray[1];
                    VersionedValue versionedValue = (VersionedValue)objectArray[2];
                    if (versionedValue == null) {
                        mVMap2.remove(object);
                    } else {
                        mVMap2.put(object, versionedValue);
                    }
                }
                this.undoLog.remove(l3);
            }
        }
    }

    Iterator<Change> getChanges(final Transaction transaction, final long l, final long l2) {
        return new Iterator<Change>(){
            private long logId;
            private Change current;
            {
                this.logId = l - 1L;
                this.fetchNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fetchNext() {
                MVMap<Long, Object[]> mVMap = TransactionStore.this.undoLog;
                synchronized (mVMap) {
                    while (this.logId >= l2) {
                        Long l3 = TransactionStore.getOperationId(transaction.getId(), this.logId);
                        Object[] objectArray = TransactionStore.this.undoLog.get(l3);
                        --this.logId;
                        if (objectArray == null) {
                            if ((l3 = TransactionStore.this.undoLog.floorKey(l3)) == null || TransactionStore.getTransactionId(l3) != transaction.getId()) break;
                            this.logId = TransactionStore.getLogId(l3);
                            continue;
                        }
                        int n = (Integer)objectArray[0];
                        MVMap<Object, VersionedValue> mVMap2 = TransactionStore.this.openMap(n);
                        if (mVMap2 == null) continue;
                        this.current = new Change();
                        this.current.mapName = mVMap2.getName();
                        this.current.key = objectArray[1];
                        VersionedValue versionedValue = (VersionedValue)objectArray[2];
                        this.current.value = versionedValue == null ? null : versionedValue.value;
                        return;
                    }
                }
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Change next() {
                if (this.current == null) {
                    throw DataUtils.newUnsupportedOperationException("no data");
                }
                Change change = this.current;
                this.fetchNext();
                return change;
            }

            @Override
            public void remove() {
                throw DataUtils.newUnsupportedOperationException("remove");
            }
        };
    }

    public static class ArrayType
    implements DataType {
        private final int arrayLength;
        private final DataType[] elementTypes;

        ArrayType(DataType[] dataTypeArray) {
            this.arrayLength = dataTypeArray.length;
            this.elementTypes = dataTypeArray;
        }

        @Override
        public int getMemory(Object object) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType dataType = this.elementTypes[i];
                Object object2 = objectArray[i];
                if (object2 == null) continue;
                n += dataType.getMemory(object2);
            }
            return n;
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType dataType = this.elementTypes[i];
                int n = dataType.compare(objectArray[i], objectArray2[i]);
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        @Override
        public void read(ByteBuffer byteBuffer, Object[] objectArray, int n, boolean bl2) {
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.read(byteBuffer);
            }
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object[] objectArray, int n, boolean bl2) {
            for (int i = 0; i < n; ++i) {
                this.write(writeBuffer, objectArray[i]);
            }
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType dataType = this.elementTypes[i];
                Object object2 = objectArray[i];
                if (object2 == null) {
                    writeBuffer.put((byte)0);
                    continue;
                }
                writeBuffer.put((byte)1);
                dataType.write(writeBuffer, object2);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            Object[] objectArray = new Object[this.arrayLength];
            for (int i = 0; i < this.arrayLength; ++i) {
                DataType dataType = this.elementTypes[i];
                if (byteBuffer.get() != 1) continue;
                objectArray[i] = dataType.read(byteBuffer);
            }
            return objectArray;
        }
    }

    public static class VersionedValueType
    implements DataType {
        private final DataType valueType;

        VersionedValueType(DataType dataType) {
            this.valueType = dataType;
        }

        @Override
        public int getMemory(Object object) {
            VersionedValue versionedValue = (VersionedValue)object;
            return this.valueType.getMemory(versionedValue.value) + 8;
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            VersionedValue versionedValue = (VersionedValue)object;
            VersionedValue versionedValue2 = (VersionedValue)object2;
            long l = versionedValue.operationId - versionedValue2.operationId;
            if (l == 0L) {
                return this.valueType.compare(versionedValue.value, versionedValue2.value);
            }
            return Long.signum(l);
        }

        @Override
        public void read(ByteBuffer byteBuffer, Object[] objectArray, int n, boolean bl2) {
            if (byteBuffer.get() == 0) {
                for (int i = 0; i < n; ++i) {
                    VersionedValue versionedValue = new VersionedValue();
                    versionedValue.value = this.valueType.read(byteBuffer);
                    objectArray[i] = versionedValue;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = this.read(byteBuffer);
                }
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            VersionedValue versionedValue = new VersionedValue();
            versionedValue.operationId = DataUtils.readVarLong(byteBuffer);
            if (byteBuffer.get() == 1) {
                versionedValue.value = this.valueType.read(byteBuffer);
            }
            return versionedValue;
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object[] objectArray, int n, boolean bl2) {
            VersionedValue versionedValue;
            int n2;
            boolean bl3 = true;
            for (n2 = 0; n2 < n; ++n2) {
                versionedValue = (VersionedValue)objectArray[n2];
                if (versionedValue.operationId == 0L && versionedValue.value != null) continue;
                bl3 = false;
            }
            if (bl3) {
                writeBuffer.put((byte)0);
                for (n2 = 0; n2 < n; ++n2) {
                    versionedValue = (VersionedValue)objectArray[n2];
                    this.valueType.write(writeBuffer, versionedValue.value);
                }
            } else {
                writeBuffer.put((byte)1);
                for (n2 = 0; n2 < n; ++n2) {
                    this.write(writeBuffer, objectArray[n2]);
                }
            }
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            VersionedValue versionedValue = (VersionedValue)object;
            writeBuffer.putVarLong(versionedValue.operationId);
            if (versionedValue.value == null) {
                writeBuffer.put((byte)0);
            } else {
                writeBuffer.put((byte)1);
                this.valueType.write(writeBuffer, versionedValue.value);
            }
        }
    }

    static class VersionedValue {
        public long operationId;
        public Object value;

        VersionedValue() {
        }

        public String toString() {
            return this.value + (this.operationId == 0L ? "" : " " + TransactionStore.getTransactionId(this.operationId) + "/" + TransactionStore.getLogId(this.operationId));
        }
    }

    public static class TransactionMap<K, V> {
        final int mapId;
        long readLogId = Long.MAX_VALUE;
        final MVMap<K, VersionedValue> map;
        private Transaction transaction;

        TransactionMap(Transaction transaction, MVMap<K, VersionedValue> mVMap, int n) {
            this.transaction = transaction;
            this.map = mVMap;
            this.mapId = n;
        }

        public void setSavepoint(long l) {
            this.readLogId = l;
        }

        public TransactionMap<K, V> getInstance(Transaction transaction, long l) {
            TransactionMap<K, V> transactionMap = new TransactionMap<K, V>(transaction, this.map, this.mapId);
            transactionMap.setSavepoint(l);
            return transactionMap;
        }

        public long sizeAsLongMax() {
            return this.map.sizeAsLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long sizeAsLong() {
            long l;
            MVMap<Long, Object[]> mVMap;
            long l2 = this.map.sizeAsLong();
            MVMap<Long, Object[]> mVMap2 = mVMap = this.transaction.store.undoLog;
            synchronized (mVMap2) {
                l = mVMap.sizeAsLong();
            }
            if (l == 0L) {
                return l2;
            }
            if (l > l2) {
                long l3 = 0L;
                Cursor<Object, VersionedValue> cursor = this.map.cursor(null);
                while (cursor.hasNext()) {
                    VersionedValue versionedValue;
                    MVMap<Long, Object[]> mVMap3 = this.transaction.store.undoLog;
                    synchronized (mVMap3) {
                        K k = cursor.next();
                        versionedValue = this.getValue(k, this.readLogId, cursor.getValue());
                    }
                    if (versionedValue == null || versionedValue.value == null) continue;
                    ++l3;
                }
                return l3;
            }
            mVMap2 = mVMap;
            synchronized (mVMap2) {
                long l4 = this.map.sizeAsLong();
                MVMap<Object, Integer> mVMap4 = this.transaction.store.createTempMap();
                try {
                    for (Map.Entry<Long, Object[]> entry : mVMap.entrySet()) {
                        Integer n;
                        Object object;
                        Object[] objectArray = entry.getValue();
                        int n2 = (Integer)objectArray[0];
                        if (n2 != this.mapId || this.get(object = objectArray[1]) != null || (n = mVMap4.put(object, 1)) != null) continue;
                        --l4;
                    }
                }
                finally {
                    this.transaction.store.store.removeMap(mVMap4);
                }
                return l4;
            }
        }

        public V remove(K k) {
            return this.set(k, null);
        }

        public V put(K k, V v) {
            DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
            return this.set(k, v);
        }

        public V putCommitted(K k, V v) {
            DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
            VersionedValue versionedValue = new VersionedValue();
            versionedValue.value = v;
            VersionedValue versionedValue2 = this.map.put(k, versionedValue);
            return (V)(versionedValue2 == null ? null : versionedValue2.value);
        }

        private V set(K k, V v) {
            this.transaction.checkNotClosed();
            V v2 = this.get(k);
            boolean bl2 = this.trySet(k, v, false);
            if (bl2) {
                return v2;
            }
            throw DataUtils.newIllegalStateException(101, "Entry is locked", new Object[0]);
        }

        public boolean tryRemove(K k) {
            return this.trySet(k, null, false);
        }

        public boolean tryPut(K k, V v) {
            DataUtils.checkArgument(v != null, "The value may not be null", new Object[0]);
            return this.trySet(k, v, false);
        }

        public boolean trySet(K k, V v, boolean bl2) {
            long l;
            VersionedValue versionedValue;
            VersionedValue versionedValue2 = this.map.get(k);
            if (bl2 && !this.map.areValuesEqual(versionedValue = this.getValue(k, this.readLogId), versionedValue2)) {
                l = TransactionStore.getTransactionId(versionedValue2.operationId);
                if (l == (long)this.transaction.transactionId) {
                    if (v == null) {
                        return true;
                    }
                    if (versionedValue2.value != null) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            versionedValue = new VersionedValue();
            versionedValue.operationId = TransactionStore.getOperationId(this.transaction.transactionId, this.transaction.logId);
            versionedValue.value = v;
            if (versionedValue2 == null) {
                this.transaction.log(this.mapId, k, versionedValue2);
                VersionedValue versionedValue3 = this.map.putIfAbsent(k, versionedValue);
                if (versionedValue3 != null) {
                    this.transaction.logUndo();
                    return false;
                }
                return true;
            }
            l = versionedValue2.operationId;
            if (l == 0L) {
                this.transaction.log(this.mapId, k, versionedValue2);
                if (!this.map.replace(k, versionedValue2, versionedValue)) {
                    this.transaction.logUndo();
                    return false;
                }
                return true;
            }
            int n = TransactionStore.getTransactionId(versionedValue2.operationId);
            if (n == this.transaction.transactionId) {
                this.transaction.log(this.mapId, k, versionedValue2);
                if (!this.map.replace(k, versionedValue2, versionedValue)) {
                    this.transaction.logUndo();
                    return false;
                }
                return true;
            }
            return false;
        }

        public V get(K k) {
            return this.get(k, this.readLogId);
        }

        public V getLatest(K k) {
            return this.get(k, Long.MAX_VALUE);
        }

        public boolean containsKey(K k) {
            return this.get(k) != null;
        }

        public V get(K k, long l) {
            VersionedValue versionedValue = this.getValue(k, l);
            return (V)(versionedValue == null ? null : versionedValue.value);
        }

        public boolean isSameTransaction(K k) {
            VersionedValue versionedValue = this.map.get(k);
            if (versionedValue == null) {
                return false;
            }
            int n = TransactionStore.getTransactionId(versionedValue.operationId);
            return n == this.transaction.transactionId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VersionedValue getValue(K k, long l) {
            Object object = this.getUndoLog();
            synchronized (object) {
                VersionedValue versionedValue = this.map.get(k);
                return this.getValue(k, l, versionedValue);
            }
        }

        Object getUndoLog() {
            return this.transaction.store.undoLog;
        }

        VersionedValue getValue(K k, long l, VersionedValue versionedValue) {
            while (versionedValue != null) {
                long l2 = versionedValue.operationId;
                if (l2 == 0L) {
                    return versionedValue;
                }
                int n = TransactionStore.getTransactionId(l2);
                if (n == this.transaction.transactionId && TransactionStore.getLogId(l2) < l) {
                    return versionedValue;
                }
                Object[] objectArray = this.transaction.store.undoLog.get(l2);
                if (objectArray == null) {
                    if (this.transaction.store.store.isReadOnly()) {
                        return null;
                    }
                    versionedValue = this.map.get(k);
                    continue;
                }
                versionedValue = (VersionedValue)objectArray[2];
            }
            return null;
        }

        public boolean isClosed() {
            return this.map.isClosed();
        }

        public void clear() {
            this.map.clear();
        }

        public K firstKey() {
            Iterator<Object> iterator = this.keyIterator(null);
            return (K)(iterator.hasNext() ? iterator.next() : null);
        }

        public K lastKey() {
            K k = this.map.lastKey();
            while (k != null) {
                if (this.get(k) != null) {
                    return k;
                }
                k = this.map.lowerKey(k);
            }
            return null;
        }

        public K higherKey(K k) {
            K k2;
            while ((k2 = this.map.higherKey(k)) != null && this.get(k2) == null) {
                k = k2;
            }
            return k2;
        }

        public K relativeKey(K k, long l) {
            K k2;
            K k3 = k2 = l > 0L ? this.map.ceilingKey(k) : this.map.floorKey(k);
            if (k2 == null) {
                return k2;
            }
            long l2 = this.map.getKeyIndex(k2);
            return this.map.getKey(l2 + l);
        }

        public K lowerKey(K k) {
            K k2;
            while ((k2 = this.map.lowerKey(k)) != null && this.get(k2) == null) {
                k = k2;
            }
            return k2;
        }

        public Iterator<K> keyIterator(K k) {
            return this.keyIterator(k, false);
        }

        public Iterator<K> keyIterator(final K k, final boolean bl2) {
            return new Iterator<K>(){
                private K currentKey;
                private Cursor<K, VersionedValue> cursor;
                {
                    this.currentKey = k;
                    this.cursor = TransactionMap.this.map.cursor(this.currentKey);
                    this.fetchNext();
                }

                private void fetchNext() {
                    while (this.cursor.hasNext()) {
                        Object k2;
                        try {
                            k2 = this.cursor.next();
                        }
                        catch (IllegalStateException illegalStateException) {
                            if (DataUtils.getErrorCode(illegalStateException.getMessage()) == 9) {
                                this.cursor = TransactionMap.this.map.cursor(this.currentKey);
                                if (!this.cursor.hasNext()) break;
                                this.cursor.next();
                                if (!this.cursor.hasNext()) break;
                                k2 = this.cursor.next();
                            }
                            throw illegalStateException;
                        }
                        this.currentKey = k2;
                        if (bl2) {
                            return;
                        }
                        if (!TransactionMap.this.containsKey(k2)) continue;
                        return;
                    }
                    this.currentKey = null;
                }

                @Override
                public boolean hasNext() {
                    return this.currentKey != null;
                }

                @Override
                public K next() {
                    Object k2 = this.currentKey;
                    this.fetchNext();
                    return k2;
                }

                @Override
                public void remove() {
                    throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                }
            };
        }

        public Iterator<Map.Entry<K, V>> entryIterator(final K k) {
            return new Iterator<Map.Entry<K, V>>(){
                private Map.Entry<K, V> current;
                private K currentKey;
                private Cursor<K, VersionedValue> cursor;
                {
                    this.currentKey = k;
                    this.cursor = TransactionMap.this.map.cursor(this.currentKey);
                    this.fetchNext();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void fetchNext() {
                    while (this.cursor.hasNext()) {
                        Object object = TransactionMap.this.getUndoLog();
                        synchronized (object) {
                            Object k3;
                            try {
                                k3 = this.cursor.next();
                            }
                            catch (IllegalStateException illegalStateException) {
                                if (DataUtils.getErrorCode(illegalStateException.getMessage()) == 9) {
                                    this.cursor = TransactionMap.this.map.cursor(this.currentKey);
                                    if (!this.cursor.hasNext()) {
                                        break;
                                    }
                                    this.cursor.next();
                                    if (!this.cursor.hasNext()) {
                                        break;
                                    }
                                    k3 = this.cursor.next();
                                }
                                throw illegalStateException;
                            }
                            Object k2 = k3;
                            VersionedValue versionedValue = this.cursor.getValue();
                            versionedValue = TransactionMap.this.getValue(k2, TransactionMap.this.readLogId, versionedValue);
                            if (versionedValue != null && versionedValue.value != null) {
                                Object object2 = versionedValue.value;
                                this.current = new DataUtils.MapEntry(k2, object2);
                                this.currentKey = k2;
                                return;
                            }
                        }
                    }
                    this.current = null;
                    this.currentKey = null;
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }

                @Override
                public Map.Entry<K, V> next() {
                    Map.Entry entry = this.current;
                    this.fetchNext();
                    return entry;
                }

                @Override
                public void remove() {
                    throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                }
            };
        }

        public Iterator<K> wrapIterator(final Iterator<K> iterator, final boolean bl2) {
            return new Iterator<K>(){
                private K current;
                {
                    this.fetchNext();
                }

                private void fetchNext() {
                    while (iterator.hasNext()) {
                        this.current = iterator.next();
                        if (bl2) {
                            return;
                        }
                        if (!TransactionMap.this.containsKey(this.current)) continue;
                        return;
                    }
                    this.current = null;
                }

                @Override
                public boolean hasNext() {
                    return this.current != null;
                }

                @Override
                public K next() {
                    Object k = this.current;
                    this.fetchNext();
                    return k;
                }

                @Override
                public void remove() {
                    throw DataUtils.newUnsupportedOperationException("Removing is not supported");
                }
            };
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public DataType getKeyType() {
            return this.map.getKeyType();
        }
    }

    public static class Transaction {
        public static final int STATUS_CLOSED = 0;
        public static final int STATUS_OPEN = 1;
        public static final int STATUS_PREPARED = 2;
        public static final int STATUS_COMMITTING = 3;
        final TransactionStore store;
        final int transactionId;
        long logId;
        private int status;
        private String name;

        Transaction(TransactionStore transactionStore, int n, int n2, String string, long l) {
            this.store = transactionStore;
            this.transactionId = n;
            this.status = n2;
            this.name = string;
            this.logId = l;
        }

        public int getId() {
            return this.transactionId;
        }

        public int getStatus() {
            return this.status;
        }

        void setStatus(int n) {
            this.status = n;
        }

        public void setName(String string) {
            this.checkNotClosed();
            this.name = string;
            this.store.storeTransaction(this);
        }

        public String getName() {
            return this.name;
        }

        public long setSavepoint() {
            return this.logId;
        }

        void log(int n, Object object, Object object2) {
            this.store.log(this, this.logId, n, object, object2);
            ++this.logId;
        }

        void logUndo() {
            this.store.logUndo(this, --this.logId);
        }

        public <K, V> TransactionMap<K, V> openMap(String string) {
            return this.openMap(string, null, null);
        }

        public <K, V> TransactionMap<K, V> openMap(String string, DataType dataType, DataType dataType2) {
            this.checkNotClosed();
            MVMap mVMap = this.store.openMap(string, dataType, dataType2);
            int n = mVMap.getId();
            return new TransactionMap(this, mVMap, n);
        }

        public <K, V> TransactionMap<K, V> openMap(MVMap<K, VersionedValue> mVMap) {
            this.checkNotClosed();
            int n = mVMap.getId();
            return new TransactionMap(this, mVMap, n);
        }

        public void prepare() {
            this.checkNotClosed();
            this.status = 2;
            this.store.storeTransaction(this);
        }

        public void commit() {
            this.checkNotClosed();
            this.store.commit(this, this.logId);
        }

        public void rollbackToSavepoint(long l) {
            this.checkNotClosed();
            this.store.rollbackTo(this, this.logId, l);
            this.logId = l;
        }

        public void rollback() {
            this.checkNotClosed();
            this.store.rollbackTo(this, this.logId, 0L);
            this.store.endTransaction(this);
        }

        public Iterator<Change> getChanges(long l) {
            return this.store.getChanges(this, this.logId, l);
        }

        void checkNotClosed() {
            if (this.status == 0) {
                throw DataUtils.newIllegalStateException(4, "Transaction is closed", new Object[0]);
            }
        }

        public <K, V> void removeMap(TransactionMap<K, V> transactionMap) {
            this.store.removeMap(transactionMap);
        }

        public String toString() {
            return "" + this.transactionId;
        }
    }

    public static class Change {
        public String mapName;
        public Object key;
        public Object value;
    }
}

