/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Database;
import org.h2.engine.SysProperties;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.table.Column;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class SortOrder
implements Comparator<Value[]> {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    public static final int NULLS_FIRST = 2;
    public static final int NULLS_LAST = 4;
    private static final int DEFAULT_NULL_SORT = SysProperties.SORT_NULLS_HIGH ? 1 : -1;
    private final Database database;
    private final int[] queryColumnIndexes;
    private final int[] sortTypes;
    private final ArrayList<SelectOrderBy> orderList;

    public SortOrder(Database database, int[] nArray, int[] nArray2, ArrayList<SelectOrderBy> arrayList) {
        this.database = database;
        this.queryColumnIndexes = nArray;
        this.sortTypes = nArray2;
        this.orderList = arrayList;
    }

    public String getSQL(Expression[] expressionArray, int n) {
        StatementBuilder statementBuilder = new StatementBuilder();
        int n2 = 0;
        for (int n3 : this.queryColumnIndexes) {
            statementBuilder.appendExceptFirst(", ");
            if (n3 < n) {
                statementBuilder.append(n3 + 1);
            } else {
                statementBuilder.append('=').append(StringUtils.unEnclose(expressionArray[n3].getSQL()));
            }
            int n4 = this.sortTypes[n2++];
            if ((n4 & 1) != 0) {
                statementBuilder.append(" DESC");
            }
            if ((n4 & 2) != 0) {
                statementBuilder.append(" NULLS FIRST");
                continue;
            }
            if ((n4 & 4) == 0) continue;
            statementBuilder.append(" NULLS LAST");
        }
        return statementBuilder.toString();
    }

    public static int compareNull(boolean bl2, int n) {
        if ((n & 2) != 0) {
            return bl2 ? -1 : 1;
        }
        if ((n & 4) != 0) {
            return bl2 ? 1 : -1;
        }
        int n2 = bl2 ? DEFAULT_NULL_SORT : -DEFAULT_NULL_SORT;
        return (n & 1) == 0 ? n2 : -n2;
    }

    @Override
    public int compare(Value[] valueArray, Value[] valueArray2) {
        int n = this.queryColumnIndexes.length;
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            int n2 = this.queryColumnIndexes[i];
            int n3 = this.sortTypes[i];
            Value value = valueArray[n2];
            Value value2 = valueArray2[n2];
            boolean bl3 = value == ValueNull.INSTANCE;
            boolean bl4 = bl2 = value2 == ValueNull.INSTANCE;
            if (bl3 || bl2) {
                if (bl3 == bl2) continue;
                return SortOrder.compareNull(bl3, n3);
            }
            int n4 = this.database.compare(value, value2);
            if (n4 == 0) continue;
            return (n3 & 1) == 0 ? n4 : -n4;
        }
        return 0;
    }

    public void sort(ArrayList<Value[]> arrayList) {
        Collections.sort(arrayList, this);
    }

    public void sort(ArrayList<Value[]> arrayList, int n, int n2) {
        int n3 = arrayList.size();
        if (arrayList.isEmpty() || n >= n3 || n2 == 0) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        if (n2 == 1 && n == 0) {
            arrayList.set(0, Collections.min(arrayList, this));
            return;
        }
        Value[][] valueArray = (Value[][])arrayList.toArray((T[])new Value[n3][]);
        Utils.sortTopN(valueArray, n, n2, this);
        int n4 = Math.min(n + n2, n3);
        for (int i = 0; i < n4; ++i) {
            arrayList.set(i, valueArray[i]);
        }
    }

    public int[] getQueryColumnIndexes() {
        return this.queryColumnIndexes;
    }

    public Column getColumn(int n, TableFilter tableFilter) {
        if (this.orderList == null) {
            return null;
        }
        SelectOrderBy selectOrderBy = this.orderList.get(n);
        Expression expression = selectOrderBy.expression;
        if (expression == null) {
            return null;
        }
        if ((expression = expression.getNonAliasExpression()).isConstant()) {
            return null;
        }
        if (!(expression instanceof ExpressionColumn)) {
            return null;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)expression;
        if (expressionColumn.getTableFilter() != tableFilter) {
            return null;
        }
        return expressionColumn.getColumn();
    }

    public int[] getSortTypes() {
        return this.sortTypes;
    }
}

