/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.h2.message.DbException;
import org.h2.message.TraceSystem;
import org.h2.store.FileLock;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.util.New;

public class FileLister {
    private FileLister() {
    }

    public static void tryUnlockDatabase(List<String> list, String string) throws SQLException {
        for (String string2 : list) {
            Object object;
            if (string2.endsWith(".lock.db")) {
                object = new FileLock(new TraceSystem(null), string2, 1000);
                try {
                    ((FileLock)object).lock(1);
                    ((FileLock)object).unlock();
                    continue;
                }
                catch (DbException dbException) {
                    throw DbException.get(90133, string).getSQLException();
                }
            }
            if (!string2.endsWith(".mv.db")) continue;
            try {
                object = FilePath.get(string2).open("r");
                Throwable throwable = null;
                try {
                    java.nio.channels.FileLock fileLock = ((FileChannel)object).tryLock(0L, Long.MAX_VALUE, true);
                    fileLock.release();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object == null) continue;
                    if (throwable != null) {
                        try {
                            ((AbstractInterruptibleChannel)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((AbstractInterruptibleChannel)object).close();
                }
            }
            catch (Exception exception) {
                throw DbException.get(90133, exception, string).getSQLException();
            }
        }
    }

    public static String getDir(String string) {
        if (string == null || string.equals("")) {
            return ".";
        }
        return FileUtils.toRealPath(string);
    }

    public static ArrayList<String> getDatabaseFiles(String string, String string2, boolean bl2) {
        ArrayList<String> arrayList = New.arrayList();
        String string3 = string2 == null ? null : FileUtils.toRealPath(string + "/" + string2) + ".";
        for (String string4 : FileUtils.newDirectoryStream(string)) {
            boolean bl3 = false;
            if (string4.endsWith(".lobs.db")) {
                if (string3 == null || string4.startsWith(string3)) {
                    arrayList.addAll(FileLister.getDatabaseFiles(string4, null, bl2));
                    bl3 = true;
                }
            } else if (string4.endsWith(".lob.db")) {
                bl3 = true;
            } else if (string4.endsWith(".h2.db")) {
                bl3 = true;
            } else if (string4.endsWith(".mv.db")) {
                bl3 = true;
            } else if (bl2) {
                if (string4.endsWith(".lock.db")) {
                    bl3 = true;
                } else if (string4.endsWith(".temp.db")) {
                    bl3 = true;
                } else if (string4.endsWith(".trace.db")) {
                    bl3 = true;
                }
            }
            if (!bl3 || string2 != null && !string4.startsWith(string3)) continue;
            String string5 = string4;
            arrayList.add(string5);
        }
        return arrayList;
    }
}

