/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import org.h2.store.fs.FileBase;

class FileNio
extends FileBase {
    private final String name;
    private final FileChannel channel;

    FileNio(String string, String string2) throws IOException {
        this.name = string;
        this.channel = new RandomAccessFile(string, string2).getChannel();
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.channel.close();
    }

    @Override
    public long position() throws IOException {
        return this.channel.position();
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.channel.read(byteBuffer);
    }

    @Override
    public FileChannel position(long l) throws IOException {
        this.channel.position(l);
        return this;
    }

    @Override
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        return this.channel.read(byteBuffer, l);
    }

    @Override
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        return this.channel.write(byteBuffer, l);
    }

    @Override
    public FileChannel truncate(long l) throws IOException {
        long l2 = this.channel.size();
        if (l < l2) {
            long l3 = this.channel.position();
            this.channel.truncate(l);
            long l4 = this.channel.position();
            if (l3 < l) {
                if (l4 != l3) {
                    this.channel.position(l3);
                }
            } else if (l4 > l) {
                this.channel.position(l);
            }
        }
        return this;
    }

    @Override
    public void force(boolean bl2) throws IOException {
        this.channel.force(bl2);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        try {
            return this.channel.write(byteBuffer);
        }
        catch (NonWritableChannelException nonWritableChannelException) {
            throw new IOException("read only");
        }
    }

    @Override
    public synchronized FileLock tryLock(long l, long l2, boolean bl2) throws IOException {
        return this.channel.tryLock(l, l2, bl2);
    }

    public String toString() {
        return "nio:" + this.name;
    }
}

