/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.util.concurrent.TimeUnit;
import org.h2.engine.SysProperties;
import org.h2.store.fs.FileBase;

class FileNioMapped
extends FileBase {
    private static final long GC_TIMEOUT_MS = 10000L;
    private final String name;
    private final FileChannel.MapMode mode;
    private RandomAccessFile file;
    private MappedByteBuffer mapped;
    private long fileLength;
    private int pos;

    FileNioMapped(String string, String string2) throws IOException {
        this.mode = "r".equals(string2) ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
        this.name = string;
        this.file = new RandomAccessFile(string, string2);
        this.reMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unMap() throws IOException {
        Object object;
        if (this.mapped == null) {
            return;
        }
        this.mapped.force();
        boolean bl2 = true;
        if (SysProperties.NIO_CLEANER_HACK) {
            try {
                object = this.mapped.getClass().getMethod("cleaner", new Class[0]);
                ((Method)object).setAccessible(true);
                Object object2 = ((Method)object).invoke((Object)this.mapped, new Object[0]);
                if (object2 != null) {
                    Method method = object2.getClass().getMethod("clean", new Class[0]);
                    method.invoke(object2, new Object[0]);
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
            }
            finally {
                this.mapped = null;
            }
        }
        if (bl2) {
            object = new WeakReference<MappedByteBuffer>(this.mapped);
            this.mapped = null;
            long l = System.nanoTime();
            while (((Reference)object).get() != null) {
                if (System.nanoTime() - l > TimeUnit.MILLISECONDS.toNanos(10000L)) {
                    throw new IOException("Timeout (10000 ms) reached while trying to GC mapped buffer");
                }
                System.gc();
                Thread.yield();
            }
        }
    }

    private void reMap() throws IOException {
        int n = 0;
        if (this.mapped != null) {
            n = this.pos;
            this.unMap();
        }
        this.fileLength = this.file.length();
        FileNioMapped.checkFileSizeLimit(this.fileLength);
        this.mapped = this.file.getChannel().map(this.mode, 0L, this.fileLength);
        int n2 = this.mapped.limit();
        int n3 = this.mapped.capacity();
        if ((long)n2 < this.fileLength || (long)n3 < this.fileLength) {
            throw new IOException("Unable to map: length=" + n2 + " capacity=" + n3 + " length=" + this.fileLength);
        }
        if (SysProperties.NIO_LOAD_MAPPED) {
            this.mapped.load();
        }
        this.pos = Math.min(n, (int)this.fileLength);
    }

    private static void checkFileSizeLimit(long l) throws IOException {
        if (l > Integer.MAX_VALUE) {
            throw new IOException("File over 2GB is not supported yet when using this file system");
        }
    }

    @Override
    public void implCloseChannel() throws IOException {
        if (this.file != null) {
            this.unMap();
            this.file.close();
            this.file = null;
        }
    }

    @Override
    public long position() {
        return this.pos;
    }

    public String toString() {
        return "nioMapped:" + this.name;
    }

    @Override
    public synchronized long size() throws IOException {
        return this.fileLength;
    }

    @Override
    public synchronized int read(ByteBuffer byteBuffer) throws IOException {
        try {
            int n = byteBuffer.remaining();
            if (n == 0) {
                return 0;
            }
            if ((n = (int)Math.min((long)n, this.fileLength - (long)this.pos)) <= 0) {
                return -1;
            }
            this.mapped.position(this.pos);
            this.mapped.get(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n);
            byteBuffer.position(byteBuffer.position() + n);
            this.pos += n;
            return n;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EOFException eOFException = new EOFException("EOF");
            eOFException.initCause(illegalArgumentException);
            throw eOFException;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            EOFException eOFException = new EOFException("EOF");
            eOFException.initCause(bufferUnderflowException);
            throw eOFException;
        }
    }

    @Override
    public FileChannel position(long l) throws IOException {
        FileNioMapped.checkFileSizeLimit(l);
        this.pos = (int)l;
        return this;
    }

    @Override
    public synchronized FileChannel truncate(long l) throws IOException {
        if (this.mode == FileChannel.MapMode.READ_ONLY) {
            throw new NonWritableChannelException();
        }
        if (l < this.size()) {
            this.setFileLength(l);
        }
        return this;
    }

    public synchronized void setFileLength(long l) throws IOException {
        FileNioMapped.checkFileSizeLimit(l);
        int n = this.pos;
        this.unMap();
        int n2 = 0;
        while (true) {
            try {
                this.file.setLength(l);
            }
            catch (IOException iOException) {
                if (n2 > 16 || iOException.toString().indexOf("user-mapped section open") < 0) {
                    throw iOException;
                }
                System.gc();
                ++n2;
                continue;
            }
            break;
        }
        this.reMap();
        this.pos = (int)Math.min(l, (long)n);
    }

    @Override
    public void force(boolean bl2) throws IOException {
        this.mapped.force();
        this.file.getFD().sync();
    }

    @Override
    public synchronized int write(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        if (this.mapped.capacity() < this.pos + n) {
            this.setFileLength(this.pos + n);
        }
        this.mapped.position(this.pos);
        this.mapped.put(byteBuffer);
        this.pos += n;
        return n;
    }

    @Override
    public synchronized FileLock tryLock(long l, long l2, boolean bl2) throws IOException {
        return this.file.getChannel().tryLock(l, l2, bl2);
    }
}

