/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

public final class BitField {
    private static final int ADDRESS_BITS = 6;
    private static final int BITS = 64;
    private static final int ADDRESS_MASK = 63;
    private long[] data;
    private int maxLength;

    public BitField() {
        this(64);
    }

    public BitField(int n) {
        this.data = new long[n >>> 3];
    }

    public int nextClearBit(int n) {
        int n2 = this.data.length;
        for (int i = n >> 6; i < n2; ++i) {
            int n3;
            if (this.data[i] == -1L) continue;
            int n4 = n3 + 64;
            for (n3 = Math.max(n, i << 6); n3 < n4; ++n3) {
                if (this.get(n3)) continue;
                return n3;
            }
        }
        return n2 << 6;
    }

    public boolean get(int n) {
        int n2 = n >> 6;
        if (n2 >= this.data.length) {
            return false;
        }
        return (this.data[n2] & BitField.getBitMask(n)) != 0L;
    }

    public int getByte(int n) {
        int n2 = n >> 6;
        if (n2 >= this.data.length) {
            return 0;
        }
        return (int)(this.data[n2] >>> (n & 0x38) & 0xFFL);
    }

    public void setByte(int n, int n2) {
        int n3 = n >> 6;
        this.checkCapacity(n3);
        int n4 = n3;
        this.data[n4] = this.data[n4] | (long)n2 << (n & 0x38);
        if (this.maxLength < n && n2 != 0) {
            this.maxLength = n + 7;
        }
    }

    public void set(int n) {
        int n2 = n >> 6;
        this.checkCapacity(n2);
        int n3 = n2;
        this.data[n3] = this.data[n3] | BitField.getBitMask(n);
        if (this.maxLength < n) {
            this.maxLength = n;
        }
    }

    public void clear(int n) {
        int n2 = n >> 6;
        if (n2 >= this.data.length) {
            return;
        }
        int n3 = n2;
        this.data[n3] = this.data[n3] & (BitField.getBitMask(n) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static long getBitMask(int n) {
        return 1L << (n & 0x3F);
    }

    private void checkCapacity(int n) {
        if (n >= this.data.length) {
            this.expandCapacity(n);
        }
    }

    private void expandCapacity(int n) {
        while (n >= this.data.length) {
            int n2 = this.data.length == 0 ? 1 : this.data.length * 2;
            long[] lArray = new long[n2];
            System.arraycopy(this.data, 0, lArray, 0, this.data.length);
            this.data = lArray;
        }
    }

    public void set(int n, int n2, boolean bl2) {
        for (int i = n2 - 1; i >= n; --i) {
            this.set(i, bl2);
        }
        if (bl2) {
            if (n2 > this.maxLength) {
                this.maxLength = n2;
            }
        } else if (n2 >= this.maxLength) {
            this.maxLength = n;
        }
    }

    private void set(int n, boolean bl2) {
        if (bl2) {
            this.set(n);
        } else {
            this.clear(n);
        }
    }

    public int length() {
        int n;
        for (n = this.maxLength >> 6; n > 0 && this.data[n] == 0L; --n) {
        }
        this.maxLength = (n << 6) + (64 - Long.numberOfLeadingZeros(this.data[n]));
        return this.maxLength;
    }
}

