/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CloseWatcher
extends PhantomReference<Object> {
    private static ReferenceQueue<Object> queue = new ReferenceQueue();
    private static Set<CloseWatcher> refs = CloseWatcher.createSet();
    private String openStackTrace;
    private Closeable closeable;

    public CloseWatcher(Object object, ReferenceQueue<Object> referenceQueue, Closeable closeable) {
        super(object, referenceQueue);
        this.closeable = closeable;
    }

    private static Set<CloseWatcher> createSet() {
        return Collections.synchronizedSet(new HashSet());
    }

    public static CloseWatcher pollUnclosed() {
        CloseWatcher closeWatcher;
        ReferenceQueue<Object> referenceQueue = queue;
        if (referenceQueue == null) {
            return null;
        }
        do {
            if ((closeWatcher = (CloseWatcher)referenceQueue.poll()) == null) {
                return null;
            }
            if (refs == null) continue;
            refs.remove(closeWatcher);
        } while (closeWatcher.closeable == null);
        return closeWatcher;
    }

    public static CloseWatcher register(Object object, Closeable closeable, boolean bl2) {
        ReferenceQueue<Object> referenceQueue = queue;
        if (referenceQueue == null) {
            queue = referenceQueue = new ReferenceQueue();
        }
        CloseWatcher closeWatcher = new CloseWatcher(object, referenceQueue, closeable);
        if (bl2) {
            Exception exception = new Exception("Open Stack Trace");
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            closeWatcher.openStackTrace = stringWriter.toString();
        }
        if (refs == null) {
            refs = CloseWatcher.createSet();
        }
        refs.add(closeWatcher);
        return closeWatcher;
    }

    public static void unregister(CloseWatcher closeWatcher) {
        closeWatcher.closeable = null;
        refs.remove(closeWatcher);
    }

    public String getOpenStackTrace() {
        return this.openStackTrace;
    }

    public Closeable getCloseable() {
        return this.closeable;
    }
}

