/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import javax.naming.Context;
import javax.sql.DataSource;
import org.h2.api.CustomDataTypesHandler;
import org.h2.api.JavaObjectSerializer;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.DataHandler;
import org.h2.util.New;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class JdbcUtils {
    public static JavaObjectSerializer serializer;
    public static CustomDataTypesHandler customDataTypesHandler;
    private static final String[] DRIVERS;
    private static boolean allowAllClasses;
    private static HashSet<String> allowedClassNames;
    private static ArrayList<Utils.ClassFactory> userClassFactories;
    private static String[] allowedClassNamePrefixes;

    private JdbcUtils() {
    }

    public static void addClassFactory(Utils.ClassFactory classFactory) {
        JdbcUtils.getUserClassFactories().add(classFactory);
    }

    public static void removeClassFactory(Utils.ClassFactory classFactory) {
        JdbcUtils.getUserClassFactories().remove(classFactory);
    }

    private static ArrayList<Utils.ClassFactory> getUserClassFactories() {
        if (userClassFactories == null) {
            userClassFactories = new ArrayList();
        }
        return userClassFactories;
    }

    public static <Z> Class<Z> loadUserClass(String string) {
        if (allowedClassNames == null) {
            String string2 = SysProperties.ALLOWED_CLASSES;
            ArrayList<String> object = New.arrayList();
            int n = 0;
            HashSet hashSet = New.hashSet();
            for (String string3 : StringUtils.arraySplit(string2, ',', true)) {
                if (string3.equals("*")) {
                    n = 1;
                    continue;
                }
                if (string3.endsWith("*")) {
                    object.add(string3.substring(0, string3.length() - 1));
                    continue;
                }
                hashSet.add(string3);
            }
            allowedClassNamePrefixes = new String[object.size()];
            object.toArray(allowedClassNamePrefixes);
            allowAllClasses = n;
            allowedClassNames = hashSet;
        }
        if (!allowAllClasses && !allowedClassNames.contains(string)) {
            boolean bl2 = false;
            for (String string4 : allowedClassNamePrefixes) {
                if (!string.startsWith(string4)) continue;
                bl2 = true;
            }
            if (!bl2) {
                throw DbException.get(90134, string);
            }
        }
        for (Utils.ClassFactory classFactory : JdbcUtils.getUserClassFactories()) {
            if (!classFactory.match(string)) continue;
            try {
                Class<?> clazz = classFactory.loadClass(string);
                if (clazz == null) continue;
                return clazz;
            }
            catch (Exception exception) {
                throw DbException.get(90086, exception, string);
            }
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception exception) {
                throw DbException.get(90086, classNotFoundException, string);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw DbException.get(90086, noClassDefFoundError, string);
        }
        catch (Error error) {
            throw DbException.get(50000, error, string);
        }
    }

    public static void closeSilently(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static Connection getConnection(String string, String string2, String string3, String string4) throws SQLException {
        Properties properties = new Properties();
        if (string3 != null) {
            properties.setProperty("user", string3);
        }
        if (string4 != null) {
            properties.setProperty("password", string4);
        }
        return JdbcUtils.getConnection(string, string2, properties);
    }

    public static Connection getConnection(String string, String string2, Properties properties) throws SQLException {
        if (!StringUtils.isNullOrEmpty(string)) {
            Class clazz = JdbcUtils.loadUserClass(string);
            if (Driver.class.isAssignableFrom(clazz)) {
                return DriverManager.getConnection(string2, properties);
            }
            if (Context.class.isAssignableFrom(clazz)) {
                try {
                    Context context = (Context)clazz.newInstance();
                    DataSource dataSource = (DataSource)context.lookup(string2);
                    String string3 = properties.getProperty("user");
                    String string4 = properties.getProperty("password");
                    if (StringUtils.isNullOrEmpty(string3) && StringUtils.isNullOrEmpty(string4)) {
                        return dataSource.getConnection();
                    }
                    return dataSource.getConnection(string3, string4);
                }
                catch (Exception exception) {
                    throw DbException.toSQLException(exception);
                }
            }
            return DriverManager.getConnection(string2, properties);
        }
        JdbcUtils.load(string2);
        return DriverManager.getConnection(string2, properties);
    }

    public static String getDriver(String string) {
        if (string.startsWith("jdbc:")) {
            string = string.substring("jdbc:".length());
            for (int i = 0; i < DRIVERS.length; i += 2) {
                String string2 = DRIVERS[i];
                if (!string.startsWith(string2)) continue;
                return DRIVERS[i + 1];
            }
        }
        return null;
    }

    public static void load(String string) {
        String string2 = JdbcUtils.getDriver(string);
        if (string2 != null) {
            JdbcUtils.loadUserClass(string2);
        }
    }

    public static byte[] serialize(Object object, DataHandler dataHandler) {
        try {
            JavaObjectSerializer javaObjectSerializer = null;
            if (dataHandler != null) {
                javaObjectSerializer = dataHandler.getJavaObjectSerializer();
            }
            if (javaObjectSerializer != null) {
                return javaObjectSerializer.serialize(object);
            }
            if (serializer != null) {
                return serializer.serialize(object);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            throw DbException.get(90026, throwable, throwable.toString());
        }
    }

    public static Object deserialize(byte[] byArray, DataHandler dataHandler) {
        try {
            ObjectInputStream objectInputStream;
            JavaObjectSerializer javaObjectSerializer = null;
            if (dataHandler != null) {
                javaObjectSerializer = dataHandler.getJavaObjectSerializer();
            }
            if (javaObjectSerializer != null) {
                return javaObjectSerializer.deserialize(byArray);
            }
            if (serializer != null) {
                return serializer.deserialize(byArray);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (SysProperties.USE_THREAD_CONTEXT_CLASS_LOADER) {
                final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                objectInputStream = new ObjectInputStream(byteArrayInputStream){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                        try {
                            return Class.forName(objectStreamClass.getName(), true, classLoader);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            return super.resolveClass(objectStreamClass);
                        }
                    }
                };
            } else {
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
            }
            return objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            throw DbException.get(90027, throwable, throwable.toString());
        }
    }

    static {
        String string;
        DRIVERS = new String[]{"h2:", "org.h2.Driver", "Cache:", "com.intersys.jdbc.CacheDriver", "daffodilDB://", "in.co.daffodil.db.rmi.RmiDaffodilDBDriver", "daffodil", "in.co.daffodil.db.jdbc.DaffodilDBDriver", "db2:", "com.ibm.db2.jcc.DB2Driver", "derby:net:", "org.apache.derby.jdbc.ClientDriver", "derby://", "org.apache.derby.jdbc.ClientDriver", "derby:", "org.apache.derby.jdbc.EmbeddedDriver", "FrontBase:", "com.frontbase.jdbc.FBJDriver", "firebirdsql:", "org.firebirdsql.jdbc.FBDriver", "hsqldb:", "org.hsqldb.jdbcDriver", "informix-sqli:", "com.informix.jdbc.IfxDriver", "jtds:", "net.sourceforge.jtds.jdbc.Driver", "microsoft:", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "mimer:", "com.mimer.jdbc.Driver", "mysql:", "com.mysql.jdbc.Driver", "odbc:", "sun.jdbc.odbc.JdbcOdbcDriver", "oracle:", "oracle.jdbc.driver.OracleDriver", "pervasive:", "com.pervasive.jdbc.v2.Driver", "pointbase:micro:", "com.pointbase.me.jdbc.jdbcDriver", "pointbase:", "com.pointbase.jdbc.jdbcUniversalDriver", "postgresql:", "org.postgresql.Driver", "sybase:", "com.sybase.jdbc3.jdbc.SybDriver", "sqlserver:", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "teradata:", "com.ncr.teradata.TeraDriver"};
        userClassFactories = new ArrayList();
        String string2 = SysProperties.JAVA_OBJECT_SERIALIZER;
        if (string2 != null) {
            try {
                serializer = (JavaObjectSerializer)JdbcUtils.loadUserClass(string2).newInstance();
            }
            catch (Exception exception) {
                throw DbException.convert(exception);
            }
        }
        if ((string = SysProperties.CUSTOM_DATA_TYPES_HANDLER) != null) {
            try {
                customDataTypesHandler = (CustomDataTypesHandler)JdbcUtils.loadUserClass(string).newInstance();
            }
            catch (Exception exception) {
                throw DbException.convert(exception);
            }
        }
    }
}

