/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.h2.util.ToDateTokenizer;

public class ToDateParser {
    private final String unmodifiedInputStr;
    private final String unmodifiedFormatStr;
    private final ConfigParam functionName;
    private String inputStr;
    private String formatStr;
    private final Calendar resultCalendar = (Calendar)Calendar.getInstance().clone();
    private Integer nanos;

    private ToDateParser(ConfigParam configParam, String string, String string2) {
        this.resultCalendar.set(1, 1970);
        this.resultCalendar.set(2, Calendar.getInstance().get(2));
        this.resultCalendar.clear(6);
        this.resultCalendar.clear(7);
        this.resultCalendar.clear(8);
        this.resultCalendar.set(5, 1);
        this.resultCalendar.set(10, 0);
        this.resultCalendar.set(11, 0);
        this.resultCalendar.set(12, 0);
        this.resultCalendar.set(13, 0);
        this.resultCalendar.set(14, 0);
        this.resultCalendar.set(9, 0);
        this.functionName = configParam;
        this.unmodifiedInputStr = this.inputStr = string.trim();
        this.formatStr = string2 == null || string2.isEmpty() ? configParam.getDefaultFormatStr() : string2.trim();
        this.unmodifiedFormatStr = this.formatStr;
    }

    private static ToDateParser getDateParser(String string, String string2) {
        ToDateParser toDateParser = new ToDateParser(ConfigParam.TO_DATE, string, string2);
        ToDateParser.parse(toDateParser);
        return toDateParser;
    }

    private static ToDateParser getTimestampParser(String string, String string2) {
        ToDateParser toDateParser = new ToDateParser(ConfigParam.TO_TIMESTAMP, string, string2);
        ToDateParser.parse(toDateParser);
        return toDateParser;
    }

    private Timestamp getResultingTimestamp() {
        Calendar calendar = (Calendar)this.getResultCalendar().clone();
        int n = this.nanos == null ? calendar.get(14) * 1000000 : this.nanos;
        calendar.set(14, 0);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(n);
        return timestamp;
    }

    Calendar getResultCalendar() {
        return this.resultCalendar;
    }

    String getInputStr() {
        return this.inputStr;
    }

    String getFormatStr() {
        return this.formatStr;
    }

    String getFunctionName() {
        return this.functionName.name();
    }

    void setNanos(int n) {
        this.nanos = n;
    }

    private boolean hasToParseData() {
        return this.formatStr.length() > 0;
    }

    private void removeFirstChar() {
        if (!this.formatStr.isEmpty()) {
            this.formatStr = this.formatStr.substring(1);
        }
        if (!this.inputStr.isEmpty()) {
            this.inputStr = this.inputStr.substring(1);
        }
    }

    private static ToDateParser parse(ToDateParser toDateParser) {
        while (toDateParser.hasToParseData()) {
            List<ToDateTokenizer.FormatTokenEnum> list = ToDateTokenizer.FormatTokenEnum.getTokensInQuestion(toDateParser.getFormatStr());
            if (list.isEmpty()) {
                toDateParser.removeFirstChar();
                continue;
            }
            boolean bl2 = false;
            for (ToDateTokenizer.FormatTokenEnum formatTokenEnum : list) {
                if (!formatTokenEnum.parseFormatStrWithToken(toDateParser)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            toDateParser.removeFirstChar();
        }
        return toDateParser;
    }

    void remove(String string, String string2) {
        if (string != null && this.inputStr.length() >= string.length()) {
            this.inputStr = this.inputStr.substring(string.length());
        }
        if (string2 != null && this.formatStr.length() >= string2.length()) {
            this.formatStr = this.formatStr.substring(string2.length());
        }
    }

    public String toString() {
        int n = this.inputStr.length();
        int n2 = this.unmodifiedInputStr.length();
        int n3 = n2 - n;
        int n4 = n <= 0 ? n : n - 1;
        int n5 = this.unmodifiedFormatStr.length();
        int n6 = n5 - this.formatStr.length();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("\n    %s('%s', '%s')", new Object[]{this.functionName, this.unmodifiedInputStr, this.unmodifiedFormatStr}));
        stringBuilder.append(String.format("\n      %s^%s ,  %s^ <-- Parsing failed at this point", String.format("%" + (this.functionName.name().length() + n3) + "s", ""), n4 <= 0 ? "" : String.format("%" + n4 + "s", ""), n6 <= 0 ? "" : String.format("%" + n6 + "s", "")));
        return stringBuilder.toString();
    }

    public static Timestamp toTimestamp(String string, String string2) {
        ToDateParser toDateParser = ToDateParser.getTimestampParser(string, string2);
        return toDateParser.getResultingTimestamp();
    }

    public static Timestamp toDate(String string, String string2) {
        ToDateParser toDateParser = ToDateParser.getDateParser(string, string2);
        return toDateParser.getResultingTimestamp();
    }

    private static enum ConfigParam {
        TO_DATE("DD MON YYYY"),
        TO_TIMESTAMP("DD MON YYYY HH:MI:SS");

        private final String defaultFormatStr;

        private ConfigParam(String string2) {
            this.defaultFormatStr = string2;
        }

        String getDefaultFormatStr() {
            return this.defaultFormatStr;
        }
    }
}

