/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueBoolean
extends Value {
    public static final int PRECISION = 1;
    public static final int DISPLAY_SIZE = 5;
    private static final Object TRUE = new ValueBoolean(true);
    private static final Object FALSE = new ValueBoolean(false);
    private final Boolean value;

    private ValueBoolean(boolean bl2) {
        this.value = bl2;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public String getString() {
        return this.value != false ? "TRUE" : "FALSE";
    }

    @Override
    public Value negate() {
        return (ValueBoolean)(this.value != false ? FALSE : TRUE);
    }

    @Override
    public Boolean getBoolean() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        boolean bl2 = ((ValueBoolean)value).value;
        boolean bl3 = this.value;
        return bl3 == bl2 ? 0 : (bl3 ? 1 : -1);
    }

    @Override
    public long getPrecision() {
        return 1L;
    }

    @Override
    public int hashCode() {
        return this.value != false ? 1 : 0;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBoolean(n, this.value);
    }

    public static ValueBoolean get(boolean bl2) {
        return (ValueBoolean)(bl2 ? TRUE : FALSE);
    }

    @Override
    public int getDisplaySize() {
        return 5;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }
}

