/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueUuid
extends Value {
    private static final int PRECISION = 16;
    private static final int DISPLAY_SIZE = 36;
    private final long high;
    private final long low;

    private ValueUuid(long l, long l2) {
        this.high = l;
        this.low = l2;
    }

    @Override
    public int hashCode() {
        return (int)(this.high >>> 32 ^ this.high ^ this.low >>> 32 ^ this.low);
    }

    public static ValueUuid getNewRandom() {
        long l = MathUtils.secureRandomLong();
        long l2 = MathUtils.secureRandomLong();
        l = l & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        l2 = l2 & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new ValueUuid(l, l2);
    }

    public static ValueUuid get(byte[] byArray) {
        if (byArray.length < 16) {
            return ValueUuid.get(StringUtils.convertBytesToHex(byArray));
        }
        long l = Utils.readLong(byArray, 0);
        long l2 = Utils.readLong(byArray, 8);
        return (ValueUuid)Value.cache(new ValueUuid(l, l2));
    }

    public static ValueUuid get(long l, long l2) {
        return (ValueUuid)Value.cache(new ValueUuid(l, l2));
    }

    public static ValueUuid get(String string) {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            if (c2 >= '0' && c2 <= '9') {
                l = l << 4 | (long)(c2 - 48);
            } else if (c2 >= 'a' && c2 <= 'f') {
                l = l << 4 | (long)(c2 - 97 + 10);
            } else {
                if (c2 == '-') continue;
                if (c2 >= 'A' && c2 <= 'F') {
                    l = l << 4 | (long)(c2 - 65 + 10);
                } else {
                    if (c2 <= ' ') continue;
                    throw DbException.get(22018, string);
                }
            }
            if (n++ != 15) continue;
            l2 = l;
            l = 0L;
        }
        return (ValueUuid)Value.cache(new ValueUuid(l2, l));
    }

    @Override
    public String getSQL() {
        return StringUtils.quoteStringSQL(this.getString());
    }

    @Override
    public int getType() {
        return 20;
    }

    @Override
    public long getPrecision() {
        return 16L;
    }

    private static void appendHex(StringBuilder stringBuilder, long l, int n) {
        for (int i = n * 8 - 4; i >= 0; i -= 8) {
            stringBuilder.append(Integer.toHexString((int)(l >> i) & 0xF)).append(Integer.toHexString((int)(l >> i - 4) & 0xF));
        }
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(36);
        ValueUuid.appendHex(stringBuilder, this.high >> 32, 4);
        stringBuilder.append('-');
        ValueUuid.appendHex(stringBuilder, this.high >> 16, 2);
        stringBuilder.append('-');
        ValueUuid.appendHex(stringBuilder, this.high, 2);
        stringBuilder.append('-');
        ValueUuid.appendHex(stringBuilder, this.low >> 48, 2);
        stringBuilder.append('-');
        ValueUuid.appendHex(stringBuilder, this.low, 6);
        return stringBuilder.toString();
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        if (value == this) {
            return 0;
        }
        ValueUuid valueUuid = (ValueUuid)value;
        if (this.high == valueUuid.high) {
            return MathUtils.compareLong(this.low, valueUuid.low);
        }
        return this.high > valueUuid.high ? 1 : -1;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueUuid && this.compareSecure((Value)object, null) == 0;
    }

    @Override
    public Object getObject() {
        return new UUID(this.high, this.low);
    }

    @Override
    public byte[] getBytes() {
        byte[] byArray = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(this.high >> 8 * (7 - i) & 0xFFL);
            byArray[8 + i] = (byte)(this.low >> 8 * (7 - i) & 0xFFL);
        }
        return byArray;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBytes(n, this.getBytes());
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    @Override
    public int getDisplaySize() {
        return 36;
    }
}

