/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.protocol;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransientConnectionException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.LocalInfileInterceptor;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.UrlParser;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.com.read.ErrorPacket;
import org.mariadb.jdbc.internal.com.read.dao.Results;
import org.mariadb.jdbc.internal.com.read.resultset.ColumnDefinition;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.com.read.resultset.UpdatableResultSet;
import org.mariadb.jdbc.internal.com.send.ComQuery;
import org.mariadb.jdbc.internal.com.send.ComStmtExecute;
import org.mariadb.jdbc.internal.com.send.ComStmtPrepare;
import org.mariadb.jdbc.internal.com.send.SendChangeDbPacket;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.LruTraceCache;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.LoggerFactory;
import org.mariadb.jdbc.internal.protocol.AbstractConnectProtocol;
import org.mariadb.jdbc.internal.protocol.AbstractMultiSend;
import org.mariadb.jdbc.internal.protocol.MasterProtocol;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.BulkStatus;
import org.mariadb.jdbc.internal.util.LogQueryTool;
import org.mariadb.jdbc.internal.util.SqlStates;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.dao.ClientPrepareResult;
import org.mariadb.jdbc.internal.util.dao.PrepareResult;
import org.mariadb.jdbc.internal.util.dao.ServerPrepareResult;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionFactory;
import org.mariadb.jdbc.internal.util.exceptions.MariaDbSqlException;
import org.mariadb.jdbc.internal.util.exceptions.MaxAllowedPacketException;
import org.mariadb.jdbc.internal.util.pool.GlobalStateInfo;
import org.mariadb.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;

public class AbstractQueryProtocol
extends AbstractConnectProtocol
implements Protocol {
    private static final Logger logger = LoggerFactory.getLogger(AbstractQueryProtocol.class);
    private static final Set<Integer> LOCK_DEADLOCK_ERROR_CODES = new HashSet<Integer>(Arrays.asList(1205, 1213, 1614));
    private ThreadPoolExecutor readScheduler = null;
    private int transactionIsolationLevel = 0;
    private InputStream localInfileInputStream;
    private long maxRows;
    private volatile int statementIdToRelease = -1;
    private FutureTask activeFutureTask = null;
    private boolean interrupted;

    AbstractQueryProtocol(UrlParser urlParser, GlobalStateInfo globalInfo, ReentrantLock lock, LruTraceCache traceCache) {
        super(urlParser, globalInfo, lock, traceCache);
    }

    @Override
    public void reset() throws SQLException {
        this.cmdPrologue();
        try {
            this.writer.startPacket(0);
            this.writer.write(31);
            this.writer.flush();
            this.getResult(new Results());
            if (this.options.cachePrepStmts && this.options.useServerPrepStmts) {
                this.serverPrepareStatementCache.clear();
            }
        }
        catch (SQLException sqlException) {
            throw this.exceptionWithQuery("COM_RESET_CONNECTION failed.", sqlException, this.explicitClosed);
        }
        catch (IOException e) {
            throw this.exceptionWithQuery("COM_RESET_CONNECTION failed.", this.handleIoException(e), this.explicitClosed);
        }
    }

    private MariaDbSqlException exceptionWithQuery(ParameterHolder[] parameters, PrepareResult serverPrepareResult, SQLException sqlException, boolean explicitClosed) {
        return this.exceptionWithQuery(LogQueryTool.queryWithParams(serverPrepareResult, parameters, this.options), sqlException, explicitClosed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MariaDbSqlException exceptionWithQuery(String sql, SQLException sqlException, boolean explicitClosed) {
        MariaDbSqlException ex = explicitClosed ? new MariaDbSqlException("Connection has explicitly been closed/aborted.", sql, sqlException) : (sqlException.getCause() instanceof SocketTimeoutException ? new MariaDbSqlException("Connection timed out", sql, "08000", (Throwable)sqlException) : MariaDbSqlException.of(sqlException, sql));
        if (this.options.includeThreadDumpInDeadlockExceptions || sqlException.getErrorCode() == 1064) {
            ex.withThreadName(Thread.currentThread().getName());
        }
        if (this.options.includeInnodbStatusInDeadlockExceptions && sqlException.getSQLState() != null && LOCK_DEADLOCK_ERROR_CODES.contains(sqlException.getErrorCode())) {
            try {
                this.lock.lock();
                this.cmdPrologue();
                Results results = new Results();
                this.executeQuery(this.isMasterConnection(), results, "SHOW ENGINE INNODB STATUS");
                results.commandEnd();
                SelectResultSet rs = results.getResultSet();
                if (rs.next()) {
                    MariaDbSqlException mariaDbSqlException = ex.withDeadLockInfo(rs.getString(3));
                    return mariaDbSqlException;
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.lock.unlock();
            }
        }
        return ex;
    }

    @Override
    public void executeQuery(String sql) throws SQLException {
        this.executeQuery(this.isMasterConnection(), new Results(), sql);
    }

    @Override
    public void executeQuery(boolean mustExecuteOnMaster, Results results, String sql) throws SQLException {
        this.cmdPrologue();
        try {
            this.writer.startPacket(0);
            this.writer.write(3);
            this.writer.write(sql);
            this.writer.flush();
            this.getResult(results);
        }
        catch (SQLException sqlException) {
            if ("70100".equals(sqlException.getSQLState()) && 1927 == sqlException.getErrorCode()) {
                throw this.handleIoException(sqlException);
            }
            throw this.exceptionWithQuery(sql, sqlException, this.explicitClosed);
        }
        catch (IOException e) {
            throw this.exceptionWithQuery(sql, this.handleIoException(e), this.explicitClosed);
        }
    }

    @Override
    public void executeQuery(boolean mustExecuteOnMaster, Results results, String sql, Charset charset) throws SQLException {
        this.cmdPrologue();
        try {
            this.writer.startPacket(0);
            this.writer.write(3);
            this.writer.write(sql.getBytes(charset));
            this.writer.flush();
            this.getResult(results);
        }
        catch (SQLException sqlException) {
            throw this.exceptionWithQuery(sql, sqlException, this.explicitClosed);
        }
        catch (IOException e) {
            throw this.exceptionWithQuery(sql, this.handleIoException(e), this.explicitClosed);
        }
    }

    @Override
    public void executeQuery(boolean mustExecuteOnMaster, Results results, ClientPrepareResult clientPrepareResult, ParameterHolder[] parameters) throws SQLException {
        this.cmdPrologue();
        try {
            if (clientPrepareResult.getParamCount() == 0 && !clientPrepareResult.isQueryMultiValuesRewritable()) {
                if (clientPrepareResult.getQueryParts().size() == 1) {
                    ComQuery.sendDirect(this.writer, clientPrepareResult.getQueryParts().get(0));
                } else {
                    ComQuery.sendMultiDirect(this.writer, clientPrepareResult.getQueryParts());
                }
            } else {
                this.writer.startPacket(0);
                ComQuery.sendSubCmd(this.writer, clientPrepareResult, parameters, -1);
                this.writer.flush();
            }
            this.getResult(results);
        }
        catch (SQLException queryException) {
            throw this.exceptionWithQuery(parameters, clientPrepareResult, queryException, false);
        }
        catch (IOException e) {
            throw this.exceptionWithQuery(parameters, clientPrepareResult, this.handleIoException(e), false);
        }
    }

    @Override
    public void executeQuery(boolean mustExecuteOnMaster, Results results, ClientPrepareResult clientPrepareResult, ParameterHolder[] parameters, int queryTimeout) throws SQLException {
        this.cmdPrologue();
        try {
            if (clientPrepareResult.getParamCount() == 0 && !clientPrepareResult.isQueryMultiValuesRewritable()) {
                if (clientPrepareResult.getQueryParts().size() == 1) {
                    ComQuery.sendDirect(this.writer, clientPrepareResult.getQueryParts().get(0), queryTimeout);
                } else {
                    ComQuery.sendMultiDirect(this.writer, clientPrepareResult.getQueryParts(), queryTimeout);
                }
            } else {
                this.writer.startPacket(0);
                ComQuery.sendSubCmd(this.writer, clientPrepareResult, parameters, queryTimeout);
                this.writer.flush();
            }
            this.getResult(results);
        }
        catch (SQLException queryException) {
            throw this.exceptionWithQuery(parameters, clientPrepareResult, queryException, false);
        }
        catch (IOException e) {
            throw this.exceptionWithQuery(parameters, clientPrepareResult, this.handleIoException(e), false);
        }
    }

    @Override
    public boolean executeBatchClient(boolean mustExecuteOnMaster, Results results, ClientPrepareResult prepareResult, List<ParameterHolder[]> parametersList, boolean hasLongData) throws SQLException {
        if (this.options.rewriteBatchedStatements) {
            if (prepareResult.isQueryMultiValuesRewritable() && results.getAutoGeneratedKeys() == 2) {
                this.executeBatchRewrite(results, prepareResult, parametersList, true);
                return true;
            }
            if (prepareResult.isQueryMultipleRewritable()) {
                if (this.options.useBulkStmts && !hasLongData && prepareResult.isQueryMultipleRewritable() && results.getAutoGeneratedKeys() == 2 && this.versionGreaterOrEqual(10, 2, 7) && this.executeBulkBatch(results, prepareResult.getSql(), null, parametersList)) {
                    return true;
                }
                this.executeBatchRewrite(results, prepareResult, parametersList, false);
                return true;
            }
        }
        if (this.options.useBulkStmts && !hasLongData && results.getAutoGeneratedKeys() == 2 && this.versionGreaterOrEqual(10, 2, 7) && this.executeBulkBatch(results, prepareResult.getSql(), null, parametersList)) {
            return true;
        }
        if (this.options.useBatchMultiSend.booleanValue()) {
            this.executeBatchMulti(results, prepareResult, parametersList);
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean executeBulkBatch(Results results, String sql, ServerPrepareResult serverPrepareResult, List<ParameterHolder[]> parametersList) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK], 6[CATCHBLOCK], 14[DOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initializeBatchReader() {
        if (this.options.useBatchMultiSend.booleanValue()) {
            this.readScheduler = SchedulerServiceProviderHolder.getBulkScheduler();
        }
    }

    private void executeBatchMulti(Results results, final ClientPrepareResult clientPrepareResult, final List<ParameterHolder[]> parametersList) throws SQLException {
        this.cmdPrologue();
        this.initializeBatchReader();
        new AbstractMultiSend(this, this.writer, results, clientPrepareResult, parametersList, this.readScheduler){

            @Override
            public void sendCmd(PacketOutputStream writer, Results results, List<ParameterHolder[]> parametersList2, List<String> queries, int paramCount, BulkStatus status, PrepareResult prepareResult) throws IOException {
                ParameterHolder[] parameters = parametersList2.get(status.sendCmdCounter);
                writer.startPacket(0);
                ComQuery.sendSubCmd(writer, clientPrepareResult, parameters, -1);
                writer.flush();
            }

            @Override
            public SQLException handleResultException(SQLException qex, Results results, List<ParameterHolder[]> parametersList2, List<String> queries, int currentCounter, int sendCmdCounter, int paramCount, PrepareResult prepareResult) {
                int counter = results.getCurrentStatNumber() - 1;
                ParameterHolder[] parameters = parametersList2.get(counter);
                List<byte[]> queryParts = clientPrepareResult.getQueryParts();
                StringBuilder sql = new StringBuilder(new String(queryParts.get(0)));
                for (int i = 0; i < paramCount; ++i) {
                    sql.append(parameters[i].toString()).append(new String(queryParts.get(i + 1)));
                }
                return AbstractQueryProtocol.this.exceptionWithQuery(sql.toString(), qex, AbstractQueryProtocol.this.explicitClosed);
            }

            @Override
            public int getParamCount() {
                return clientPrepareResult.getQueryParts().size() - 1;
            }

            @Override
            public int getTotalExecutionNumber() {
                return parametersList.size();
            }
        }.executeBatch();
    }

    @Override
    public void executeBatchStmt(boolean mustExecuteOnMaster, Results results, List<String> queries) throws SQLException {
        this.cmdPrologue();
        if (this.options.rewriteBatchedStatements) {
            boolean canAggregateSemiColumn = true;
            for (String query : queries) {
                if (ClientPrepareResult.canAggregateSemiColon(query, this.noBackslashEscapes())) continue;
                canAggregateSemiColumn = false;
                break;
            }
            if (this.isInterrupted()) {
                throw new SQLTimeoutException("Timeout during batch execution");
            }
            if (canAggregateSemiColumn) {
                this.executeBatchAggregateSemiColon(results, queries);
            } else {
                this.executeBatch(results, queries);
            }
        } else {
            this.executeBatch(results, queries);
        }
    }

    private void executeBatch(Results results, final List<String> queries) throws SQLException {
        if (!this.options.useBatchMultiSend.booleanValue()) {
            String sql = null;
            MariaDbSqlException exception = null;
            for (int i = 0; i < queries.size() && !this.isInterrupted(); ++i) {
                try {
                    sql = queries.get(i);
                    this.writer.startPacket(0);
                    this.writer.write(3);
                    this.writer.write(sql);
                    this.writer.flush();
                    this.getResult(results);
                    continue;
                }
                catch (SQLException sqlException) {
                    if (exception != null) continue;
                    exception = this.exceptionWithQuery(sql, sqlException, this.explicitClosed);
                    if (this.options.continueBatchOnError) continue;
                    throw exception;
                }
                catch (IOException e) {
                    if (exception != null) continue;
                    exception = this.exceptionWithQuery(sql, this.handleIoException(e), this.explicitClosed);
                    if (this.options.continueBatchOnError) continue;
                    throw exception;
                }
            }
            this.stopIfInterrupted();
            if (exception != null) {
                throw exception;
            }
            return;
        }
        this.initializeBatchReader();
        new AbstractMultiSend(this, this.writer, results, queries, this.readScheduler){

            @Override
            public void sendCmd(PacketOutputStream pos, Results results, List<ParameterHolder[]> parametersList, List<String> queries2, int paramCount, BulkStatus status, PrepareResult prepareResult) throws IOException {
                String sql = queries2.get(status.sendCmdCounter);
                pos.startPacket(0);
                pos.write(3);
                pos.write(sql);
                pos.flush();
            }

            @Override
            public SQLException handleResultException(SQLException qex, Results results, List<ParameterHolder[]> parametersList, List<String> queries2, int currentCounter, int sendCmdCounter, int paramCount, PrepareResult prepareResult) {
                String sql = queries2.get(currentCounter + sendCmdCounter);
                return AbstractQueryProtocol.this.exceptionWithQuery(sql, qex, AbstractQueryProtocol.this.explicitClosed);
            }

            @Override
            public int getParamCount() {
                return -1;
            }

            @Override
            public int getTotalExecutionNumber() {
                return queries.size();
            }
        }.executeBatch();
    }

    @Override
    public ServerPrepareResult prepare(String sql, boolean executeOnMaster) throws SQLException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            ServerPrepareResult pr;
            if (this.options.cachePrepStmts && this.options.useServerPrepStmts && (pr = (ServerPrepareResult)this.serverPrepareStatementCache.get(this.database + "-" + sql)) != null && pr.incrementShareCounter()) {
                ServerPrepareResult serverPrepareResult = pr;
                return serverPrepareResult;
            }
            this.writer.startPacket(0);
            this.writer.write(22);
            this.writer.write(sql);
            this.writer.flush();
            ComStmtPrepare comStmtPrepare = new ComStmtPrepare(this, sql);
            ServerPrepareResult serverPrepareResult = comStmtPrepare.read(this.reader, this.eofDeprecated);
            return serverPrepareResult;
        }
        catch (IOException e) {
            throw this.exceptionWithQuery(sql, this.handleIoException(e), this.explicitClosed);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void executeBatchAggregateSemiColon(Results results, List<String> queries) throws SQLException {
        String firstSql = null;
        int currentIndex = 0;
        int totalQueries = queries.size();
        MariaDbSqlException exception = null;
        do {
            try {
                firstSql = queries.get(currentIndex++);
                if (totalQueries == 1) {
                    this.writer.startPacket(0);
                    this.writer.write(3);
                    this.writer.write(firstSql);
                    this.writer.flush();
                } else {
                    currentIndex = ComQuery.sendBatchAggregateSemiColon(this.writer, firstSql, queries, currentIndex);
                }
                this.getResult(results);
            }
            catch (SQLException sqlException) {
                if (exception == null) {
                    exception = this.exceptionWithQuery(firstSql, sqlException, this.explicitClosed);
                    if (!this.options.continueBatchOnError) {
                        throw exception;
                    }
                }
            }
            catch (IOException e) {
                throw this.exceptionWithQuery(firstSql, this.handleIoException(e), this.explicitClosed);
            }
            this.stopIfInterrupted();
        } while (currentIndex < totalQueries);
        if (exception != null) {
            throw exception;
        }
    }

    private void executeBatchRewrite(Results results, ClientPrepareResult prepareResult, List<ParameterHolder[]> parameterList, boolean rewriteValues) throws SQLException {
        this.cmdPrologue();
        int currentIndex = 0;
        int totalParameterList = parameterList.size();
        try {
            do {
                currentIndex = ComQuery.sendRewriteCmd(this.writer, prepareResult.getQueryParts(), currentIndex, prepareResult.getParamCount(), parameterList, rewriteValues);
                this.getResult(results);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new SQLException("Interrupted during batch", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), -1);
            } while (currentIndex < totalParameterList);
        }
        catch (SQLException sqlEx) {
            throw MariaDbSqlException.of(sqlEx, prepareResult.getSql());
        }
        catch (IOException e) {
            throw this.exceptionWithQuery(parameterList.get(currentIndex), prepareResult, this.handleIoException(e), this.explicitClosed);
        }
        finally {
            results.setRewritten(rewriteValues);
        }
    }

    @Override
    public boolean executeBatchServer(boolean mustExecuteOnMaster, ServerPrepareResult serverPrepareResult, Results results, String sql, final List<ParameterHolder[]> parametersList, boolean hasLongData) throws SQLException {
        this.cmdPrologue();
        if (this.options.useBulkStmts && !hasLongData && results.getAutoGeneratedKeys() == 2 && this.versionGreaterOrEqual(10, 2, 7) && this.executeBulkBatch(results, sql, serverPrepareResult, parametersList)) {
            return true;
        }
        if (!this.options.useBatchMultiSend.booleanValue()) {
            return false;
        }
        this.initializeBatchReader();
        new AbstractMultiSend(this, this.writer, results, serverPrepareResult, parametersList, true, sql, this.readScheduler){

            @Override
            public void sendCmd(PacketOutputStream writer, Results results, List<ParameterHolder[]> parametersList2, List<String> queries, int paramCount, BulkStatus status, PrepareResult prepareResult) throws SQLException, IOException {
                ParameterHolder[] parameters = parametersList2.get(status.sendCmdCounter);
                if (parameters.length < paramCount) {
                    throw new SQLException("Parameter at position " + (paramCount - 1) + " is not set", "07004");
                }
                for (int i = 0; i < paramCount; ++i) {
                    if (!parameters[i].isLongData()) continue;
                    writer.startPacket(0);
                    writer.write(24);
                    writer.writeInt(this.statementId);
                    writer.writeShort((short)i);
                    parameters[i].writeBinary(writer);
                    writer.flush();
                }
                writer.startPacket(0);
                ComStmtExecute.writeCmd(this.statementId, parameters, paramCount, this.parameterTypeHeader, writer, (byte)0);
                writer.flush();
            }

            @Override
            public SQLException handleResultException(SQLException qex, Results results, List<ParameterHolder[]> parametersList2, List<String> queries, int currentCounter, int sendCmdCounter, int paramCount, PrepareResult prepareResult) {
                return MariaDbSqlException.of(qex, prepareResult.getSql());
            }

            @Override
            public int getParamCount() {
                return this.getPrepareResult() == null ? ((ParameterHolder[])parametersList.get(0)).length : ((ServerPrepareResult)this.getPrepareResult()).getParameters().length;
            }

            @Override
            public int getTotalExecutionNumber() {
                return parametersList.size();
            }
        }.executeBatch();
        return true;
    }

    @Override
    public void executePreparedQuery(boolean mustExecuteOnMaster, ServerPrepareResult serverPrepareResult, Results results, ParameterHolder[] parameters) throws SQLException {
        this.cmdPrologue();
        try {
            int parameterCount = serverPrepareResult.getParameters().length;
            for (int i = 0; i < parameterCount; ++i) {
                if (!parameters[i].isLongData()) continue;
                this.writer.startPacket(0);
                this.writer.write(24);
                this.writer.writeInt(serverPrepareResult.getStatementId());
                this.writer.writeShort((short)i);
                parameters[i].writeBinary(this.writer);
                this.writer.flush();
            }
            ComStmtExecute.send(this.writer, serverPrepareResult.getStatementId(), parameters, parameterCount, serverPrepareResult.getParameterTypeHeader(), (byte)0);
            this.getResult(results);
        }
        catch (SQLException qex) {
            throw this.exceptionWithQuery(parameters, serverPrepareResult, qex, false);
        }
        catch (IOException e) {
            throw this.exceptionWithQuery(parameters, serverPrepareResult, this.handleIoException(e), false);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            if (this.inTransaction()) {
                this.executeQuery("ROLLBACK");
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean forceReleasePrepareStatement(int statementId) throws SQLException {
        if (this.lock.tryLock()) {
            try {
                this.checkClose();
                try {
                    this.writer.startPacket(0);
                    this.writer.write(25);
                    this.writer.writeInt(statementId);
                    this.writer.flush();
                    boolean bl2 = true;
                    return bl2;
                }
                catch (IOException e) {
                    this.connected = false;
                    throw new SQLNonTransientConnectionException("Could not deallocate query: " + e.getMessage(), "08000", e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        this.statementIdToRelease = statementId;
        return false;
    }

    @Override
    public void forceReleaseWaitingPrepareStatement() throws SQLException {
        if (this.statementIdToRelease != -1 && this.forceReleasePrepareStatement(this.statementIdToRelease)) {
            this.statementIdToRelease = -1;
        }
    }

    @Override
    public boolean ping() throws SQLException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            this.writer.startPacket(0);
            this.writer.write(14);
            this.writer.flush();
            Buffer buffer = this.reader.getPacket(true);
            boolean bl2 = buffer.getByteAt(0) == 0;
            return bl2;
        }
        catch (IOException e) {
            this.connected = false;
            throw new SQLNonTransientConnectionException("Could not ping: " + e.getMessage(), "08000", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        int initialTimeout = -1;
        try {
            initialTimeout = this.socketTimeout;
            if (initialTimeout == 0) {
                this.changeSocketSoTimeout(timeout);
            }
            if (this.isMasterConnection() && !this.galeraAllowedStates.isEmpty()) {
                Results results = new Results();
                this.executeQuery(true, results, "show status like 'wsrep_local_state'");
                results.commandEnd();
                SelectResultSet rs = results.getResultSet();
                boolean bl2 = rs != null && rs.next() && this.galeraAllowedStates.contains(rs.getString(2));
                return bl2;
            }
            boolean results = this.ping();
            return results;
        }
        catch (SocketException socketException) {
            logger.trace("Connection is not valid", socketException);
            this.connected = false;
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (initialTimeout != -1) {
                    this.changeSocketSoTimeout(initialTimeout);
                }
            }
            catch (SocketException socketException) {
                logger.warn("Could not set socket timeout back to " + initialTimeout, socketException);
                this.connected = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() throws SQLException {
        if ((this.serverCapabilities & 0x800000L) != 0L) {
            if (this.database != null && this.database.isEmpty()) {
                return null;
            }
            return this.database;
        }
        this.cmdPrologue();
        this.lock.lock();
        try {
            Results results = new Results();
            this.executeQuery(this.isMasterConnection(), results, "select database()");
            results.commandEnd();
            SelectResultSet rs = results.getResultSet();
            if (rs.next()) {
                String string = this.database = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setCatalog(String database) throws SQLException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            SendChangeDbPacket.send(this.writer, database);
            Buffer buffer = this.reader.getPacket(true);
            if (buffer.getByteAt(0) == -1) {
                ErrorPacket ep = new ErrorPacket(buffer);
                throw new SQLException("Could not select database '" + database + "' : " + ep.getMessage(), ep.getSqlState(), ep.getErrorCode());
            }
            this.database = database;
        }
        catch (IOException e) {
            throw this.exceptionWithQuery("COM_INIT_DB", this.handleIoException(e), false);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void resetDatabase() throws SQLException {
        if (!this.database.equals(this.urlParser.getDatabase())) {
            this.setCatalog(this.urlParser.getDatabase());
        }
    }

    @Override
    public void cancelCurrentQuery() throws SQLException {
        try (MasterProtocol copiedProtocol = new MasterProtocol(this.urlParser, new GlobalStateInfo(), new ReentrantLock(), this.traceCache);){
            copiedProtocol.setHostAddress(this.getHostAddress());
            copiedProtocol.connect();
            copiedProtocol.executeQuery("KILL QUERY " + this.serverThreadId);
        }
        this.interrupted = true;
    }

    @Override
    public boolean getAutocommit() {
        return (this.serverStatus & 2) != 0;
    }

    @Override
    public boolean inTransaction() {
        return (this.serverStatus & 1) != 0;
    }

    @Override
    public void closeExplicit() {
        this.explicitClosed = true;
        this.close();
    }

    @Override
    public void releasePrepareStatement(ServerPrepareResult serverPrepareResult) throws SQLException {
        serverPrepareResult.decrementShareCounter();
        if (serverPrepareResult.canBeDeallocate()) {
            this.forceReleasePrepareStatement(serverPrepareResult.getStatementId());
        }
    }

    @Override
    public long getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(long max) throws SQLException {
        if (this.maxRows != max) {
            if (max == 0L) {
                this.executeQuery("set @@SQL_SELECT_LIMIT=DEFAULT");
            } else {
                this.executeQuery("set @@SQL_SELECT_LIMIT=" + max);
            }
            this.maxRows = max;
        }
    }

    @Override
    public void setLocalInfileInputStream(InputStream inputStream) {
        this.localInfileInputStream = inputStream;
    }

    @Override
    public int getTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void setTimeout(int timeout) throws SocketException {
        this.lock.lock();
        try {
            this.changeSocketSoTimeout(timeout);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.cmdPrologue();
        this.lock.lock();
        try {
            String query = "SET SESSION TRANSACTION ISOLATION LEVEL";
            switch (level) {
                case 1: {
                    query = query + " READ UNCOMMITTED";
                    break;
                }
                case 2: {
                    query = query + " READ COMMITTED";
                    break;
                }
                case 4: {
                    query = query + " REPEATABLE READ";
                    break;
                }
                case 8: {
                    query = query + " SERIALIZABLE";
                    break;
                }
                default: {
                    throw new SQLException("Unsupported transaction isolation level");
                }
            }
            this.executeQuery(query);
            this.transactionIsolationLevel = level;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    private void checkClose() throws SQLException {
        if (!this.connected) {
            throw new SQLException("Connection is close", "08000", 1220);
        }
    }

    @Override
    public void getResult(Results results) throws SQLException {
        this.readPacket(results);
        while (this.hasMoreResults()) {
            this.readPacket(results);
        }
    }

    private void readPacket(Results results) throws SQLException {
        Buffer buffer;
        try {
            buffer = this.reader.getPacket(true);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
        switch (buffer.getByteAt(0)) {
            case 0: {
                this.readOkPacket(buffer, results);
                break;
            }
            case -1: {
                throw this.readErrorPacket(buffer, results);
            }
            case -5: {
                this.readLocalInfilePacket(buffer, results);
                break;
            }
            default: {
                this.readResultSet(buffer, results);
            }
        }
    }

    private void readOkPacket(Buffer buffer, Results results) {
        buffer.skipByte();
        long updateCount = buffer.getLengthEncodedNumeric();
        long insertId = buffer.getLengthEncodedNumeric();
        this.serverStatus = buffer.readShort();
        boolean bl2 = this.hasWarnings = buffer.readShort() > 0;
        if ((this.serverStatus & 0x4000) != 0) {
            this.handleStateChange(buffer, results);
        }
        results.addStats(updateCount, insertId, this.hasMoreResults());
    }

    private void handleStateChange(Buffer buf, Results results) {
        buf.skipLengthEncodedBytes();
        block10: while (buf.remaining() > 0) {
            Buffer stateInfo = buf.getLengthEncodedBuffer();
            if (stateInfo.remaining() <= 0) continue;
            switch (stateInfo.readByte()) {
                case 0: {
                    Buffer sessionVariableBuf = stateInfo.getLengthEncodedBuffer();
                    String variable = sessionVariableBuf.readStringLengthEncoded(StandardCharsets.UTF_8);
                    String value = sessionVariableBuf.readStringLengthEncoded(StandardCharsets.UTF_8);
                    logger.debug("System variable change :  {} = {}", (Object)variable, (Object)value);
                    switch (variable) {
                        case "auto_increment_increment": {
                            this.autoIncrementIncrement = Integer.parseInt(value);
                            results.setAutoIncrement(this.autoIncrementIncrement);
                            break;
                        }
                    }
                    continue block10;
                }
                case 1: {
                    Buffer sessionSchemaBuf = stateInfo.getLengthEncodedBuffer();
                    this.database = sessionSchemaBuf.readStringLengthEncoded(StandardCharsets.UTF_8);
                    logger.debug("Database change : now is '{}'", (Object)this.database);
                    continue block10;
                }
            }
            stateInfo.skipLengthEncodedBytes();
        }
    }

    @Override
    public int getAutoIncrementIncrement() throws SQLException {
        if (this.autoIncrementIncrement == 0) {
            this.lock.lock();
            try {
                Results results = new Results();
                this.executeQuery(true, results, "select @@auto_increment_increment");
                results.commandEnd();
                SelectResultSet rs = results.getResultSet();
                rs.next();
                this.autoIncrementIncrement = rs.getInt(1);
            }
            catch (SQLException e) {
                if (e.getSQLState().startsWith("08")) {
                    throw e;
                }
                this.autoIncrementIncrement = 1;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.autoIncrementIncrement;
    }

    private SQLException readErrorPacket(Buffer buffer, Results results) {
        String message;
        String sqlState;
        this.removeHasMoreResults();
        this.hasWarnings = false;
        buffer.skipByte();
        short errorNumber = buffer.readShort();
        if (buffer.readByte() == 35) {
            sqlState = new String(buffer.readRawBytes(5));
            message = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        } else {
            --buffer.position;
            message = new String(buffer.buf, buffer.position, buffer.limit - buffer.position, StandardCharsets.UTF_8);
            sqlState = "HY000";
        }
        results.addStatsError(false);
        this.serverStatus = (short)(this.serverStatus | 1);
        this.removeActiveStreamingResult();
        return new SQLException(message, sqlState, errorNumber);
    }

    private void readLocalInfilePacket(Buffer buffer, Results results) throws SQLException {
        int seq = 2;
        buffer.getLengthEncodedNumeric();
        String fileName = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        try {
            InputStream is;
            this.writer.startPacket(seq);
            if (this.localInfileInputStream == null) {
                if (!this.getUrlParser().getOptions().allowLocalInfile) {
                    this.writer.writeEmptyPacket();
                    this.reader.getPacket(true);
                    throw new SQLException("Usage of LOCAL INFILE is disabled. To use it enable it via the connection property allowLocalInfile=true", SqlStates.FEATURE_NOT_SUPPORTED.getSqlState(), -1);
                }
                ServiceLoader<LocalInfileInterceptor> loader = ServiceLoader.load(LocalInfileInterceptor.class);
                for (LocalInfileInterceptor interceptor : loader) {
                    if (interceptor.validate(fileName)) continue;
                    this.writer.writeEmptyPacket();
                    this.reader.getPacket(true);
                    throw new SQLException("LOAD DATA LOCAL INFILE request to send local file named \"" + fileName + "\" not validated by interceptor \"" + interceptor.getClass().getName() + "\"");
                }
                if (results.getSql() == null) {
                    this.writer.writeEmptyPacket();
                    this.reader.getPacket(true);
                    throw new SQLException("LOAD DATA LOCAL INFILE not permit in batch. file '" + fileName + "'", SqlStates.INVALID_AUTHORIZATION.getSqlState(), -1);
                }
                if (!Utils.validateFileName(results.getSql(), results.getParameters(), fileName)) {
                    this.writer.writeEmptyPacket();
                    this.reader.getPacket(true);
                    throw new SQLException("LOAD DATA LOCAL INFILE asked for file '" + fileName + "' that doesn't correspond to initial query " + results.getSql() + ". Possible malicious proxy changing server answer ! Command interrupted", SqlStates.INVALID_AUTHORIZATION.getSqlState(), -1);
                }
                try {
                    URL url = new URL(fileName);
                    is = url.openStream();
                }
                catch (IOException ioe) {
                    try {
                        is = new FileInputStream(fileName);
                    }
                    catch (FileNotFoundException f) {
                        this.writer.writeEmptyPacket();
                        this.reader.getPacket(true);
                        throw new SQLException("Could not send file : " + f.getMessage(), "22000", -1, f);
                    }
                }
            } else {
                is = this.localInfileInputStream;
                this.localInfileInputStream = null;
            }
            try {
                int len;
                byte[] buf = new byte[8192];
                while ((len = is.read(buf)) > 0) {
                    this.writer.startPacket(seq++);
                    this.writer.write(buf, 0, len);
                    this.writer.flush();
                }
                this.writer.writeEmptyPacket();
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                is.close();
            }
            this.getResult(results);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    private void readResultSet(Buffer buffer, Results results) throws SQLException {
        long fieldCount = buffer.getLengthEncodedNumeric();
        try {
            SelectResultSet selectResultSet;
            ColumnDefinition[] ci = new ColumnDefinition[(int)fieldCount];
            int i = 0;
            while ((long)i < fieldCount) {
                ci[i] = new ColumnDefinition(this.reader.getPacket(false));
                ++i;
            }
            boolean callableResult = false;
            if (!this.eofDeprecated) {
                Buffer bufferEof = this.reader.getPacket(true);
                if (bufferEof.readByte() != -2) {
                    throw new IOException("Packets out of order when reading field packets, expected was EOF stream." + (this.options.enablePacketDebug ? this.getTraces() : "Packet contents (hex) = " + Utils.hexdump(this.options.maxQuerySizeToLog, 0, bufferEof.limit, (byte[][])new byte[][]{bufferEof.buf})));
                }
                bufferEof.skipBytes(2);
                boolean bl2 = callableResult = (bufferEof.readShort() & 0x1000) != 0;
            }
            if (results.getResultSetConcurrency() == 1007) {
                selectResultSet = new SelectResultSet(ci, results, this, this.reader, callableResult, this.eofDeprecated);
            } else {
                results.removeFetchSize();
                selectResultSet = new UpdatableResultSet(ci, results, this, this.reader, callableResult, this.eofDeprecated);
            }
            results.addResultSet(selectResultSet, this.hasMoreResults() || results.getFetchSize() > 0);
        }
        catch (IOException e) {
            throw this.handleIoException(e);
        }
    }

    @Override
    public void prologProxy(ServerPrepareResult serverPrepareResult, long maxRows, boolean hasProxy, MariaDbConnection connection, MariaDbStatement statement) throws SQLException {
        this.prolog(maxRows, hasProxy, connection, statement);
    }

    @Override
    public void prolog(long maxRows, boolean hasProxy, MariaDbConnection connection, MariaDbStatement statement) throws SQLException {
        if (this.explicitClosed) {
            throw new SQLNonTransientConnectionException("execute() is called on closed connection", "08000");
        }
        if (!hasProxy && this.shouldReconnectWithoutProxy()) {
            try {
                this.connectWithoutProxy();
            }
            catch (SQLException qe) {
                throw ExceptionFactory.of((int)this.serverThreadId, this.options).create(qe);
            }
        }
        try {
            this.setMaxRows(maxRows);
        }
        catch (SQLException qe) {
            throw ExceptionFactory.of((int)this.serverThreadId, this.options).create(qe);
        }
        connection.reenableWarnings();
    }

    @Override
    public ServerPrepareResult addPrepareInCache(String key, ServerPrepareResult serverPrepareResult) {
        return this.serverPrepareStatementCache.put(key, serverPrepareResult);
    }

    private void cmdPrologue() throws SQLException {
        if (this.activeStreamingResult != null) {
            this.activeStreamingResult.loadFully(false, this);
            this.activeStreamingResult = null;
        }
        if (this.activeFutureTask != null) {
            try {
                this.activeFutureTask.get();
            }
            catch (ExecutionException executionException) {
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new SQLException("Interrupted reading remaining batch response ", SqlStates.INTERRUPTED_EXCEPTION.getSqlState(), -1, interruptedException);
            }
            finally {
                this.forceReleaseWaitingPrepareStatement();
            }
            this.activeFutureTask = null;
        }
        if (!this.connected) {
            throw this.exceptionFactory.create("Connection is closed", "08000", 1220);
        }
        this.interrupted = false;
    }

    @Override
    public void resetStateAfterFailover(long maxRows, int transactionIsolationLevel, String database, boolean autocommit) throws SQLException {
        this.setMaxRows(maxRows);
        if (transactionIsolationLevel != 0) {
            this.setTransactionIsolation(transactionIsolationLevel);
        }
        if (database != null && !"".equals(database) && !this.getDatabase().equals(database)) {
            this.setCatalog(database);
        }
        if (this.getAutocommit() != autocommit) {
            this.executeQuery("set autocommit=" + (autocommit ? "1" : "0"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SQLException handleIoException(Exception initialException) {
        boolean maxSizeError;
        boolean mustReconnect = this.options.autoReconnect;
        if (initialException instanceof MaxAllowedPacketException) {
            maxSizeError = true;
            if (!((MaxAllowedPacketException)initialException).isMustReconnect()) return new SQLNonTransientConnectionException(initialException.getMessage() + this.getTraces(), SqlStates.UNDEFINED_SQLSTATE.getSqlState(), initialException);
            mustReconnect = true;
        } else {
            maxSizeError = this.writer.exceedMaxLength();
            if (maxSizeError) {
                mustReconnect = true;
            }
        }
        if (mustReconnect && !this.explicitClosed) {
            String traces = this.getTraces();
            this.connect();
            try {
                this.resetStateAfterFailover(this.getMaxRows(), this.getTransactionIsolationLevel(), this.getDatabase(), this.getAutocommit());
                if (!maxSizeError) return new SQLTransientConnectionException(initialException.getMessage() + traces, "HY000", initialException);
                return new SQLTransientConnectionException("Could not send query: query size is >= to max_allowed_packet (" + this.writer.getMaxAllowedPacket() + ")" + traces, "HY000", initialException);
            }
            catch (SQLException queryException) {
                try {
                    return new SQLTransientConnectionException("reconnection succeed, but resetting previous state failed" + traces, "HY000", initialException);
                }
                catch (SQLException queryException2) {
                    this.connected = false;
                    return new SQLNonTransientConnectionException(initialException.getMessage() + "\nError during reconnection" + traces, "08000", queryException2);
                }
            }
        }
        this.connected = false;
        return new SQLNonTransientConnectionException(initialException.getMessage() + this.getTraces(), "08000", initialException);
    }

    @Override
    public void setActiveFutureTask(FutureTask activeFutureTask) {
        this.activeFutureTask = activeFutureTask;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public void stopIfInterrupted() throws SQLTimeoutException {
        if (this.isInterrupted()) {
            throw new SQLTimeoutException("Timeout during batch execution");
        }
    }
}

