/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.block;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.trait.BlockTrait;
import org.spongepowered.api.data.ImmutableDataBuilder;
import org.spongepowered.api.data.ImmutableDataHolder;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.property.DirectionRelativePropertyHolder;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.util.Cycleable;
import org.spongepowered.api.util.ResettableBuilder;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public interface BlockState
extends ImmutableDataHolder<BlockState>,
DirectionRelativePropertyHolder,
CatalogType {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public static MatcherBuilder matcher(BlockType type) {
        return new MatcherBuilder().type(type);
    }

    public BlockType getType();

    public BlockState withExtendedProperties(Location<World> var1);

    public BlockState cycleValue(Key<? extends BaseValue<? extends Cycleable<?>>> var1);

    public BlockSnapshot snapshotFor(Location<World> var1);

    public <T extends Comparable<T>> Optional<T> getTraitValue(BlockTrait<T> var1);

    public Optional<BlockTrait<?>> getTrait(String var1);

    public Optional<BlockState> withTrait(BlockTrait<?> var1, Object var2);

    public Collection<BlockTrait<?>> getTraits();

    public Collection<?> getTraitValues();

    public Map<BlockTrait<?>, ?> getTraitMap();

    public static final class StateMatcher
    implements Predicate<BlockState> {
        private final BlockType type;
        private final BlockTrait<?>[] traits;
        private final Object[] values;
        @Nullable
        private ImmutableList<BlockState> compatibleStates;

        private StateMatcher(BlockType type, BlockTrait<?>[] traits, Object[] values) {
            this.type = type;
            this.traits = new BlockTrait[traits.length];
            System.arraycopy(traits, 0, this.traits, 0, traits.length);
            this.values = new Object[values.length];
            System.arraycopy(values, 0, this.values, 0, values.length);
        }

        private ImmutableList<BlockState> computeCompatibleStates() {
            return this.type.getAllBlockStates().stream().filter(this::matches).collect(ImmutableList.toImmutableList());
        }

        public boolean matches(BlockState state) {
            if (this.type != state.getType()) {
                return false;
            }
            for (int i = 0; i < this.traits.length; ++i) {
                BlockTrait<?> trait = this.traits[i];
                Object value = this.values[i];
                Optional<?> traitValue = state.getTraitValue(trait);
                if (!traitValue.isPresent()) {
                    return false;
                }
                Object o = traitValue.get();
                if (value.equals(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean test(BlockState blockState) {
            return this.matches(blockState);
        }

        public List<BlockState> getCompatibleStates() {
            if (this.compatibleStates == null) {
                this.compatibleStates = this.computeCompatibleStates();
            }
            return this.compatibleStates;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("type", this.type).add("traits", this.traits).add("values", this.values).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StateMatcher that = (StateMatcher)o;
            return Objects.equal(this.type, that.type) && Objects.equal(this.traits, that.traits) && Objects.equal(this.values, that.values);
        }

        public int hashCode() {
            return Objects.hashCode(this.type, this.traits, this.values);
        }
    }

    public static final class MatcherBuilder
    implements ResettableBuilder<StateMatcher, MatcherBuilder> {
        @Nullable
        private BlockType type;
        private ArrayList<BlockTrait<?>> traits = new ArrayList();
        private ArrayList<Object> values = new ArrayList();

        private MatcherBuilder() {
        }

        public MatcherBuilder type(BlockType type) {
            this.type = Preconditions.checkNotNull(type, "BlockType cannot be null!");
            return this;
        }

        public <T extends Comparable<T>> MatcherBuilder trait(BlockTrait<T> trait, T value) throws IllegalArgumentException {
            Preconditions.checkState(this.type != null, "BlockType cannot be null! Must be set before using any traits!");
            Preconditions.checkArgument(this.type.getTraits().contains(trait), "BlockType does not contain the specified trait: %s", trait);
            Preconditions.checkArgument(trait.getPossibleValues().contains(value), "BlockTrait %s does not contain value %s", trait, value);
            Preconditions.checkArgument(!this.traits.contains(trait), "Already contains the trait %s! Cannot add multiple values!", trait);
            this.traits.add(trait);
            this.values.add(value);
            return this;
        }

        public StateMatcher build() throws IllegalStateException {
            Preconditions.checkState(this.type != null, "BlockType cannot be null!");
            return new StateMatcher(this.type, this.traits.toArray(new BlockTrait[0]), this.values.toArray());
        }

        @Override
        public MatcherBuilder from(StateMatcher value) {
            this.reset();
            this.type(value.type);
            for (int i = 0; i < value.traits.length; ++i) {
                this.trait(value.traits[i], (Comparable)value.values[i]);
            }
            return this;
        }

        @Override
        public MatcherBuilder reset() {
            this.type = null;
            this.traits.clear();
            this.values.clear();
            return this;
        }
    }

    public static interface Builder
    extends ImmutableDataBuilder<BlockState, Builder> {
        public Builder blockType(BlockType var1);
    }
}

