/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.boss;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.boss.BossBar;
import org.spongepowered.api.boss.BossBarColor;
import org.spongepowered.api.boss.BossBarOverlay;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.ResettableBuilder;

public interface ServerBossBar
extends BossBar {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    @Override
    public ServerBossBar setName(Text var1);

    @Override
    public ServerBossBar setPercent(float var1);

    @Override
    public ServerBossBar setColor(BossBarColor var1);

    @Override
    public ServerBossBar setOverlay(BossBarOverlay var1);

    @Override
    public ServerBossBar setDarkenSky(boolean var1);

    @Override
    public ServerBossBar setPlayEndBossMusic(boolean var1);

    @Override
    public ServerBossBar setCreateFog(boolean var1);

    public boolean isVisible();

    public ServerBossBar setVisible(boolean var1);

    public Collection<Player> getPlayers();

    public ServerBossBar addPlayer(Player var1);

    default public ServerBossBar addPlayers(Collection<Player> players) {
        Preconditions.checkNotNull(players, "players");
        ImmutableSet.copyOf(players).forEach(this::addPlayer);
        return this;
    }

    public ServerBossBar removePlayer(Player var1);

    default public ServerBossBar removePlayers(Collection<Player> players) {
        Preconditions.checkNotNull(players, "players");
        ImmutableSet.copyOf(players).forEach(this::removePlayer);
        return this;
    }

    public static interface Builder
    extends ResettableBuilder<ServerBossBar, Builder> {
        public Builder name(Text var1);

        public Builder percent(float var1);

        public Builder color(BossBarColor var1);

        public Builder overlay(BossBarOverlay var1);

        public Builder darkenSky(boolean var1);

        public Builder playEndBossMusic(boolean var1);

        public Builder createFog(boolean var1);

        public Builder visible(boolean var1);

        public ServerBossBar build();
    }
}

