/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandMapping;

public final class ImmutableCommandMapping
implements CommandMapping {
    private final String primary;
    private final Set<String> aliases;
    private final CommandCallable callable;

    public ImmutableCommandMapping(CommandCallable callable, String primary, String ... alias) {
        this(callable, primary, Arrays.asList((Object[])Preconditions.checkNotNull(alias, "alias")));
    }

    public ImmutableCommandMapping(CommandCallable callable, String primary, Collection<String> aliases) {
        Preconditions.checkNotNull(primary, "primary");
        Preconditions.checkNotNull(aliases, "aliases");
        this.primary = primary;
        this.aliases = new HashSet<String>(aliases);
        this.aliases.add(primary);
        this.callable = Preconditions.checkNotNull(callable, "callable");
    }

    @Override
    public String getPrimaryAlias() {
        return this.primary;
    }

    @Override
    public Set<String> getAllAliases() {
        return Collections.unmodifiableSet(this.aliases);
    }

    @Override
    public CommandCallable getCallable() {
        return this.callable;
    }

    public String toString() {
        return "ImmutableCommandMapping{primary='" + this.primary + '\'' + ", aliases=" + this.aliases + ", spec=" + this.callable + '}';
    }
}

