/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args;

import com.google.common.base.Strings;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.text.Text;

public class ArgumentParseException
extends CommandException {
    private static final long serialVersionUID = -8555316116315990226L;
    private final String source;
    private final int position;

    public ArgumentParseException(Text message, String source, int position) {
        super(message, true);
        this.source = source;
        this.position = position;
    }

    public ArgumentParseException(Text message, Throwable cause, String source, int position) {
        super(message, cause, true);
        this.source = source;
        this.position = position;
    }

    @Override
    public Text getText() {
        Text superText = super.getText();
        if (this.source == null || this.source.isEmpty()) {
            return super.getText();
        }
        if (superText == null) {
            return Text.of(this.getAnnotatedPosition());
        }
        return Text.of(superText, Character.valueOf('\n'), this.getAnnotatedPosition());
    }

    private Text getSuperText() {
        return super.getText();
    }

    public String getAnnotatedPosition() {
        String source = this.source;
        int position = this.position;
        if (source.length() > 80) {
            if (position >= 37) {
                int startPos = position - 37;
                int endPos = Math.min(source.length(), position + 37);
                source = endPos < source.length() ? "..." + source.substring(startPos, endPos) + "..." : "..." + source.substring(startPos, endPos);
                position -= 40;
            } else {
                source = source.substring(0, 77) + "...";
            }
        }
        return source + "\n" + Strings.repeat(" ", position) + "^";
    }

    public int getPosition() {
        return this.position;
    }

    public String getSourceString() {
        return this.source;
    }

    public static class WithUsage
    extends ArgumentParseException {
        private static final long serialVersionUID = -786214501012293475L;
        private final Text usage;

        public WithUsage(ArgumentParseException wrapped, Text usage) {
            super(wrapped.getSuperText(), wrapped.getCause(), wrapped.getSourceString(), wrapped.getPosition());
            this.usage = usage;
        }

        public Text getUsage() {
            return this.usage;
        }
    }
}

