/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandMessageFormatting;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.dispatcher.SimpleDispatcher;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;
import org.spongepowered.api.util.StartsWithPredicate;

public class ChildCommandElementExecutor
extends CommandElement
implements CommandExecutor {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final CommandElement NONE = GenericArguments.none();
    @Nullable
    private final CommandExecutor fallbackExecutor;
    @Nullable
    private final CommandElement fallbackElements;
    private final SimpleDispatcher dispatcher = new SimpleDispatcher(SimpleDispatcher.FIRST_DISAMBIGUATOR);
    private final boolean fallbackOnFail;

    @Deprecated
    public ChildCommandElementExecutor(@Nullable CommandExecutor fallbackExecutor) {
        this(fallbackExecutor, null, true);
    }

    public ChildCommandElementExecutor(@Nullable CommandExecutor fallbackExecutor, @Nullable CommandElement fallbackElements, boolean fallbackOnFail) {
        super(Text.of("child" + COUNTER.getAndIncrement()));
        this.fallbackExecutor = fallbackExecutor;
        this.fallbackElements = NONE == fallbackElements ? null : fallbackElements;
        this.fallbackOnFail = fallbackOnFail;
    }

    public Optional<CommandMapping> register(CommandCallable callable, List<String> aliases) {
        return this.dispatcher.register(callable, aliases);
    }

    public Optional<CommandMapping> register(CommandCallable callable, String ... aliases) {
        return this.dispatcher.register(callable, aliases);
    }

    @Override
    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        Optional<String> commandComponent;
        ArrayList<String> completions = Lists.newArrayList();
        if (this.fallbackElements != null) {
            CommandArgs.Snapshot state = args.getSnapshot();
            completions.addAll(this.fallbackElements.complete(src, args, context));
            args.applySnapshot(state);
        }
        if (!(commandComponent = args.nextIfPresent()).isPresent()) {
            return ImmutableList.copyOf(this.filterCommands(src));
        }
        if (args.hasNext()) {
            Optional<CommandMapping> child = this.dispatcher.get(commandComponent.get(), src);
            if (!child.isPresent()) {
                return ImmutableList.of();
            }
            if (child.get().getCallable() instanceof CommandSpec) {
                return ((CommandSpec)child.get().getCallable()).complete(src, args, context);
            }
            args.nextIfPresent();
            String arguments = args.getRaw().substring(args.getRawPosition());
            while (args.hasNext()) {
                args.nextIfPresent();
            }
            try {
                return child.get().getCallable().getSuggestions(src, arguments, context.getOne("targetblock-pos048658").orElse(null));
            }
            catch (CommandException e) {
                Text eText = e.getText();
                if (eText != null) {
                    src.sendMessage(CommandMessageFormatting.error(eText));
                }
                return ImmutableList.of();
            }
        }
        completions.addAll(this.filterCommands(src).stream().filter(new StartsWithPredicate(commandComponent.get())).collect(ImmutableList.toImmutableList()));
        return completions;
    }

    private Set<String> filterCommands(CommandSource src) {
        return Multimaps.filterValues(this.dispatcher.getAll(), input -> input != null && input.getCallable().testPermission(src)).keys().elementSet();
    }

    @Override
    public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
        if (this.fallbackExecutor != null && !args.hasNext()) {
            if (this.fallbackElements != null) {
                this.fallbackElements.parse(source, args, context);
            }
            return;
        }
        CommandArgs.Snapshot state = args.getSnapshot();
        String key = args.next();
        Optional<CommandMapping> optionalCommandMapping = this.dispatcher.get(key, source);
        if (optionalCommandMapping.isPresent()) {
            CommandMapping mapping = optionalCommandMapping.get();
            try {
                if (mapping.getCallable() instanceof CommandSpec) {
                    CommandSpec spec = (CommandSpec)mapping.getCallable();
                    spec.populateContext(source, args, context);
                } else {
                    if (args.hasNext()) {
                        args.next();
                        context.putArg(this.getUntranslatedKey() + "_args", (Object)args.getRaw().substring(args.getRawPosition()));
                    }
                    while (args.hasNext()) {
                        args.next();
                    }
                }
                context.putArg(this.getUntranslatedKey(), (Object)mapping);
            }
            catch (ArgumentParseException ex) {
                args.applySnapshot(state);
                if (this.fallbackOnFail && this.fallbackElements != null) {
                    this.fallbackElements.parse(source, args, context);
                    return;
                }
                args.next();
                if (ex instanceof ArgumentParseException.WithUsage) {
                    throw new ArgumentParseException.WithUsage(ex, Text.of(key, " ", ((ArgumentParseException.WithUsage)ex).getUsage()));
                }
                throw new ArgumentParseException.WithUsage(ex, Text.of(key, " ", mapping.getCallable().getUsage(source)));
            }
        } else if (this.fallbackExecutor != null && this.fallbackElements != null) {
            args.applySnapshot(state);
            this.fallbackElements.parse(source, args, context);
        } else {
            throw args.createError(SpongeApiTranslationHelper.t("Input command %s was not a valid subcommand!", key));
        }
    }

    @Override
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        return null;
    }

    @Override
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        CommandMapping mapping = args.getOne(this.getUntranslatedKey()).orElse(null);
        if (mapping == null) {
            if (this.fallbackExecutor == null) {
                throw new CommandException(SpongeApiTranslationHelper.t("Invalid subcommand state -- no more than one mapping may be provided for child arg %s", this.getKey()));
            }
            return this.fallbackExecutor.execute(src, args);
        }
        if (mapping.getCallable() instanceof CommandSpec) {
            CommandSpec spec = (CommandSpec)mapping.getCallable();
            spec.checkPermission(src);
            return spec.getExecutor().execute(src, args);
        }
        String arguments = args.getOne(this.getUntranslatedKey() + "_args").orElse("");
        return mapping.getCallable().process(src, arguments);
    }

    @Override
    public Text getUsage(CommandSource src) {
        Text usage = this.dispatcher.getUsage(src);
        if (this.fallbackElements == null) {
            return usage;
        }
        Text elementUsage = this.fallbackElements.getUsage(src);
        if (elementUsage.isEmpty()) {
            return usage;
        }
        return Text.of(usage, CommandMessageFormatting.PIPE_TEXT, elementUsage);
    }
}

