/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgUtils;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;

public final class CommandContext {
    public static final String TARGET_BLOCK_ARG = "targetblock-pos048658";
    public static final String TAB_COMPLETION = "tab-complete-50456";
    private final Multimap<String, Object> parsedArgs = ArrayListMultimap.create();
    private final Set<String> definedFlags = Sets.newHashSet();

    public <T> Collection<T> getAll(String key) {
        return Collections.unmodifiableCollection(this.parsedArgs.get(key));
    }

    public <T> Collection<T> getAll(Text key) {
        return this.getAll(ArgUtils.textToArgKey(key));
    }

    public <T> Optional<T> getOne(String key) {
        Collection<Object> values = this.parsedArgs.get(key);
        if (values.size() != 1) {
            return Optional.empty();
        }
        return Optional.ofNullable(values.iterator().next());
    }

    public <T> Optional<T> getOne(Text key) {
        return this.getOne(ArgUtils.textToArgKey(key));
    }

    public <T> T requireOne(String key) throws NoSuchElementException, IllegalArgumentException, ClassCastException {
        Collection<Object> values = this.parsedArgs.get(key);
        if (values.size() == 1) {
            return (T)values.iterator().next();
        }
        if (values.isEmpty()) {
            throw new NoSuchElementException();
        }
        throw new IllegalArgumentException();
    }

    public <T> T requireOne(Text key) throws NoSuchElementException, IllegalArgumentException, ClassCastException {
        return this.requireOne(ArgUtils.textToArgKey(key));
    }

    public void putArg(String key, Object value) {
        Preconditions.checkNotNull(value, "value");
        this.parsedArgs.put(key, value);
    }

    public void putArg(Text key, Object value) {
        this.putArg(ArgUtils.textToArgKey(key), value);
    }

    public void addFlag(String key) {
        this.definedFlags.add(key);
    }

    public void addFlag(Text key) {
        this.addFlag(ArgUtils.textToArgKey(key));
    }

    public void checkPermission(CommandSource commander, String permission) throws CommandException {
        if (!commander.hasPermission(permission)) {
            throw new CommandException(SpongeApiTranslationHelper.t("You do not have permission to use this command!", new Object[0]));
        }
    }

    public boolean hasAny(String key) {
        return this.parsedArgs.containsKey(key);
    }

    public boolean hasAny(Text key) {
        return this.hasAny(ArgUtils.textToArgKey(key));
    }

    public boolean hasFlag(String key) {
        return this.definedFlags.contains(key);
    }

    public boolean hasFlag(Text key) {
        return this.hasFlag(ArgUtils.textToArgKey(key));
    }

    public Snapshot createSnapshot() {
        return new Snapshot(this.parsedArgs, this.definedFlags);
    }

    public void applySnapshot(Snapshot snapshot) {
        this.parsedArgs.clear();
        this.parsedArgs.putAll(snapshot.args);
        this.definedFlags.clear();
        this.definedFlags.addAll(snapshot.flags);
    }

    public final class Snapshot {
        final Multimap<String, Object> args;
        final Set<String> flags;

        Snapshot(Multimap<String, Object> args, Set<String> flags) {
            this.args = ArrayListMultimap.create(args);
            this.flags = Sets.newHashSet(flags);
        }
    }
}

