/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.SpongeApiTranslationHelper;
import org.spongepowered.api.util.StartsWithPredicate;

public final class CommandFlags
extends CommandElement {
    @Nullable
    private final CommandElement childElement;
    private final Map<List<String>, CommandElement> usageFlags;
    private final Map<String, CommandElement> shortFlags;
    private final Map<String, CommandElement> longFlags;
    private final UnknownFlagBehavior unknownShortFlagBehavior;
    private final UnknownFlagBehavior unknownLongFlagBehavior;
    private final boolean anchorFlags;

    protected CommandFlags(@Nullable CommandElement childElement, Map<List<String>, CommandElement> usageFlags, Map<String, CommandElement> shortFlags, Map<String, CommandElement> longFlags, UnknownFlagBehavior unknownShortFlagBehavior, UnknownFlagBehavior unknownLongFlagBehavior, boolean anchorFlags) {
        super(null);
        this.childElement = childElement;
        this.usageFlags = usageFlags;
        this.shortFlags = shortFlags;
        this.longFlags = longFlags;
        this.unknownShortFlagBehavior = unknownShortFlagBehavior;
        this.unknownLongFlagBehavior = unknownLongFlagBehavior;
        this.anchorFlags = anchorFlags;
    }

    @Override
    public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
        CommandArgs.Snapshot state = args.getSnapshot();
        while (args.hasNext()) {
            String arg = args.next();
            if (arg.startsWith("-")) {
                CommandArgs.Snapshot start = args.getSnapshot();
                boolean remove = arg.startsWith("--") ? this.parseLongFlag(source, arg.substring(2), args, context) : this.parseShortFlags(source, arg.substring(1), args, context);
                if (!remove) continue;
                args.removeArgs(start, args.getSnapshot());
                continue;
            }
            if (!this.anchorFlags) continue;
            break;
        }
        args.applySnapshot(state, false);
        if (this.childElement != null) {
            this.childElement.parse(source, args, context);
        }
    }

    private boolean parseLongFlag(CommandSource source, String longFlag, CommandArgs args, CommandContext context) throws ArgumentParseException {
        String[] flagSplit = longFlag.split("=", 2);
        String flag = flagSplit[0].toLowerCase();
        CommandElement element = this.longFlags.get(flag);
        if (element == null) {
            switch (this.unknownLongFlagBehavior) {
                case ERROR: {
                    throw args.createError(SpongeApiTranslationHelper.t("Unknown long flag %s specified", flagSplit[0]));
                }
                case ACCEPT_NONVALUE: {
                    context.addFlag(flag);
                    context.putArg(flag, flagSplit.length == 2 ? flagSplit[1] : Boolean.valueOf(true));
                    return true;
                }
                case ACCEPT_VALUE: {
                    context.addFlag(flag);
                    context.putArg(flag, (Object)(flagSplit.length == 2 ? flagSplit[1] : args.next()));
                    return true;
                }
                case IGNORE: {
                    return false;
                }
            }
            throw new Error("New UnknownFlagBehavior added without corresponding case clauses");
        }
        if (flagSplit.length == 2) {
            args.insertArg(flagSplit[1]);
        }
        element.parse(source, args, context);
        return true;
    }

    private boolean parseShortFlags(CommandSource source, String shortFlags, CommandArgs args, CommandContext context) throws ArgumentParseException {
        block6: for (int i = 0; i < shortFlags.length(); ++i) {
            String shortFlag = shortFlags.substring(i, i + 1);
            CommandElement element = this.shortFlags.get(shortFlag);
            if (element == null) {
                switch (this.unknownShortFlagBehavior) {
                    case IGNORE: {
                        if (i == 0) {
                            return false;
                        }
                        throw args.createError(SpongeApiTranslationHelper.t("Unknown short flag %s specified", shortFlag));
                    }
                    case ERROR: {
                        throw args.createError(SpongeApiTranslationHelper.t("Unknown short flag %s specified", shortFlag));
                    }
                    case ACCEPT_NONVALUE: {
                        context.addFlag(shortFlag);
                        context.putArg(shortFlag, (Object)true);
                        continue block6;
                    }
                    case ACCEPT_VALUE: {
                        context.addFlag(shortFlag);
                        context.putArg(shortFlag, (Object)args.next());
                        continue block6;
                    }
                    default: {
                        throw new Error("New UnknownFlagBehavior added without corresponding case clauses");
                    }
                }
            }
            element.parse(source, args, context);
        }
        return true;
    }

    @Override
    public Text getUsage(CommandSource src) {
        ArrayList<Object> builder = new ArrayList<Object>();
        for (Map.Entry<List<String>, CommandElement> arg : this.usageFlags.entrySet()) {
            builder.add("[");
            Iterator<String> it = arg.getKey().iterator();
            while (it.hasNext()) {
                String flag = it.next();
                builder.add(flag.length() > 1 ? "--" : "-");
                builder.add(flag);
                if (!it.hasNext()) continue;
                builder.add("|");
            }
            Text usage = arg.getValue().getUsage(src);
            if (usage.toPlain().trim().length() > 0) {
                builder.add(" ");
                builder.add(usage);
            }
            builder.add("]");
            builder.add(" ");
        }
        if (this.childElement != null) {
            builder.add(this.childElement.getUsage(src));
        }
        return Text.of(builder.toArray());
    }

    @Override
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        return null;
    }

    @Override
    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        CommandArgs.Snapshot state = args.getSnapshot();
        while (args.hasNext()) {
            String next = args.nextIfPresent().get();
            if (next.startsWith("-")) {
                CommandArgs.Snapshot start = args.getSnapshot();
                List<String> ret = next.startsWith("--") ? this.tabCompleteLongFlag(next.substring(2), src, args, context) : this.tabCompleteShortFlags(next.substring(1), src, args, context);
                if (ret != null) {
                    return ret;
                }
                args.removeArgs(start, args.getSnapshot());
                continue;
            }
            if (!this.anchorFlags) continue;
            break;
        }
        args.applySnapshot(state, false);
        if (!args.hasNext() && !args.getRaw().matches("\\s+$")) {
            return ImmutableList.of();
        }
        return this.childElement != null ? this.childElement.complete(src, args, context) : ImmutableList.of();
    }

    @Nullable
    private List<String> tabCompleteLongFlag(String longFlag, CommandSource src, CommandArgs args, CommandContext context) {
        Collection<String> completion;
        String[] flagSplit = longFlag.split("=", 2);
        boolean isSplitFlag = flagSplit.length == 2;
        CommandElement element = this.longFlags.get(flagSplit[0].toLowerCase());
        if (element == null || !isSplitFlag && !args.hasNext()) {
            return this.longFlags.keySet().stream().filter(new StartsWithPredicate(flagSplit[0])).map(f -> "--" + f).collect(Collectors.toList());
        }
        if (isSplitFlag) {
            args.insertArg(flagSplit[1]);
        }
        CommandArgs.Snapshot state = args.getSnapshot();
        try {
            element.parse(src, args, context);
            if (args.getSnapshot().equals(state)) {
                completion = element.complete(src, args, context);
            } else {
                args.previous();
                String res = args.peek();
                completion = element.complete(src, args, context);
                if (!completion.contains(res)) {
                    completion = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(completion)).add(res)).build();
                }
            }
        }
        catch (ArgumentParseException ex) {
            args.applySnapshot(state);
            completion = element.complete(src, args, context);
        }
        if (completion.isEmpty()) {
            if (isSplitFlag) {
                return ImmutableList.of();
            }
            return null;
        }
        if (isSplitFlag) {
            return completion.stream().map(x -> "--" + flagSplit[0] + "=" + x).collect(Collectors.toList());
        }
        return completion;
    }

    @Nullable
    private List<String> tabCompleteShortFlags(String shortFlags, CommandSource src, CommandArgs args, CommandContext context) {
        for (int i = 0; i < shortFlags.length(); ++i) {
            CommandElement element = this.shortFlags.get(shortFlags.substring(i, i + 1));
            if (element == null) {
                if (i != 0 || this.unknownShortFlagBehavior != UnknownFlagBehavior.ACCEPT_VALUE) continue;
                args.nextIfPresent();
                return null;
            }
            CommandArgs.Snapshot start = args.getSnapshot();
            try {
                element.parse(src, args, context);
                if (args.getSnapshot().equals(start)) {
                    return element.complete(src, args, context);
                }
                args.previous();
                String currentText = args.peek();
                List<String> elements = element.complete(src, args, context);
                if (!elements.contains(currentText)) {
                    return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(args.peek())).addAll(element.complete(src, args, context))).build();
                }
                return elements;
            }
            catch (ArgumentParseException ex) {
                args.applySnapshot(start);
                return element.complete(src, args, context);
            }
        }
        return null;
    }

    private static class FlagElement
    extends CommandElement {
        @Nullable
        private final CommandElement valueElement;

        private FlagElement(Text key, @Nullable CommandElement valueElement) {
            super(key);
            this.valueElement = valueElement;
        }

        @Override
        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            String key = this.getUntranslatedKey();
            if (this.valueElement != null) {
                this.valueElement.parse(source, args, context);
            } else {
                context.putArg(key, (Object)true);
            }
            context.addFlag(key);
        }

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return null;
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return this.valueElement != null ? this.valueElement.complete(src, args, context) : Collections.emptyList();
        }
    }

    public static class Builder {
        private final Map<List<String>, CommandElement> usageFlags = new HashMap<List<String>, CommandElement>();
        private final Map<String, CommandElement> shortFlags = new HashMap<String, CommandElement>();
        private final Map<String, CommandElement> longFlags = new HashMap<String, CommandElement>();
        private UnknownFlagBehavior unknownLongFlagBehavior = UnknownFlagBehavior.ERROR;
        private UnknownFlagBehavior unknownShortFlagBehavior = UnknownFlagBehavior.ERROR;
        private boolean anchorFlags = false;

        Builder() {
        }

        private Builder flag(Function<String, CommandElement> func, String ... specs) {
            ArrayList<String> availableFlags = new ArrayList<String>(specs.length);
            CommandElement el = null;
            for (String spec : specs) {
                if (spec.startsWith("-")) {
                    String flagKey = spec.substring(1);
                    if (el == null) {
                        el = func.apply(flagKey);
                    }
                    availableFlags.add(flagKey);
                    this.longFlags.put(flagKey.toLowerCase(), el);
                    continue;
                }
                for (int i = 0; i < spec.length(); ++i) {
                    String flagKey = spec.substring(i, i + 1);
                    if (el == null) {
                        el = func.apply(flagKey);
                    }
                    availableFlags.add(flagKey);
                    this.shortFlags.put(flagKey, el);
                }
            }
            this.usageFlags.put(availableFlags, el);
            return this;
        }

        public Builder flag(String ... specs) {
            return this.flag((String input) -> new FlagElement(Text.of(input), null), specs);
        }

        public Builder permissionFlag(String flagPermission, String ... specs) {
            return this.flag((String input) -> GenericArguments.requiringPermission(new FlagElement(Text.of(input), null), flagPermission), specs);
        }

        public Builder valueFlag(CommandElement value, String ... specs) {
            return this.flag((String input) -> new FlagElement(Text.of(input), value), specs);
        }

        @Deprecated
        public Builder setAcceptsArbitraryLongFlags(boolean acceptsArbitraryLongFlags) {
            this.setUnknownLongFlagBehavior(acceptsArbitraryLongFlags ? UnknownFlagBehavior.ACCEPT_NONVALUE : UnknownFlagBehavior.ERROR);
            return this;
        }

        public Builder setUnknownLongFlagBehavior(UnknownFlagBehavior behavior) {
            this.unknownLongFlagBehavior = behavior;
            return this;
        }

        public Builder setUnknownShortFlagBehavior(UnknownFlagBehavior behavior) {
            this.unknownShortFlagBehavior = behavior;
            return this;
        }

        public Builder setAnchorFlags(boolean anchorFlags) {
            this.anchorFlags = anchorFlags;
            return this;
        }

        public CommandElement buildWith(CommandElement wrapped) {
            return new CommandFlags(wrapped, this.usageFlags, this.shortFlags, this.longFlags, this.unknownShortFlagBehavior, this.unknownLongFlagBehavior, this.anchorFlags);
        }
    }

    public static enum UnknownFlagBehavior {
        ERROR,
        ACCEPT_NONVALUE,
        ACCEPT_VALUE,
        IGNORE;

    }
}

