/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.command.args;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.PatternMatchingCommandElement;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.selector.Selector;

public abstract class SelectorCommandElement
extends PatternMatchingCommandElement {
    protected SelectorCommandElement(@Nullable Text key) {
        super(key);
    }

    @Override
    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        String arg = args.peek();
        if (arg.startsWith("@")) {
            try {
                return Selector.parse(args.next()).resolve(source);
            }
            catch (IllegalArgumentException ex) {
                throw args.createError(Text.of(ex.getMessage()));
            }
        }
        return super.parseValue(source, args);
    }

    @Override
    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        List<String> choices;
        CommandArgs.Snapshot state = args.getSnapshot();
        Optional<String> nextArg = args.nextIfPresent();
        args.applySnapshot(state);
        List<String> list = choices = nextArg.isPresent() ? Selector.complete(nextArg.get()) : ImmutableList.of();
        if (choices.isEmpty()) {
            choices = super.complete(src, args, context);
        }
        return choices;
    }
}

