/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.manipulator.immutable.common;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.common.AbstractImmutableSingleData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;

public abstract class AbstractImmutableBoundedComparableData<T extends Comparable<T>, I extends ImmutableDataManipulator<I, M>, M extends DataManipulator<M, I>>
extends AbstractImmutableSingleData<T, I, M> {
    protected final Comparator<T> comparator;
    protected final T lowerBound;
    protected final T upperBound;
    protected final T defaultValue;
    private final ImmutableBoundedValue<T> immutableBoundedValue;

    @Deprecated
    protected AbstractImmutableBoundedComparableData(T value, Key<MutableBoundedValue<T>> usedKey, Comparator<T> comparator, T lowerBound, T upperBound, T defaultValue) {
        this(usedKey, value, defaultValue, lowerBound, upperBound, comparator);
    }

    protected AbstractImmutableBoundedComparableData(Key<MutableBoundedValue<T>> usedKey, T value, T lowerBound, T upperBound, Comparator<T> comparator) {
        this(usedKey, value, value, lowerBound, upperBound, comparator);
    }

    protected AbstractImmutableBoundedComparableData(Key<MutableBoundedValue<T>> usedKey, T value, T defaultValue, T lowerBound, T upperBound, Comparator<T> comparator) {
        super(usedKey, value, defaultValue);
        this.comparator = Preconditions.checkNotNull(comparator, "comparator");
        this.lowerBound = (Comparable)Preconditions.checkNotNull(lowerBound, "lowerBound");
        this.upperBound = (Comparable)Preconditions.checkNotNull(upperBound, "upperBound");
        this.checkValue(value, "value");
        this.checkValue(defaultValue, "defaultValue");
        this.defaultValue = defaultValue;
        this.immutableBoundedValue = Sponge.getRegistry().getValueFactory().createBoundedValueBuilder(usedKey).defaultValue(defaultValue).actualValue(value).minimum(lowerBound).maximum(upperBound).comparator(comparator).build().asImmutable();
    }

    private void checkValue(T value, String name) {
        Preconditions.checkArgument(this.comparator.compare(this.lowerBound, value) <= 0, "%s %s is lesser than the lower bound %s", (Object)name, value, this.lowerBound);
        Preconditions.checkArgument(this.comparator.compare(this.upperBound, value) >= 0, "%s %s is greater than the upper bound %s", (Object)name, value, this.upperBound);
    }

    @Override
    protected final ImmutableBoundedValue<T> getValueGetter() {
        return this.immutableBoundedValue;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.lowerBound.hashCode();
        hash = 31 * hash + this.upperBound.hashCode();
        hash = 31 * hash + this.comparator.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AbstractImmutableBoundedComparableData other = (AbstractImmutableBoundedComparableData)obj;
        return other.upperBound.equals(this.upperBound) && other.lowerBound.equals(this.lowerBound) && other.comparator.equals(this.comparator);
    }
}

