/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.merge;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.spongepowered.api.data.value.ValueContainer;

@FunctionalInterface
public interface MergeFunction {
    public static final MergeFunction IGNORE_ALL = new MergeFunction(){

        @Override
        public <C extends ValueContainer<?>> C merge(@Nullable C original, @Nullable C replacement) {
            return replacement == null ? Preconditions.checkNotNull(original, "Original and replacement cannot be null!") : replacement;
        }
    };
    public static final MergeFunction FORCE_NOTHING = new MergeFunction(){

        @Override
        public <C extends ValueContainer<?>> C merge(@Nullable C original, @Nullable C replacement) {
            return original == null ? Preconditions.checkNotNull(replacement, "Replacement and original cannot be null!") : original;
        }
    };

    public <C extends ValueContainer<?>> C merge(@Nullable C var1, @Nullable C var2);

    default public MergeFunction andThen(final MergeFunction that) {
        final MergeFunction self = this;
        return new MergeFunction(){

            @Override
            public <C extends ValueContainer<?>> C merge(C original, C replacement) {
                return that.merge(self.merge(original, replacement), replacement);
            }
        };
    }
}

