/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.persistence;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.InvalidDataException;

public abstract class AbstractDataBuilder<T extends DataSerializable>
implements DataBuilder<T> {
    private final int supportedVersion;
    private final Class<T> requiredClass;

    protected AbstractDataBuilder(Class<T> requiredClass, int supportedVersion) {
        this.requiredClass = Preconditions.checkNotNull(requiredClass, "Required class");
        this.supportedVersion = supportedVersion;
    }

    protected abstract Optional<T> buildContent(DataView var1) throws InvalidDataException;

    @Override
    public final Optional<T> build(DataView container) throws InvalidDataException {
        int contentVersion;
        if (container.contains(Queries.CONTENT_VERSION) && (contentVersion = container.getInt(Queries.CONTENT_VERSION).get().intValue()) < this.supportedVersion) {
            Optional<DataContentUpdater> updater = Sponge.getDataManager().getWrappedContentUpdater(this.requiredClass, contentVersion, this.supportedVersion);
            if (!updater.isPresent()) {
                throw new InvalidDataException("Could not get an updater for " + this.requiredClass.getName() + " data from the version: " + contentVersion + " to " + this.supportedVersion + ". Please notify the SpongePowered developers of this issue!");
            }
            container = updater.get().update(container);
        }
        try {
            return this.buildContent(container);
        }
        catch (Exception e) {
            throw new InvalidDataException("Could not deserialize something correctly, likely due to bad type data.", e);
        }
    }
}

