/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.entity;

import com.flowpowered.math.imaginary.Quaterniond;
import com.flowpowered.math.matrix.Matrix4d;
import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;

public final class Transform<E extends Extent> {
    private final E extent;
    private final Vector3d position;
    private final Vector3d rotation;
    private final Vector3d scale;
    @Nullable
    private Location<E> location = null;
    @Nullable
    private Quaterniond rotationQuaternion = null;

    public Transform(Location<E> location) {
        this(location.getExtent(), location.getPosition());
    }

    public Transform(E extent) {
        this(extent, Vector3d.ZERO);
    }

    public Transform(E extent, Vector3d position) {
        this(extent, position, Vector3d.ZERO);
    }

    public Transform(E extent, Vector3d position, Vector3d rotation) {
        this(extent, position, rotation, Vector3d.ONE);
    }

    public Transform(Location<E> location, Vector3d rotation, Vector3d scale) {
        this(location.getExtent(), location.getPosition(), rotation, scale);
    }

    public Transform(E extent, Vector3d position, Vector3d rotation, Vector3d scale) {
        this.extent = (Extent)Preconditions.checkNotNull(extent, "extent");
        this.position = Preconditions.checkNotNull(position, "position");
        this.rotation = Preconditions.checkNotNull(rotation, "rotation");
        this.scale = Preconditions.checkNotNull(scale, "scale");
    }

    public Location<E> getLocation() {
        if (this.location == null) {
            this.location = new Location<E>(this.extent, this.position);
        }
        return this.location;
    }

    public Transform<E> setLocation(Location<E> location) {
        Preconditions.checkNotNull(location, "location");
        return new Transform<E>(location, this.getRotation(), this.getScale());
    }

    public E getExtent() {
        return this.extent;
    }

    public Transform<E> setExtent(E extent) {
        Preconditions.checkNotNull(extent, "extent");
        return new Transform<E>(extent, this.getPosition(), this.getRotation(), this.getScale());
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public Transform<E> setPosition(Vector3d position) {
        Preconditions.checkNotNull(position, "position");
        return new Transform<E>(this.getExtent(), position, this.getRotation(), this.getScale());
    }

    public Vector3d getRotation() {
        return this.rotation;
    }

    public Transform<E> setRotation(Quaterniond rotation) {
        Preconditions.checkNotNull(rotation, "rotation");
        return this.setRotation(Transform.toAxesAngles(rotation));
    }

    public Transform<E> setRotation(Vector3d rotation) {
        Preconditions.checkNotNull(rotation, "rotation");
        return new Transform<E>(this.getExtent(), this.getPosition(), rotation, this.getScale());
    }

    public Quaterniond getRotationAsQuaternion() {
        if (this.rotationQuaternion == null) {
            this.rotationQuaternion = Transform.fromAxesAngles(this.rotation);
        }
        return this.rotationQuaternion;
    }

    public double getPitch() {
        return this.rotation.getX();
    }

    public double getYaw() {
        return this.rotation.getY();
    }

    public double getRoll() {
        return this.rotation.getZ();
    }

    public Vector3d getScale() {
        return this.scale;
    }

    public Transform<E> setScale(Vector3d scale) {
        Preconditions.checkNotNull(scale, "scale");
        return new Transform<E>(this.getExtent(), this.getPosition(), this.getRotation(), scale);
    }

    public Transform<E> add(Transform<E> other) {
        Preconditions.checkNotNull(other, "other");
        return new Transform<E>(this.getExtent(), this.getPosition().add(other.getPosition()), Transform.toAxesAngles(other.getRotationAsQuaternion().mul(this.getRotationAsQuaternion())), this.getScale().mul(other.getScale()));
    }

    public Transform<E> addTranslation(Vector3d translation) {
        Preconditions.checkNotNull(translation, "translation");
        return new Transform<E>(this.getExtent(), this.getPosition().add(translation), this.getRotation(), this.getScale());
    }

    public Transform<E> addRotation(Vector3d rotation) {
        Preconditions.checkNotNull(rotation, "rotation");
        return this.addRotation(Transform.fromAxesAngles(rotation));
    }

    public Transform<E> addRotation(Quaterniond rotation) {
        Preconditions.checkNotNull(rotation, "rotation");
        return new Transform<E>(this.getExtent(), this.getPosition(), Transform.toAxesAngles(rotation.mul(this.getRotationAsQuaternion())), this.getScale());
    }

    public Transform<E> addScale(Vector3d scale) {
        Preconditions.checkNotNull(scale, "scale");
        return new Transform<E>(this.getExtent(), this.getPosition(), this.getRotation(), this.getScale().mul(scale));
    }

    public Matrix4d toMatrix() {
        return Matrix4d.createScaling(this.getScale().toVector4(1.0f)).rotate(this.getRotationAsQuaternion()).translate(this.getPosition());
    }

    public boolean isValid() {
        return this.extent.isLoaded();
    }

    public int hashCode() {
        int result = this.extent.hashCode();
        result = 31 * result + this.position.hashCode();
        result = 31 * result + this.rotation.hashCode();
        result = 31 * result + this.scale.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Transform)) {
            return false;
        }
        Transform otherTransform = (Transform)other;
        return otherTransform.extent.equals(this.extent) && otherTransform.getPosition().equals(this.getPosition()) && otherTransform.getRotation().equals(this.getRotation()) && otherTransform.getScale().equals(this.getScale());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("location", this.getLocation()).add("rotation", this.rotation).add("scale", this.scale).toString();
    }

    private static Vector3d toAxesAngles(Quaterniond quaternion) {
        Vector3d axesAngles = quaternion.getAxesAnglesDeg();
        return new Vector3d(axesAngles.getX(), -axesAngles.getY(), axesAngles.getZ());
    }

    private static Quaterniond fromAxesAngles(Vector3d angles) {
        return Quaterniond.fromAxesAnglesDeg(angles.getX(), -angles.getY(), angles.getZ());
    }
}

