/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.damage;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.ResettableBuilder;

@Immutable
public interface DamageModifier {
    public static Builder builder() {
        return new Builder();
    }

    public DamageModifierType getType();

    public Cause getCause();

    public Optional<ItemStackSnapshot> getContributingItem();

    public static final class Builder
    implements ResettableBuilder<DamageModifier, Builder> {
        @Nullable
        DamageModifierType type;
        @Nullable
        Cause cause;
        @Nullable
        ItemStackSnapshot snapshot;

        Builder() {
        }

        public Builder type(DamageModifierType damageModifierType) {
            this.type = Preconditions.checkNotNull(damageModifierType);
            return this;
        }

        public Builder item(ItemStack itemStack) {
            this.item(Preconditions.checkNotNull(itemStack, "ItemStack").createSnapshot());
            return this;
        }

        public Builder item(ItemStackSnapshot snapshot) {
            this.snapshot = Preconditions.checkNotNull(snapshot, "ItemStackSnapshot");
            return this;
        }

        public Builder cause(Cause cause) {
            this.cause = Preconditions.checkNotNull(cause);
            return this;
        }

        public DamageModifier build() {
            Preconditions.checkState(this.type != null, "The DamageModifierType must not be null!");
            Preconditions.checkState(this.cause != null, "The cause for the DamageModifier must not be null!");
            return new ImplementedDamageModifier(this);
        }

        @Override
        public Builder from(DamageModifier value) {
            this.type = value.getType();
            this.cause = value.getCause();
            this.snapshot = value.getContributingItem().orElse(null);
            return this;
        }

        @Override
        public Builder reset() {
            this.type = null;
            this.cause = null;
            return this;
        }

        private static class ImplementedDamageModifier
        implements DamageModifier {
            private final DamageModifierType type;
            private final Cause cause;
            @Nullable
            private final ItemStackSnapshot snapshot;

            ImplementedDamageModifier(Builder builder) {
                this.type = Preconditions.checkNotNull(builder.type, "DamageType is null!");
                this.cause = Preconditions.checkNotNull(builder.cause, "Cause is null!");
                this.snapshot = builder.snapshot;
            }

            @Override
            public DamageModifierType getType() {
                return this.type;
            }

            @Override
            public Cause getCause() {
                return this.cause;
            }

            @Override
            public Optional<ItemStackSnapshot> getContributingItem() {
                return Optional.ofNullable(this.snapshot);
            }

            public int hashCode() {
                return Objects.hashCode(this.type, this.cause);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                ImplementedDamageModifier other = (ImplementedDamageModifier)obj;
                return Objects.equal(this.type, other.type) && Objects.equal(this.cause, other.cause) && Objects.equal(this.snapshot, other.snapshot);
            }

            public String toString() {
                return MoreObjects.toStringHelper("DamageModifier").add("type", this.type).add("cause", this.cause).add("contributing", this.snapshot).toString();
            }
        }
    }
}

