/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.damage.source.common;

import com.google.common.base.Preconditions;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.common.AbstractDamageSourceBuilder;

public abstract class AbstractEntityDamageSource
implements EntityDamageSource {
    private final DamageType apiDamageType;
    private final boolean absolute;
    private final boolean bypassesArmor;
    private final boolean scales;
    private final boolean explosive;
    private final boolean magic;
    private final boolean creative;
    private final double exhaustion;
    private final Entity source;

    protected AbstractEntityDamageSource(AbstractEntityDamageSourceBuilder<?, ?> builder) {
        this.apiDamageType = Preconditions.checkNotNull(builder.damageType, "DamageType cannot be null!");
        this.absolute = builder.absolute;
        this.bypassesArmor = builder.bypasses;
        this.scales = builder.scales;
        this.explosive = builder.explosion;
        this.magic = builder.magical;
        this.creative = builder.creative;
        this.exhaustion = builder.exhaustion != null ? builder.exhaustion : (this.absolute || this.bypassesArmor ? 0.0 : 0.1);
        this.source = Preconditions.checkNotNull(builder.source, "Entity source cannot be null!");
    }

    @Override
    public Entity getSource() {
        return this.source;
    }

    @Override
    public DamageType getType() {
        return this.apiDamageType;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public boolean isBypassingArmor() {
        return this.bypassesArmor;
    }

    @Override
    public boolean isScaledByDifficulty() {
        return this.scales;
    }

    @Override
    public boolean isExplosive() {
        return this.explosive;
    }

    @Override
    public boolean isMagic() {
        return this.magic;
    }

    @Override
    public boolean doesAffectCreative() {
        return this.creative;
    }

    @Override
    public double getExhaustion() {
        return this.exhaustion;
    }

    public static abstract class AbstractEntityDamageSourceBuilder<T extends EntityDamageSource, B extends EntityDamageSource.EntityDamageSourceBuilder<T, B>>
    extends AbstractDamageSourceBuilder<T, B>
    implements EntityDamageSource.EntityDamageSourceBuilder<T, B> {
        protected Entity source;

        @Override
        public B entity(Entity entity) {
            this.source = Preconditions.checkNotNull(entity, "Entity source cannot be null!");
            return (B)this;
        }

        @Override
        public B reset() {
            super.reset();
            this.damageType = null;
            return (B)this;
        }
    }
}

