/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.health;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.entity.health.HealthModifierType;
import org.spongepowered.api.util.ResettableBuilder;

public interface HealthModifier {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public HealthModifierType getType();

    public Cause getCause();

    public static final class Builder
    implements ResettableBuilder<HealthModifier, Builder> {
        HealthModifierType type;
        Cause cause;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder type(HealthModifierType healthModifierType) {
            this.type = Preconditions.checkNotNull(healthModifierType);
            return this;
        }

        public Builder cause(Cause cause) {
            this.cause = Preconditions.checkNotNull(cause);
            return this;
        }

        public HealthModifier build() {
            Preconditions.checkState(this.type != null, "The HealthModifierType must not be null!");
            Preconditions.checkState(this.cause != null, "The cause for the HealthModifier must not be null!");
            return new ImplementedHealthModifier(this);
        }

        @Override
        public Builder from(HealthModifier value) {
            this.reset();
            this.type = value.getType();
            this.cause = value.getCause();
            return this;
        }

        @Override
        public Builder reset() {
            this.type = null;
            this.cause = null;
            return this;
        }

        private static class ImplementedHealthModifier
        implements HealthModifier {
            private final HealthModifierType type;
            private final Cause cause;

            ImplementedHealthModifier(Builder builder) {
                this.type = builder.type;
                this.cause = builder.cause;
            }

            @Override
            public HealthModifierType getType() {
                return this.type;
            }

            @Override
            public Cause getCause() {
                return this.cause;
            }

            public int hashCode() {
                return Objects.hashCode(this.type, this.cause);
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                ImplementedHealthModifier other = (ImplementedHealthModifier)obj;
                return Objects.equal(this.type, other.type) && Objects.equal(this.cause, other.cause);
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("type", this.type).add("cause", this.cause).toString();
            }
        }
    }
}

