/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.health.source.common;

import com.google.common.base.Preconditions;
import org.spongepowered.api.event.cause.entity.health.HealingType;
import org.spongepowered.api.event.cause.entity.health.source.HealingSource;

public abstract class AbstractHealingSourceBuilder<T extends HealingSource, B extends HealingSource.HealingSourceBuilder<T, B>>
implements HealingSource.HealingSourceBuilder<T, B> {
    protected boolean scales = false;
    protected boolean magical = false;
    protected HealingType healingType = null;

    @Override
    public B scalesWithDifficulty() {
        this.scales = true;
        return (B)this;
    }

    @Override
    public B magical() {
        this.magical = true;
        return (B)this;
    }

    @Override
    public B type(HealingType healingType) {
        this.healingType = Preconditions.checkNotNull(healingType, "Healing type cannot be null!");
        return (B)this;
    }

    @Override
    public B from(T value) {
        this.reset();
        this.scales = value.isDifficultyScaled();
        this.magical = value.isMagic();
        this.healingType = value.getHealingType();
        return (B)this;
    }

    @Override
    public B reset() {
        this.scales = false;
        this.magical = false;
        this.healingType = null;
        return (B)this;
    }
}

