/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.message;

import com.google.common.base.Preconditions;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.impl.AbstractMessageEvent;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.transform.FixedPartitionedTextFormatter;
import org.spongepowered.api.text.transform.SimpleTextFormatter;
import org.spongepowered.api.text.transform.SimpleTextTemplateApplier;
import org.spongepowered.api.util.annotation.eventgen.ImplementedBy;
import org.spongepowered.api.util.annotation.eventgen.PropertySettings;

@ImplementedBy(value=AbstractMessageEvent.class)
public interface MessageEvent
extends Event {
    public static final String PARAM_MESSAGE_HEADER = "header";
    public static final String PARAM_MESSAGE_BODY = "body";
    public static final String PARAM_MESSAGE_FOOTER = "footer";

    @PropertySettings(requiredParameter=false)
    public Text getOriginalMessage();

    public boolean isMessageCancelled();

    public void setMessageCancelled(boolean var1);

    public MessageFormatter getFormatter();

    @PropertySettings(requiredParameter=false, generateMethods=false)
    default public Text getMessage() {
        return this.getFormatter().format();
    }

    default public MessageFormatter clearMessage() {
        MessageFormatter formatter = this.getFormatter();
        formatter.clear();
        return formatter;
    }

    default public void setMessage(TextRepresentable header, TextRepresentable body, TextRepresentable footer) {
        Preconditions.checkNotNull(header, PARAM_MESSAGE_HEADER);
        Preconditions.checkNotNull(body, PARAM_MESSAGE_BODY);
        Preconditions.checkNotNull(footer, PARAM_MESSAGE_FOOTER);
        MessageFormatter formatter = this.clearMessage();
        formatter.setHeader(header);
        formatter.setBody(body);
        formatter.setFooter(footer);
    }

    default public void setMessage(TextRepresentable header, TextRepresentable body) {
        Preconditions.checkNotNull(header, PARAM_MESSAGE_HEADER);
        Preconditions.checkNotNull(body, PARAM_MESSAGE_BODY);
        MessageFormatter formatter = this.clearMessage();
        formatter.setHeader(header);
        formatter.setBody(body);
    }

    default public void setMessage(TextRepresentable body) {
        Preconditions.checkNotNull(body, PARAM_MESSAGE_BODY);
        MessageFormatter formatter = this.clearMessage();
        formatter.setBody(body);
    }

    public static final class DefaultBodyApplier
    extends SimpleTextTemplateApplier {
        public DefaultBodyApplier(TextRepresentable value) {
            super(TextTemplate.of(TextTemplate.arg(MessageEvent.PARAM_MESSAGE_BODY)));
            Preconditions.checkNotNull(value, "value");
            this.setParameter(MessageEvent.PARAM_MESSAGE_BODY, value);
        }
    }

    public static final class DefaultHeaderApplier
    extends SimpleTextTemplateApplier {
        public DefaultHeaderApplier(TextRepresentable value) {
            super(TextTemplate.of(Character.valueOf('<'), TextTemplate.arg(MessageEvent.PARAM_MESSAGE_HEADER), "> "));
            Preconditions.checkNotNull(value, "value");
            this.setParameter(MessageEvent.PARAM_MESSAGE_HEADER, value);
        }
    }

    public static class MessageFormatter
    extends FixedPartitionedTextFormatter {
        public MessageFormatter() {
            super(3);
        }

        public MessageFormatter(Text header, Text body) {
            this();
            Preconditions.checkNotNull(header, MessageEvent.PARAM_MESSAGE_HEADER);
            Preconditions.checkNotNull(body, MessageEvent.PARAM_MESSAGE_BODY);
            this.getHeader().add(new DefaultHeaderApplier(header));
            this.getBody().add(new DefaultBodyApplier(body));
        }

        public MessageFormatter(Text body) {
            this();
            Preconditions.checkNotNull(body, MessageEvent.PARAM_MESSAGE_BODY);
            this.getBody().add(new DefaultBodyApplier(body));
        }

        public SimpleTextFormatter getHeader() {
            return this.get(0);
        }

        public void setHeader(TextRepresentable header) {
            this.set(0, MessageEvent.PARAM_MESSAGE_HEADER, header);
        }

        public SimpleTextFormatter getBody() {
            return this.get(1);
        }

        public void setBody(TextRepresentable body) {
            this.set(1, MessageEvent.PARAM_MESSAGE_BODY, body);
        }

        public SimpleTextFormatter getFooter() {
            return this.get(2);
        }

        public void setFooter(TextRepresentable footer) {
            this.set(2, MessageEvent.PARAM_MESSAGE_FOOTER, footer);
        }

        private void set(int i, String key, TextRepresentable value) {
            Preconditions.checkNotNull(value, "value");
            SimpleTextFormatter partition = this.get(i);
            partition.clear();
            SimpleTextTemplateApplier applier = new SimpleTextTemplateApplier(TextTemplate.of(TextTemplate.arg(key)));
            applier.setParameter(key, value);
            partition.add(applier);
        }
    }
}

