/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.data.value.mutable.SetValue;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;

public final class ItemStackBuilderPopulators {
    public static BiConsumer<ItemStack.Builder, Random> itemStack(ItemStackSnapshot snapshot) {
        Preconditions.checkNotNull(snapshot, "ItemStackSnapshot cannot be null!");
        return (builder, random) -> builder.fromSnapshot(snapshot);
    }

    public static BiConsumer<ItemStack.Builder, Random> itemStacks(ItemStackSnapshot snapshot, ItemStackSnapshot ... snapshots) {
        Preconditions.checkNotNull(snapshot, "ItemStackSnapshot cannot be null!");
        WeightedTable<ItemStackSnapshot> table = new WeightedTable<ItemStackSnapshot>(1);
        table.add(snapshot, 1.0);
        for (ItemStackSnapshot stackSnapshot : snapshots) {
            table.add(Preconditions.checkNotNull(stackSnapshot, "ItemStackSnapshot cannot be null!"), 1.0);
        }
        return (builder, random) -> builder.fromSnapshot((ItemStackSnapshot)table.get((Random)random).get(0));
    }

    public static BiConsumer<ItemStack.Builder, Random> item(ItemType itemType) {
        Preconditions.checkNotNull(itemType, "ItemType cannot be null!");
        return (builder, random) -> builder.itemType(itemType);
    }

    public static BiConsumer<ItemStack.Builder, Random> item(Supplier<ItemType> supplier) {
        Preconditions.checkNotNull(supplier, "Supplier cannot be null!");
        return (builder, random) -> builder.itemType((ItemType)Preconditions.checkNotNull(supplier.get(), "Supplier returned a null ItemType"));
    }

    public static BiConsumer<ItemStack.Builder, Random> items(ItemType itemType, ItemType ... itemTypes) {
        return ItemStackBuilderPopulators.items(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(itemType)).addAll(Arrays.asList(itemTypes))).build());
    }

    public static BiConsumer<ItemStack.Builder, Random> items(Collection<ItemType> itemTypes) {
        ImmutableList<ItemType> copiedItemTypes = ImmutableList.copyOf(itemTypes);
        return (builder, random) -> builder.itemType((ItemType)copiedItemTypes.get(random.nextInt(copiedItemTypes.size())));
    }

    public static BiConsumer<ItemStack.Builder, Random> quantity(VariableAmount amount) {
        Preconditions.checkNotNull(amount, "VariableAmount cannot be null!");
        return (builder, random) -> builder.quantity(amount.getFlooredAmount((Random)random));
    }

    public static BiConsumer<ItemStack.Builder, Random> quantity(Supplier<VariableAmount> supplier) {
        Preconditions.checkNotNull(supplier, "Supplier cannot be null!");
        return (builder, random) -> builder.quantity(((VariableAmount)supplier.get()).getFlooredAmount((Random)random));
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> keyValue(Key<? extends BaseValue<E>> key, E value) {
        return (builder, random) -> {
            ItemStack itemStack = builder.build();
            DataTransactionResult dataTransactionResult = itemStack.offer(key, value);
            if (dataTransactionResult.isSuccessful()) {
                builder.from(itemStack);
            }
        };
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> keyValues(Key<? extends BaseValue<E>> key, Iterable<E> values) {
        Preconditions.checkNotNull(values, "Iterable cannot be null!");
        Preconditions.checkNotNull(key, "Key cannot be null!");
        WeightedTable tableEntries = new WeightedTable(1);
        for (E e : values) {
            tableEntries.add(Preconditions.checkNotNull(e, "Value cannot be null!"), 1.0);
        }
        return (builder, random) -> {
            ItemStack itemStack = builder.build();
            DataTransactionResult dataTransactionResult = itemStack.offer(key, tableEntries.get((Random)random).get(0));
            if (dataTransactionResult.isSuccessful()) {
                builder.from(itemStack);
            }
        };
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> listValues(Key<? extends ListValue<E>> key, List<E> elementPool, VariableAmount amount) {
        Preconditions.checkNotNull(key, "Key cannot be null!");
        Preconditions.checkNotNull(elementPool, "Element pool cannot be null!");
        Preconditions.checkNotNull(amount, "VariableAmount cannot be null!");
        Preconditions.checkArgument(!elementPool.isEmpty(), "Element pool cannot be empty!");
        WeightedTable<E> elementTable = new WeightedTable<E>(amount);
        for (E element : elementPool) {
            elementTable.add(Preconditions.checkNotNull(element, "Element cannot be null!"), 1.0);
        }
        return ItemStackBuilderPopulators.listValues(key, elementTable);
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> listValues(Key<? extends ListValue<E>> key, List<E> elementPool) {
        return ItemStackBuilderPopulators.listValues(key, elementPool, VariableAmount.baseWithRandomAddition(1.0, elementPool.size() - 1));
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> listValues(Key<? extends ListValue<E>> key, WeightedTable<E> weightedTable) {
        Preconditions.checkNotNull(weightedTable, "Weighted table cannot be null!");
        Preconditions.checkNotNull(key, "Key cannot be null!");
        return ItemStackBuilderPopulators.setValue(key, random -> ImmutableList.copyOf(weightedTable.get((Random)random)));
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> listValueSuppliers(Key<? extends ListValue<E>> key, WeightedTable<Function<Random, E>> weightedTable) {
        Preconditions.checkNotNull(key, "Key cannot be null!");
        Preconditions.checkNotNull(weightedTable, "WeightedTable cannot be null!");
        return (builder, random) -> {
            List suppliers;
            List suppliedElements;
            ItemStack itemStack = builder.build();
            DataTransactionResult result = itemStack.offer(key, suppliedElements = (suppliers = weightedTable.get((Random)random)).stream().map(randomEFunction -> randomEFunction.apply(random)).collect(Collectors.toList()));
            if (result.isSuccessful()) {
                builder.from(itemStack);
            }
        };
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> setValues(Key<? extends SetValue<E>> key, Set<E> elementPool) {
        Preconditions.checkNotNull(key, "Key cannot be null!");
        Preconditions.checkNotNull(elementPool, "ElementPool cannot be null!");
        return ItemStackBuilderPopulators.setValues(key, elementPool, VariableAmount.baseWithRandomAddition(1.0, elementPool.size() - 1));
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> setValues(Key<? extends SetValue<E>> key, Set<E> elementPool, VariableAmount amount) {
        Preconditions.checkNotNull(key, "Key cannot be null!");
        Preconditions.checkNotNull(elementPool, "Element pool cannot be null!");
        Preconditions.checkNotNull(amount, "VariableAmount cannot be null!");
        Preconditions.checkArgument(!elementPool.isEmpty());
        WeightedTable<E> elementTable = new WeightedTable<E>(amount);
        for (E element : elementPool) {
            elementTable.add(element, 1.0);
        }
        return ItemStackBuilderPopulators.setValues(key, elementTable);
    }

    public static <E> BiConsumer<ItemStack.Builder, Random> setValues(Key<? extends SetValue<E>> key, WeightedTable<E> weightedTable) {
        Preconditions.checkNotNull(weightedTable, "WeightedTable cannot be null!");
        Preconditions.checkNotNull(key, "Key cannot be null!");
        Preconditions.checkArgument(!weightedTable.isEmpty(), "WeightedTable cannot be empty!");
        return ItemStackBuilderPopulators.setValue(key, random -> ImmutableSet.copyOf(weightedTable.get((Random)random)));
    }

    private static <E> BiConsumer<ItemStack.Builder, Random> setValue(Key<? extends BaseValue<E>> key, Function<Random, E> element) {
        return (builder, random) -> {
            ItemStack itemStack = builder.build();
            DataTransactionResult result = itemStack.offer(key, element.apply((Random)random));
            if (result.isSuccessful()) {
                builder.from(itemStack);
            }
        };
    }

    public static <E, V extends BaseValue<E>> BiConsumer<ItemStack.Builder, Random> value(V value) {
        return (builder, random) -> {
            ItemStack itemStack = builder.build();
            DataTransactionResult dataTransactionResult = itemStack.offer(value);
            if (dataTransactionResult.isSuccessful()) {
                builder.from(itemStack);
            }
        };
    }

    public static <E, V extends BaseValue<E>> BiConsumer<ItemStack.Builder, Random> values(Iterable<V> values) {
        WeightedTable<BaseValue> tableEntries = new WeightedTable<BaseValue>(1);
        for (BaseValue value : values) {
            tableEntries.add(Preconditions.checkNotNull(value, "Value cannot be null!"), 1.0);
        }
        return (builder, random) -> {
            BaseValue value = (BaseValue)tableEntries.get((Random)random).get(0);
            ItemStack itemStack = builder.build();
            DataTransactionResult result = itemStack.offer(value);
            if (result.isSuccessful()) {
                builder.from(itemStack);
            }
        };
    }

    public static BiConsumer<ItemStack.Builder, Random> data(DataManipulator<?, ?> manipulator) {
        Preconditions.checkNotNull(manipulator, "DataManipulator cannot be null!");
        return (builder, random) -> builder.itemData(manipulator);
    }

    public static BiConsumer<ItemStack.Builder, Random> data(Collection<DataManipulator<?, ?>> manipulators) {
        Preconditions.checkNotNull(manipulators, "DataManipulators cannot be null!");
        WeightedTable table = new WeightedTable();
        manipulators.forEach(manipulator -> table.add(Preconditions.checkNotNull(manipulator, "DataManipulator cannot be null!"), 1.0));
        return (builder, random) -> builder.itemData((DataManipulator)table.get((Random)random).get(0));
    }

    public static BiConsumer<ItemStack.Builder, Random> data(Collection<DataManipulator<?, ?>> manipulators, VariableAmount rolls) {
        Preconditions.checkNotNull(manipulators, "Manipulators cannot be null!");
        Preconditions.checkNotNull(rolls, "VariableAmount cannot be null!");
        ImmutableList<DataManipulator<?, ?>> copied = ImmutableList.copyOf(manipulators);
        WeightedTable table = new WeightedTable();
        table.setRolls(rolls);
        copied.forEach((Consumer<DataManipulator<?, ?>>)((Consumer<DataManipulator>)manipulator1 -> table.add((DataManipulator<?, ?>)manipulator1, 1.0)));
        return ItemStackBuilderPopulators.data(table);
    }

    public static BiConsumer<ItemStack.Builder, Random> data(WeightedTable<DataManipulator<?, ?>> weightedTable) {
        Preconditions.checkNotNull(weightedTable, "WeightedTable cannot be null!");
        return (builder, random) -> weightedTable.get((Random)random).forEach(builder::itemData);
    }

    public static BiConsumer<ItemStack.Builder, Random> enchantment(EnchantmentType enchantmentType) {
        return ItemStackBuilderPopulators.enchantment(VariableAmount.fixed(1.0), enchantmentType);
    }

    public static BiConsumer<ItemStack.Builder, Random> enchantment(VariableAmount level, EnchantmentType enchantmentType) {
        Preconditions.checkNotNull(level, "VariableAmount cannot be null!");
        Preconditions.checkNotNull(enchantmentType, "EnchantmentType cannot be null!");
        return ItemStackBuilderPopulators.enchantments(VariableAmount.fixed(1.0), ImmutableList.of(new Tuple<EnchantmentType, VariableAmount>(enchantmentType, level)));
    }

    public static BiConsumer<ItemStack.Builder, Random> enchantmentsWithVanillaLevelVariance(Collection<EnchantmentType> enchantmentTypes) {
        return ItemStackBuilderPopulators.enchantmentsWithVanillaLevelVariance(VariableAmount.fixed(1.0), ImmutableList.copyOf(enchantmentTypes));
    }

    public static BiConsumer<ItemStack.Builder, Random> enchantmentsWithVanillaLevelVariance(VariableAmount amount, EnchantmentType enchantmentType, EnchantmentType ... enchantmentTypes) {
        return ItemStackBuilderPopulators.enchantmentsWithVanillaLevelVariance(amount, ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(enchantmentType)).addAll(Arrays.asList(enchantmentTypes))).build());
    }

    public static BiConsumer<ItemStack.Builder, Random> enchantmentsWithVanillaLevelVariance(VariableAmount amount, Collection<EnchantmentType> itemEnchantmentTypes) {
        Preconditions.checkNotNull(amount, "Variable amount cannot be null!");
        Preconditions.checkNotNull(itemEnchantmentTypes, "EnchantmentType collection cannot be null!");
        List<Tuple<EnchantmentType, VariableAmount>> list = itemEnchantmentTypes.stream().map(enchantment -> {
            Preconditions.checkNotNull(enchantment, "EnchantmentType cannot be null!");
            int minimum = enchantment.getMinimumLevel();
            int maximum = enchantment.getMaximumLevel();
            return new Tuple<EnchantmentType, VariableAmount>((EnchantmentType)enchantment, VariableAmount.baseWithRandomAddition((double)minimum, maximum - minimum));
        }).collect(Collectors.toList());
        return ItemStackBuilderPopulators.enchantments(amount, list);
    }

    public static BiConsumer<ItemStack.Builder, Random> enchantments(VariableAmount amount, Collection<Tuple<EnchantmentType, VariableAmount>> enchantments) {
        Preconditions.checkNotNull(amount, "VariableAmount cannot be null!");
        WeightedTable suppliers = new WeightedTable(amount);
        for (Tuple<EnchantmentType, VariableAmount> enchantment : enchantments) {
            suppliers.add(random -> Enchantment.builder().type((EnchantmentType)enchantment.getFirst()).level(((VariableAmount)enchantment.getSecond()).getFlooredAmount((Random)random)).build(), 1.0);
        }
        return ItemStackBuilderPopulators.listValueSuppliers(Keys.ITEM_ENCHANTMENTS, suppliers);
    }

    private ItemStackBuilderPopulators() {
        throw new AssertionError((Object)"You should not be attempting to instantiate this class.");
    }
}

