/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.recipe.crafting;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;

public final class CraftingResult {
    private final ItemStackSnapshot result;
    private final List<ItemStackSnapshot> remainingItems;

    public CraftingResult(ItemStackSnapshot result, List<ItemStackSnapshot> remainingItems) {
        Preconditions.checkNotNull(result, "result");
        Preconditions.checkArgument(result != ItemStackSnapshot.NONE, "The result must not be ItemStackSnapshot.NONE.");
        Preconditions.checkNotNull(remainingItems, "remainingItems");
        Preconditions.checkArgument(!remainingItems.isEmpty(), "The remainingItems list must not be empty. It should contain ItemStackSnapshot.NONE values for slots which should be cleared.");
        this.result = result;
        this.remainingItems = ImmutableList.copyOf(remainingItems);
    }

    public ItemStackSnapshot getResult() {
        return this.result;
    }

    public List<ItemStackSnapshot> getRemainingItems() {
        return this.remainingItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CraftingResult that = (CraftingResult)o;
        return this.result.equals(that.result) && this.remainingItems.equals(that.remainingItems);
    }

    public int hashCode() {
        int result1 = this.result.hashCode();
        result1 = 31 * result1 + this.remainingItems.hashCode();
        return result1;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("result", this.result).add("remainingItems", this.remainingItems).toString();
    }
}

