/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.profile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.api.util.Identifiable;

public interface GameProfile
extends Identifiable,
DataSerializable {
    public static GameProfile of(UUID uniqueId) {
        return GameProfile.of(uniqueId, null);
    }

    public static GameProfile of(UUID uniqueId, @Nullable String name) {
        return Sponge.getServer().getGameProfileManager().createProfile(uniqueId, name);
    }

    public Optional<String> getName();

    public Multimap<String, ProfileProperty> getPropertyMap();

    default public GameProfile addProperty(ProfileProperty property) {
        Preconditions.checkNotNull(property, "property");
        return this.addProperty(property.getName(), property);
    }

    default public GameProfile addProperty(String name, ProfileProperty property) {
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkNotNull(property, "property");
        this.getPropertyMap().put(name, property);
        return this;
    }

    default public boolean removeProperty(ProfileProperty property) {
        Preconditions.checkNotNull(property, "property");
        return this.getPropertyMap().remove(property.getName(), property);
    }

    default public boolean removeProperty(String name, ProfileProperty property) {
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkNotNull(property, "property");
        return this.getPropertyMap().remove(name, property);
    }

    public boolean isFilled();
}

