/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.ShiftClickAction;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextFormat;
import org.spongepowered.api.text.format.TextStyle;

public final class LiteralText
extends Text {
    static final LiteralText EMPTY = new LiteralText("");
    final String content;

    LiteralText(String content) {
        this.content = Preconditions.checkNotNull(content, "content");
    }

    LiteralText(TextFormat format, ImmutableList<Text> children, @Nullable ClickAction<?> clickAction, @Nullable HoverAction<?> hoverAction, @Nullable ShiftClickAction<?> shiftClickAction, String content) {
        super(format, children, clickAction, hoverAction, shiftClickAction);
        this.content = Preconditions.checkNotNull(content, "content");
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LiteralText) || !super.equals(o)) {
            return false;
        }
        LiteralText that = (LiteralText)o;
        return this.content.equals(that.content);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.content);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().addValue(this.content);
    }

    public static class Builder
    extends Text.Builder {
        private String content;

        Builder() {
            this("");
        }

        Builder(String content) {
            this.content(content);
        }

        Builder(Text text, String content) {
            super(text);
            this.content(content);
        }

        Builder(LiteralText text) {
            super(text);
            this.content = text.content;
        }

        public final String getContent() {
            return this.content;
        }

        public Builder content(String content) {
            this.content = Preconditions.checkNotNull(content, "content");
            return this;
        }

        @Override
        public LiteralText build() {
            if (this.format.isEmpty() && this.children.isEmpty() && this.clickAction == null && this.hoverAction == null && this.shiftClickAction == null) {
                if (this.content.isEmpty()) {
                    return EMPTY;
                }
                if (this.content.equals("\n")) {
                    return Text.NEW_LINE;
                }
            }
            return new LiteralText(this.format, ImmutableList.copyOf(this.children), this.clickAction, this.hoverAction, this.shiftClickAction, this.content);
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Builder) || !super.equals(o)) {
                return false;
            }
            Builder that = (Builder)o;
            return Objects.equal(this.content, that.content);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(super.hashCode(), this.content);
        }

        @Override
        MoreObjects.ToStringHelper toStringHelper() {
            return super.toStringHelper().addValue(this.content);
        }

        @Override
        public Builder format(TextFormat format) {
            return (Builder)super.format(format);
        }

        @Override
        public Builder color(TextColor color) {
            return (Builder)super.color(color);
        }

        @Override
        public Builder style(TextStyle ... styles) {
            return (Builder)super.style(styles);
        }

        @Override
        public Builder onClick(@Nullable ClickAction<?> clickAction) {
            return (Builder)super.onClick(clickAction);
        }

        @Override
        public Builder onHover(@Nullable HoverAction<?> hoverAction) {
            return (Builder)super.onHover(hoverAction);
        }

        @Override
        public Builder onShiftClick(@Nullable ShiftClickAction<?> shiftClickAction) {
            return (Builder)super.onShiftClick(shiftClickAction);
        }

        @Override
        public Builder append(Text ... children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder append(Collection<? extends Text> children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder append(Iterable<? extends Text> children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder append(Iterator<? extends Text> children) {
            return (Builder)super.append(children);
        }

        @Override
        public Builder insert(int pos, Text ... children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder insert(int pos, Collection<? extends Text> children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder insert(int pos, Iterable<? extends Text> children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder insert(int pos, Iterator<? extends Text> children) {
            return (Builder)super.insert(pos, children);
        }

        @Override
        public Builder remove(Text ... children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder remove(Collection<? extends Text> children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder remove(Iterable<? extends Text> children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder remove(Iterator<? extends Text> children) {
            return (Builder)super.remove(children);
        }

        @Override
        public Builder removeAll() {
            return (Builder)super.removeAll();
        }
    }
}

