/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.action;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.TextAction;
import org.spongepowered.api.util.Identifiable;

public abstract class HoverAction<R>
extends TextAction<R> {
    HoverAction(R result) {
        super(result);
    }

    @Override
    public void applyTo(Text.Builder builder) {
        builder.onHover(this);
    }

    public static final class ShowEntity
    extends HoverAction<Ref> {
        ShowEntity(Ref ref) {
            super(ref);
        }

        public static final class Ref
        implements Identifiable {
            private final UUID uuid;
            private final String name;
            private final Optional<EntityType> type;

            public Ref(UUID uuid, String name, @Nullable EntityType type) {
                this(uuid, name, Optional.ofNullable(type));
            }

            public Ref(UUID uuid, String name) {
                this(uuid, name, Optional.empty());
            }

            public Ref(Entity entity, String name) {
                this(entity.getUniqueId(), name, entity.getType());
            }

            protected Ref(UUID uuid, String name, Optional<EntityType> type) {
                this.uuid = uuid;
                this.name = name;
                this.type = type;
            }

            @Override
            public UUID getUniqueId() {
                return this.uuid;
            }

            public String getName() {
                return this.name;
            }

            public Optional<EntityType> getType() {
                return this.type;
            }

            public boolean equals(Object obj) {
                if (super.equals(obj)) {
                    return true;
                }
                if (!(obj instanceof Ref)) {
                    return false;
                }
                Ref that = (Ref)obj;
                return this.uuid.equals(that.uuid) && this.name.equals(that.name) && this.type.equals(that.type);
            }

            public int hashCode() {
                return Objects.hashCode(this.uuid, this.name, this.type);
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("uuid", this.uuid).add("name", this.name).add("type", this.type).toString();
            }
        }
    }

    public static final class ShowItem
    extends HoverAction<ItemStackSnapshot> {
        ShowItem(ItemStackSnapshot item) {
            super(item);
        }
    }

    public static final class ShowText
    extends HoverAction<Text> {
        ShowText(Text text) {
            super(text);
        }
    }
}

