/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.channel;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;

public abstract class AbstractMutableMessageChannel
implements MutableMessageChannel {
    protected final Collection<MessageReceiver> members;

    protected AbstractMutableMessageChannel() {
        this(Collections.newSetFromMap(new WeakHashMap()));
    }

    protected AbstractMutableMessageChannel(Collection<MessageReceiver> members) {
        this.members = Preconditions.checkNotNull(members, "members");
    }

    @Override
    public boolean addMember(MessageReceiver member) {
        Preconditions.checkNotNull(member, "member");
        return !this.members.contains(member) && this.members.add(member);
    }

    @Override
    public boolean removeMember(MessageReceiver member) {
        Preconditions.checkNotNull(member, "member");
        return this.members.remove(member);
    }

    @Override
    public void clearMembers() {
        this.members.clear();
    }

    @Override
    public Collection<MessageReceiver> getMembers() {
        return this.members;
    }
}

