/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.channel;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextElement;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.chat.ChatType;

@FunctionalInterface
public interface ChatTypeMessageReceiver {
    public void sendMessage(ChatType var1, Text var2);

    default public void sendMessage(ChatType type, TextTemplate template) {
        this.sendMessage(type, Preconditions.checkNotNull(template, "template").apply().build());
    }

    default public void sendMessage(ChatType type, TextTemplate template, Map<String, TextElement> parameters) {
        this.sendMessage(type, Preconditions.checkNotNull(template, "template").apply(parameters).build());
    }

    default public void sendMessages(ChatType type, Text ... messages) {
        Preconditions.checkNotNull(type, "type");
        for (Text message : Preconditions.checkNotNull(messages, "messages")) {
            this.sendMessage(type, message);
        }
    }

    default public void sendMessages(ChatType type, Iterable<Text> messages) {
        Preconditions.checkNotNull(type, "type");
        for (Text message : Preconditions.checkNotNull(messages, "messages")) {
            this.sendMessage(type, message);
        }
    }
}

